/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.shouts;

import com.bmc.ctmconvert.utils.PropertiesBuilder;
import java.util.Properties;

public abstract class ShoutBuilder {
    public static final Destination EM = new Destination("EM");
    public static final Destination CONSOLE = new Destination("CONSOLE");
    public static final Destination LOG = new Destination("IOALOG");
    private final PropertiesBuilder builder = new PropertiesBuilder();

    protected ShoutBuilder() {
    }

    public ShoutBuilder setDefaults() {
        this.addDestination(EM);
        return this.addUrgency(Urgency.REGULAR);
    }

    public Properties build() {
        return this.builder.build();
    }

    public ShoutBuilder addUrgency(Urgency urgency) {
        return this.setProperty("URGENCY", urgency.toString());
    }

    public ShoutBuilder addDestination(Destination destination) {
        return this.setProperty("DEST", destination.toString());
    }

    public ShoutBuilder addMessage(String message) {
        return this.setProperty("MESSAGE", message);
    }

    protected ShoutBuilder setProperty(String key, String value) {
        this.builder.setProperty(key, value);
        return this;
    }

    public static class Destination {
        private final String data;

        public Destination(String destination) {
            this.data = destination;
        }

        public String toString() {
            return this.data;
        }
    }

    public static enum Urgency {
        REGULAR("R"),
        URGENT("U"),
        VERY_URGENT("V");

        private final String data;

        private Urgency(String urgency) {
            this.data = urgency;
        }

        public String toString() {
            return this.data;
        }
    }
}

