/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.sap;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.sap.StartCondition;
import com.bmc.ctmconvert.sap.Step;
import java.util.Map;

public class SapR3CreateWrapper {
    private final SchedEntity job;

    public SapR3CreateWrapper(SchedEntity job) {
        this.job = job;
    }

    public static SapR3CreateWrapper convertToSapJob(SchedEntity job) {
        SapR3CreateWrapper createWrapper = new SapR3CreateWrapper(job);
        if (GlobalFunctions.JobHasAutoedit.negate().test(job, "%%SAPR3-ACCOUNT")) {
            job.addAutoEdits("%%SAPR3-ACCOUNT", "DEFAULT_ACCOUNT");
        }
        job.addAutoEdits("%%SAPR3-DETECT_CHILD_TABLE", job.getOriginalJobName());
        job.addAutoEdits("%%SAPR3-JOBCLASS", "C");
        job.addAutoEdits("%%SAPR3-GROUP_ORDID", "%%GROUP_ORDID");
        job.addAutoEdits("%%SAPR3-GROUP_ORDID", "%%GROUP_ORDID");
        job.addAutoEdits("%%SAPR3-JOB_MODE", "CREATE");
        job.addAutoEdits("%%SAPR3-XBP_VERSION", "XBP20");
        job.addAutoEdits("%%SAPR3-DETECT_OPTION", "1");
        job.addAutoEdits("%%SAPR3-JOBCOUNT", "LAST_SCHEDULED");
        job.addAutoEdits("%%SAPR3-JOB_COUNT", "LAST_SCHEDULED");
        job.addAutoEdits("%%SAPR3-JOBLOG", "*SYSOUT");
        job.addAutoEdits("%%SAPR3-RECIP_TYPE", "B");
        job.addAutoEdits("%%SAPR3-SUBMIT_ASAP", "N");
        job.addAutoEdits("%%SAPR3-START_STEP", "1");
        return createWrapper;
    }

    public void setClass(String jobClass) {
        if ((jobClass = jobClass.toUpperCase()).equals("A") || jobClass.equals("B") || jobClass.equals("C")) {
            this.job.addAutoEdits("%%SAPR3-JOBCLASS", jobClass);
        }
    }

    public void addStep(Step step) {
        Map<String, String> stepAutoEdits = step.getAutoedits();
        for (Map.Entry<String, String> autoEdit : stepAutoEdits.entrySet()) {
            this.job.addAutoEdits(autoEdit.getKey(), autoEdit.getValue());
        }
    }

    public void setRecipient(String recipient) {
        this.job.addAutoEdits("%%SAPR3-RECIPIENT", recipient);
    }

    public void setInternetAddressRecipientType() {
        this.job.addAutoEdits("%%SAPR3-RECIP_TYPE", "U");
    }

    public void setDetectOption() {
        this.job.addAutoEdits("%%SAPR3-DETECT_OPTION", String.valueOf(2));
        this.job.addAutoEdits("%%SAPR3-DETECT_CHILD_RELEASE", "Y");
    }

    public void setSpool() {
        this.job.addAutoEdits("%%SAPR3-SPOOL", "*SYSOUT");
    }

    public void setDisableJoblog() {
        this.job.removeAutoEdits("%%SAPR3-JOBLOG");
    }

    public SapR3CreateWrapper setStartCondition(String value) {
        this.job.addAutoEdits("%%SAPR3-SUBMIT_ASAP", value);
        return this;
    }

    public SapR3CreateWrapper setStartCondition(StartCondition startCondition) {
        return this.setStartCondition(startCondition.toXmlValue());
    }

    public SapR3CreateWrapper setJobWaitChild() {
        this.job.addAutoEdits("%%SAPR3-JOB_WAIT_CHILD", "Y");
        return this;
    }
}

