/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.sap;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.sap.SapBWRerunOption;

public class SapBwWrapper {
    private final SchedEntity job;

    public SapBwWrapper(SchedEntity job) {
        this.job = job;
    }

    public void convertToSapJob() {
        Globs.SAP_TYPE_VERSION.forEach(this.job::addAttribute);
        this.job.addAttribute("APPL_FORM", "SAP Business Warehouse");
        if (!GlobalFunctions.jobHasTaskType.test(this.job)) {
            this.job.addAttribute("TASKTYPE", "Job");
        }
        this.job.addAutoEdits("%%SAPR3-PROCESS_TYPE", "ProcessChain");
        this.job.addAutoEdits("%%SAPR3-JOB_MODE", "PC_RUN_ORG");
        this.job.addAutoEdits("%%SAPR3-PROCESS_TYPE", "ProcessChain");
        this.job.addAutoEdits("%%SAPR3-PROCESSCHAIN_RERUN_INSTANCE", "PC_RUN_CURR_INSTANCE");
        this.job.addAutoEdits("%%SAPR3-PC_periodic", "X");
        this.job.addAutoEdits("%%SAPR3-PC_DONT_POLL", "N");
        this.job.addAutoEdits("%%SAPR3-JOBLOG", "*SYSOUT");
        this.job.addAutoEdits("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        this.job.addAutoEdits("%%SAPR3-RUNCOUNT", "%%RUNCOUNT");
        this.job.addAutoEdits("%%SAPR3-ACCOUNT", "DEFAULT_SAPBW_CONNECT");
    }

    public void setDescription(String value) {
        this.job.addAutoEdits("%%SAPR3-ProcessChain_Desc", value);
    }

    public String getDescription() {
        return this.job.getAutoedits().get("%%SAPR3-ProcessChain_Desc");
    }

    public SapBwWrapper setID(String value) {
        this.job.addAutoEdits("%%SAPR3-ProcessChain_ID", value);
        return this;
    }

    public String getID() {
        return this.job.getAutoedits().get("%%SAPR3-ProcessChain_ID");
    }

    public SapBwWrapper setConnectionProfile(String connectionProfile) {
        this.job.addAutoEdits("DEFAULT_SAPBW_CONNECT", connectionProfile);
        return this;
    }

    public String getConnectionProfile() {
        return this.job.getAutoedits().get("DEFAULT_SAPBW_CONNECT");
    }

    public void setReRunOption(SapBWRerunOption option) {
        this.job.addAutoEdits("%%SAPR3-PROCESSCHAIN_RERUN_INSTANCE", option.toString());
    }

    public SapBWRerunOption getReRunOption() {
        String value = this.job.getAutoedits().get("%%SAPR3-PROCESSCHAIN_RERUN_INSTANCE");
        return SapBWRerunOption.get(value);
    }
}

