/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ondo;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.ondo.Do;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class DoForceJob
extends Do {
    public static final String REMOTE_PROPERTY = "REMOTE";
    private final String tableName;
    private final String jobName;
    private final Do.REMOTE remote;
    private final String dataCenter;
    private final String odate;
    private Optional<String> uniqueFlow;
    private Optional<String> library;
    private final Map<String, String> variables;

    public DoForceJob(String tableName, Do.REMOTE remote) {
        this(tableName, remote, null);
    }

    public DoForceJob(String tableName, Do.REMOTE remote, String dataCenter) {
        this(tableName, null, remote, dataCenter, null);
    }

    public DoForceJob(String tableName, String jobName, Do.REMOTE remote, String dataCenter, String odate) {
        this(tableName, jobName, remote, dataCenter, odate, Optional.empty(), Optional.empty());
    }

    public DoForceJob(String tableName, String jobName, Do.REMOTE remote, String datacenter, String odate, String uniqueFlow, String library) {
        this(tableName, jobName, remote, datacenter, odate, Optional.ofNullable(uniqueFlow), Optional.ofNullable(library));
    }

    public DoForceJob(String tableName, String jobName, Do.REMOTE remote, String datacenter, String odate, Optional<String> uniqueFlow, Optional<String> library) {
        super("DOFORCEJOB");
        this.tableName = tableName;
        this.jobName = jobName;
        this.remote = remote;
        this.dataCenter = datacenter;
        this.odate = odate;
        this.uniqueFlow = uniqueFlow;
        this.library = library;
        this.variables = new LinkedHashMap<String, String>();
    }

    @Override
    protected Properties getDoProperties() {
        Properties doStatement = new Properties();
        doStatement.setProperty("ACTION", "DOFORCEJOB");
        doStatement.setProperty("TABLE_NAME", this.tableName);
        GlobalFunctions.ifPresent(this.jobName, () -> doStatement.setProperty("NAME", this.jobName));
        doStatement.setProperty(REMOTE_PROPERTY, this.remote.toString());
        GlobalFunctions.ifPresent(this.dataCenter, () -> doStatement.setProperty("DATACENTER", this.dataCenter));
        GlobalFunctions.ifPresent(this.odate, () -> doStatement.setProperty("ODATE", this.odate));
        if (!this.variables.isEmpty()) {
            doStatement.put("VARIABLE", this.variables);
        }
        this.library.ifPresent(lib -> doStatement.setProperty("DSN", (String)lib));
        this.uniqueFlow.ifPresent(uniqueFlow -> doStatement.setProperty("UFLOW", (String)uniqueFlow));
        return doStatement;
    }

    public DoForceJob putVariable(String name, String value) {
        this.variables.put(name, value);
        return this;
    }
}

