/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport.fileimporter;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.progress.ProgressListener;
import com.bmc.ctmconvert.progress.Progressable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;

public class FileMonitor
extends Progressable {
    private Path path;
    private String ID;

    public FileMonitor(Path path, String ID) {
        this.path = path;
        this.ID = ID;
    }

    public FileMonitor(Path path, String ID, ProgressListener listener) {
        this.path = path;
        this.ID = ID;
        this.addProgressListener(listener);
    }

    @Override
    public void run() {
        try {
            long size = 0L;
            while (!this.isStopped()) {
                if (!Files.isRegularFile(this.path, new LinkOption[0]) || size == Files.size(this.path)) continue;
                size = Files.size(this.path);
                this.setCurrentProgress(size);
            }
        }
        catch (IOException e) {
            ConversionLogger.getLogger().log(Level.INFO, String.format("Unable to monitor '%s' progress", this.path.getFileName()), e);
        }
    }

    @Override
    public String getID() {
        return this.ID;
    }
}

