/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport.autofiledetect;

import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.autofiledetect.DataForImportDetector;
import com.bmc.ctmconvert.dataimport.autofiledetect.DetectFileForEntry;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultDataForImportDetector
implements DataForImportDetector {
    private DetectFileForEntry entryDetector;
    private List<String> missingMandatoryFiles;
    private List<String> missingNoneMandatoryFiles;
    private Map<String, List<String>> duplicateMandatoryFiles;
    private Map<String, List<String>> duplicateNoneMandatoryFiles;

    public DefaultDataForImportDetector(DetectFileForEntry entryDetector) {
        this.initMessagesContainers();
        this.entryDetector = entryDetector;
    }

    @Override
    public boolean detectData(ImportEntryList entries, String sourcePath) {
        this.initMessagesContainers();
        boolean toRet = this.updateImportEntries(entries, sourcePath);
        this.reportMessages(sourcePath);
        return toRet;
    }

    private void initMessagesContainers() {
        ProcessAlertsManager.instance().init();
        this.missingMandatoryFiles = new ArrayList<String>();
        this.missingNoneMandatoryFiles = new ArrayList<String>();
        this.duplicateMandatoryFiles = new HashMap<String, List<String>>();
        this.duplicateNoneMandatoryFiles = new HashMap<String, List<String>>();
    }

    private boolean updateImportEntries(ImportEntryList entries, String sourcePath) {
        boolean toRet = true;
        List<Path> filesPath = this.getAllRegularFilesInDirectory(sourcePath);
        for (ImportEntry entry : entries) {
            String entryTitle = entry.getTitle();
            List<String> filesFoundForEntry = this.entryDetector.getFilesForEntry(entry, filesPath);
            entry.setSourceFullNames(filesFoundForEntry);
            if (filesFoundForEntry.size() == 1) {
                entry.setSourceFullName(filesFoundForEntry.get(0));
                continue;
            }
            if (filesFoundForEntry.isEmpty()) {
                if (entry.isMandatory()) {
                    toRet = false;
                    this.missingMandatoryFiles.add(entryTitle);
                    continue;
                }
                this.missingNoneMandatoryFiles.add(entryTitle);
                continue;
            }
            if (this.entryDetector.isDuplicateFilesSupported()) continue;
            if (entry.isMandatory()) {
                toRet = false;
                this.duplicateMandatoryFiles.put(entryTitle, filesFoundForEntry);
                continue;
            }
            this.duplicateNoneMandatoryFiles.put(entryTitle, filesFoundForEntry);
        }
        return toRet;
    }

    private List<Path> getAllRegularFilesInDirectory(String directoryPath) {
        List<Path> list;
        block8: {
            Stream<Path> pathStream = Files.find(Paths.get(directoryPath, new String[0]), Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]);
            try {
                list = pathStream.collect(Collectors.toList());
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return new ArrayList<Path>();
                }
            }
            pathStream.close();
        }
        return list;
    }

    private void reportMessages(String sourcePath) {
        String lineSeperator = "------------------------------------------------------------------------";
        if (!(this.missingMandatoryFiles.isEmpty() && this.missingNoneMandatoryFiles.isEmpty() && this.duplicateMandatoryFiles.isEmpty() && this.duplicateNoneMandatoryFiles.isEmpty())) {
            ProcessAlertsManager.instance().addMessage("Source directory: \n" + sourcePath + "\n" + lineSeperator);
            if (!this.missingMandatoryFiles.isEmpty()) {
                String missingMandtoryMessage = TextManager.instance().get("AUTO_DETECT_MESSAGE_MISSING_MANDATORY_FILES_TEXT");
                missingMandtoryMessage = String.format(missingMandtoryMessage, Character.valueOf('\n'));
                ProcessAlertsManager.instance().addMessage("\n" + missingMandtoryMessage + ":\n" + lineSeperator);
                this.addToProcessAlertsManager(this.missingMandatoryFiles);
            }
            if (!this.duplicateMandatoryFiles.isEmpty()) {
                ProcessAlertsManager.instance().addMessage("\nFollowing mandatory entry has more than one files:\n" + lineSeperator);
                this.addToProcessAlertsManager(this.duplicateMandatoryFiles);
            }
            if (!this.missingNoneMandatoryFiles.isEmpty()) {
                String missingOptionalMessage = TextManager.instance().get("AUTO_DETECT_MESSAGE_MISSING_OPTIONAL_FILES_TEXT");
                missingOptionalMessage = String.format(missingOptionalMessage, Character.valueOf('\n'));
                ProcessAlertsManager.instance().addMessage("\n" + missingOptionalMessage + ":\n" + lineSeperator);
                this.addToProcessAlertsManager(this.missingNoneMandatoryFiles);
            }
            if (!this.duplicateNoneMandatoryFiles.isEmpty()) {
                ProcessAlertsManager.instance().addMessage("\nFollowing optional entry has more than one files:\n" + lineSeperator);
                this.addToProcessAlertsManager(this.duplicateNoneMandatoryFiles);
            }
        }
    }

    private void addToProcessAlertsManager(List<String> errorMessages) {
        for (String message : errorMessages) {
            ProcessAlertsManager.instance().addMessage(message);
        }
    }

    private void addToProcessAlertsManager(Map<String, List<String>> entryTitle) {
        String COMMA = ", ";
        for (String title : entryTitle.keySet()) {
            Object message = title + ": ";
            for (String file : entryTitle.get(title)) {
                message = (String)message + file + COMMA;
            }
            if (((String)message).endsWith(COMMA)) {
                message = ((String)message).substring(0, ((String)message).length() - 2);
                message = (String)message + ".\n";
            }
            ((String)message).replaceAll(", $", "");
            ProcessAlertsManager.instance().addMessage((String)message);
        }
    }
}

