/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport;

import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public class DirectoryRunner {
    private Path directory;

    public DirectoryRunner(Path path) {
        this.directory = path;
    }

    public void runOnFiles(BiConsumer<Path, InputStream> consumer) throws IOException {
        try (Stream<Path> filesList = Files.list(this.directory);){
            filesList.forEach(path -> {
                try {
                    InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                    consumer.accept((Path)path, inputStream);
                    inputStream.close();
                }
                catch (IOException e) {
                    ExceptionHandler.writeToExceptionFile(e);
                }
            });
        }
    }
}

