/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.ImportDetails;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImporterType;
import java.io.StringWriter;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class AbstractImportEntity
implements ImportEntry,
Comparable<ImportEntry> {
    public static final String nodeName = "ImportEntry";
    protected Element entry;
    private Element userInputEntry;
    protected String ID;
    protected ImporterType type;
    protected String title;
    protected String tooltip;
    protected boolean mandatory;
    protected String[] extensionFilter;
    protected String description;
    protected String sourceFullName;
    protected List<String> sourceFullNames;
    protected String destinationFileName;
    protected String commmand;
    protected String tableName;
    protected ImportDetails details;
    protected String destinationPath;

    protected AbstractImportEntity(Element entry, Element defaultEntry, ImportDetails details) {
        this.entry = entry;
        this.userInputEntry = defaultEntry;
        if (entry != null) {
            this.ID = this.getAttributeValue("ID");
            this.type = ImporterType.getEnumFromName(this.getAttributeValue("Type"));
            this.title = this.getAttributeValue("Title");
            this.tooltip = this.getAttributeValue("Tooltip");
            this.mandatory = this.getAttributeValue("Mandatory").equalsIgnoreCase("YES");
            this.extensionFilter = this.getAttributeValue("ExtensionFilter").replace(" ", "").split(",");
            this.description = this.getAttributeValue("Description");
            this.sourceFullName = this.getAttributeValue("SourceFullName");
            this.destinationFileName = this.getAttributeValue("DestinationFileName");
            this.commmand = this.getAttributeValue("Commmand");
            this.tableName = this.getAttributeValue("TableName");
        }
        this.details = details;
    }

    protected String getAttributeValue(String attr) {
        String tmpValue;
        String value = "";
        if (this.entry.hasAttribute(attr)) {
            value = this.entry.getAttribute(attr);
        }
        if (this.userInputEntry != null && this.userInputEntry.hasAttribute(attr) && (tmpValue = this.userInputEntry.getAttribute(attr)) != null && !tmpValue.isEmpty()) {
            value = tmpValue;
        }
        return value;
    }

    @Override
    public String getID() {
        return this.ID;
    }

    public void setID(String iD) {
        this.ID = iD;
    }

    @Override
    public ImporterType getType() {
        return this.type;
    }

    public void setType(ImporterType type) {
        this.type = type;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    public String[] getExtensionFilter() {
        return this.extensionFilter;
    }

    public void setExtensionFilter(String[] extensionFilter) {
        this.extensionFilter = extensionFilter;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getSourceFullName() {
        return this.sourceFullName;
    }

    @Override
    public void setSourceFullName(String sourceFullName) {
        this.sourceFullName = sourceFullName;
    }

    @Override
    public void setSourceFullNames(List<String> names) {
        this.sourceFullNames = names;
    }

    @Override
    public List<String> getSourceFullNames() {
        return this.sourceFullNames;
    }

    @Override
    public String getDestinationFileName() {
        return this.destinationFileName;
    }

    public void setDestinationFileName(String destinationFileName) {
        this.destinationFileName = destinationFileName;
    }

    @Override
    public String getCommmand() {
        return this.commmand;
    }

    public void setCommmand(String commmand) {
        this.commmand = commmand;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public ImportDetails getImportDetails() {
        return this.details;
    }

    public void setImportDetails(ImportDetails details) {
        this.details = details;
    }

    @Override
    public int compareTo(ImportEntry o) {
        int toRet = 0;
        int mandatory = this.isMandatory() ? 1 : 0;
        int oMandatory = o.isMandatory() ? 1 : 0;
        toRet = mandatory - oMandatory == 0 ? this.getTitle().compareTo(o.getTitle()) : oMandatory - mandatory;
        return toRet;
    }

    @Override
    public void updateXMLElement() {
        NamedNodeMap attributes = this.entry.getAttributes();
        if (attributes != null) {
            for (int index = 0; index < attributes.getLength(); ++index) {
                Node keyNode = attributes.item(index);
                if (keyNode == null) continue;
                keyNode.setNodeValue(this.getNodeValue(keyNode));
            }
            if (this.sourceFullNames != null && !this.sourceFullNames.isEmpty()) {
                this.sourceFullNames.forEach(filePath -> {
                    Element file = this.entry.getOwnerDocument().createElement("sourceFullName");
                    Text fileName = this.entry.getOwnerDocument().createTextNode((String)filePath);
                    file.appendChild(fileName);
                    this.entry.appendChild(file);
                });
            }
        }
    }

    private String getNodeValue(Node keyNode) {
        Object value = "";
        switch (keyNode.getNodeName()) {
            case "ID": {
                value = this.getID();
                break;
            }
            case "Type": {
                value = this.getType().toString();
                break;
            }
            case "Title": {
                value = this.getTitle();
                break;
            }
            case "Tooltip": {
                value = this.getTooltip();
                break;
            }
            case "Mandatory": {
                value = this.isMandatory() ? "YES" : "NO";
                break;
            }
            case "ExtensionFilter": {
                for (String extension : this.getExtensionFilter()) {
                    value = (String)value + extension + ",";
                }
                if (!((String)value).endsWith(",")) break;
                value = ((String)value).substring(0, ((String)value).length());
                break;
            }
            case "Description": {
                value = this.getDescription();
                break;
            }
            case "SourceFullName": {
                value = this.getSourceFullName();
                break;
            }
            case "DestinationFileName": {
                value = this.getDestinationFileName();
                break;
            }
            case "Commmand": {
                value = this.getCommmand();
                break;
            }
            case "TableName": {
                value = this.getCommmand();
                break;
            }
        }
        return value;
    }

    public String toString() {
        String xmlString = "";
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(this.entry);
            transformer.transform(source, result);
            xmlString = result.getWriter().toString();
        }
        catch (IllegalArgumentException | TransformerException | TransformerFactoryConfigurationError e) {
            ConversionLogger.getLogger().info(String.format("Unable to convert entity %s element to String: %s", this.getID(), e.getMessage()));
        }
        return xmlString;
    }

    public String getDestinationFilePath() {
        return this.destinationPath;
    }

    @Override
    public void setDestinationPath(String absolutePath) {
        this.destinationPath = absolutePath;
    }
}

