/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.log;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class Logger {
    private static final String LINE_SEP = "*************************************************";
    private static Logger logger = null;
    private OutputStream outputStream = null;

    private Logger() {
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeToLog(String message) {
        System.out.println((String)message);
        if (this.outputStream != null) {
            try {
                message = (String)message + "\n*************************************************\n";
                this.outputStream.write(((String)message).getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeToLogOnly(String message) {
        if (this.outputStream != null) {
            try {
                message = (String)message + "\n";
                this.outputStream.write(((String)message).getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeToLog(Exception e) {
        if (this.outputStream != null) {
            Object stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
            stackTrace = (String)stackTrace + "\n*************************************************\n";
            try {
                this.outputStream.write(((String)stackTrace).getBytes());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

