/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.log;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.exceptions.GUITextFileNotFoundException;
import com.bmc.ctmconvert.common.log.LogFormatter;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ConversionLogger {
    private static Logger logger = new NullLogger();

    public static void InitLogging() throws GUITextFileNotFoundException {
        Logger logger = Logger.getLogger("Conversion");
        logger.setLevel(Level.FINEST);
        String timeStamp = String.format("%d.%d.%d-%d.%d.%d", GregorianCalendar.getInstance().get(2) + 1, GregorianCalendar.getInstance().get(5), GregorianCalendar.getInstance().get(1), GregorianCalendar.getInstance().get(11), GregorianCalendar.getInstance().get(12), GregorianCalendar.getInstance().get(13));
        try {
            FileHandler fhandler = new FileHandler(Globs.LOGS_DIR + "conversion" + timeStamp + ".log");
            LogFormatter logFormatter = new LogFormatter();
            fhandler.setFormatter(logFormatter);
            logger.addHandler(fhandler);
            logger.setUseParentHandlers(false);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
            throw new GUITextFileNotFoundException();
        }
        ConversionLogger.logger = logger;
    }

    public static Logger getLogger() {
        return logger;
    }

    private static class NullLogger
    extends Logger {
        public NullLogger() {
            super(null, null);
        }

        @Override
        public void log(LogRecord record) {
        }
    }
}

