/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopBaseJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopOptionsFactory;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.BaseHadoopJob;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.HadoopOption;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.HadoopSparkJava;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class HadoopSparkJavaAdapter
extends HadoopBaseJobAdapter<HadoopSparkJava.Type> {
    private static final Pattern SPARK_OPTIONS_PATTERN = Pattern.compile("HDP-SPARK_OPTION-N([0-9]{3})-(NAME|VAL)");

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.getAllUsedVariablesInHadoopBasejob();
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getProgramJar()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getMainClass()));
        Stream.ofNullable(this.getOptions()).forEach(option -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(option.toString())));
        return usedVariablesFromStr;
    }

    public HadoopSparkJavaAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    @Override
    protected BaseHadoopJob buildBaseHadoopJob() {
        return new HadoopSparkJava().withProgramJar(this.getProgramJar()).withMainClass(this.getMainClass()).withSparkOptions(this.getOptions());
    }

    private String getMainClass() {
        return this.schedEntity.getVariable("%%HDP-SPARK_MAIN_CLASS_TO_RUN");
    }

    private String getProgramJar() {
        return this.schedEntity.getVariable("%%HDP-SPARK_APP_JAR_FULL_PATH");
    }

    @Override
    public HadoopSparkJava.Type getType() {
        return HadoopSparkJava.Type.JOB_HADOOP_SPARK_SCALA_JAVA;
    }

    private List<HadoopOption> getOptions() {
        return new HadoopOptionsFactory().getOptions(this.getVariablesAdapter(), SPARK_OPTIONS_PATTERN);
    }
}

