/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.database;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariableWrapper;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariablesAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.database.BaseDatabaseJobAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseDatabaseJob;
import com.bmc.ctmconvert.generated.json.models.job_types.Parameter;
import com.bmc.ctmconvert.generated.json.models.job_types.SQLScriptJob;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class SQLScriptJobAdapter
extends BaseDatabaseJobAdapter<SQLScriptJob.Type> {
    public static final String DB_SCRPT_NAME = "%%DB-SCRPT_NAME";
    public static final String VARIABLE = "VARIABLE";
    public static final Pattern DB_SCRPT_PARMS = Pattern.compile("DB-SCRPT_PARMS-P([0-9]{3})-(VARIABLE|VALUE)");

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.variablesAdapter.getUsedVariablesFromStr(this.getSqlScript());
        Stream.ofNullable(this.getParameters()).forEach(param -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(param.toString())));
        return usedVariablesFromStr;
    }

    public SQLScriptJobAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    @Override
    public SQLScriptJob.Type getType() {
        return SQLScriptJob.Type.JOB_DATABASE_SQL_SCRIPT;
    }

    @Override
    protected BaseDatabaseJob buildBaseDatabaseJob() {
        SQLScriptJob sqlScriptJob = new SQLScriptJob();
        this.getSqlScript().ifPresent(sqlScriptJob::setSQLScript);
        return sqlScriptJob.withParameters(this.getParameters());
    }

    private Optional<String> getSqlScript() {
        return this.getVariablesAdapter().getVariableByName(DB_SCRPT_NAME);
    }

    private List<Parameter> getParameters() {
        List<Parameter> parameters = this.getVariablesAdapter().convertAutoEditsWithPattern(DB_SCRPT_PARMS, this::sqlScriptParameterFrom);
        return parameters.isEmpty() ? null : parameters;
    }

    private Parameter sqlScriptParameterFrom(List<VariableWrapper> variableNameAndValue) {
        String parameterName = VariablesAdapter.getParameterFrom(variableNameAndValue, VARIABLE);
        String parameterValue = VariablesAdapter.getParameterFrom(variableNameAndValue, "VALUE");
        return new Parameter().withAdditionalProperty(parameterName, parameterValue);
    }
}

