/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.database;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseJobAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseDatabaseJob;
import com.bmc.ctmconvert.generated.json.models.base.BaseJob;
import java.util.Optional;

public abstract class BaseDatabaseJobAdapter<T>
extends BaseJobAdapter<T> {
    private static final String DB_ACCOUNT = "DB-ACCOUNT";
    private static final String DB_AUTOCOMMIT = "DB-AUTOCOMMIT";
    private static final String DB_APPEND_OUTPUT = "DB-APPEND_OUTPUT";
    private static final String DB_APPEND_LOG = "DB-APPEND_LOG";
    private static final String DB_OUTPUT_FORMAT = "DB-OUTPUT_FORMAT";

    protected BaseDatabaseJobAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    protected abstract BaseDatabaseJob buildBaseDatabaseJob();

    @Override
    protected BaseJob buildBaseJob() {
        BaseDatabaseJob baseDatabaseJob = this.buildBaseDatabaseJob().withConnectionProfile(this.getConnectionProfile());
        this.getAutoCommit().ifPresent(baseDatabaseJob::setAutocommit);
        this.getOutputExecutionLog().ifPresent(baseDatabaseJob::setOutputExecutionLog);
        this.getOutputSQLOutput().ifPresent(baseDatabaseJob::setOutputSQLOutput);
        this.getSQLOutputFormat().ifPresent(baseDatabaseJob::setSQLOutputFormat);
        return baseDatabaseJob;
    }

    private Optional<BaseDatabaseJob.Autocommit> getAutoCommit() {
        Optional<String> autoCommit = this.getVariablesAdapter().getVariableByName(DB_AUTOCOMMIT);
        return autoCommit.map(BaseDatabaseJob.Autocommit::fromValue);
    }

    private Optional<BaseDatabaseJob.OutputExecutionLog> getOutputExecutionLog() {
        Optional<String> appendToLog = this.getVariablesAdapter().getVariableByName(DB_APPEND_LOG);
        return appendToLog.map(BaseDatabaseJob.OutputExecutionLog::fromValue);
    }

    private Optional<BaseDatabaseJob.OutputSQLOutput> getOutputSQLOutput() {
        Optional<String> appendOutput = this.getVariablesAdapter().getVariableByName(DB_APPEND_OUTPUT);
        return appendOutput.map(BaseDatabaseJob.OutputSQLOutput::fromValue);
    }

    private Optional<BaseDatabaseJob.SQLOutputFormat> getSQLOutputFormat() {
        Optional<String> outputFormat = this.getVariablesAdapter().getVariableByName(DB_OUTPUT_FORMAT);
        return outputFormat.map(BaseDatabaseJob.SQLOutputFormat::fromValue);
    }

    private String getConnectionProfile() {
        return this.getVariablesAdapter().getVariableByName(DB_ACCOUNT).orElse("DB_DEFAULT_CONNECTION");
    }
}

