/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.VariableListArranger;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.JsonUtils;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariableWrapper;
import com.bmc.ctmconvert.generated.json.models.base.Variable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class VariablesAdapter {
    public static final Pattern CTM_PARAM_PATTERN = Pattern.compile("PARM[0-9]+");
    public static final List<String> CTM_SYSTEM_VARIABLES = List.of("\\$DATE", "\\$FOLDER_ID", "\\$GROUP_ORDID", "\\$NEXT", "\\$ODATE", "\\$OYEAR", "\\$PREV", "\\$RDATE", "\\$RYEAR", "\\$SMART_ORDERID", "\\$TABLE_ID", "\\$WCALC", "APPLGROUP", "APPLIC", "BLANK(\\d)", "CENT", "CYCLIC", "DAILYNAME", "DATACENTER", "DATE", "DAY", "FOLDER_ID", "GROUP_ORDID", "JOBNAME", "JULDAY", "MEMLIB", "MONNAM", "MONTH", "NEXT", "ODATE", "ODAY", "OJULDAY", "OMONTH", "ORDERID", "OWDAY", "OWNER", "OYEAR", "POSTCMD", "PRECMD", "PREV", "RDAY", "RJULDAY", "RMONNAM", "RMONTH", "RUNCOUNT", "RWDAY", "RYEAR", "SCHEDTAB", "SMART_ORDERID", "TIME", "WDAY", "YEAR", "CALCDATE", "GETENV", "SUBSTR", "BLANK");
    public static final String variableRegex = "[^<>\\[\\ \\]{}()=;`~\\-|:?.+*\\/&^#@!,\"'% ]+";
    public static final Pattern validVariableNamePattern = Pattern.compile("%%(?<variableName>[^<>\\[\\ \\]{}()=;`~\\-|:?.+*\\/&^#@!,\"'% ]+)");
    public static final Predicate<String> ALLOW_ALL = s -> false;
    private final String jobType;
    private final VariableListArranger variableListArranger;
    private final List<Properties> variables;
    private final Map<String, String> variablesMap;
    private final SchedEntity entity;
    private Predicate<String> ignoreVariables;
    private final BiFunction<VariableWrapper, Pattern, String> groupByIndex;

    public VariablesAdapter(SchedEntity schedEntity) {
        this(schedEntity, VariablesAdapter.defaultGroupByIndex());
    }

    private VariablesAdapter(SchedEntity schedEntity, BiFunction<VariableWrapper, Pattern, String> groupByIndex) {
        this.entity = schedEntity;
        this.jobType = this.getJobType(schedEntity);
        this.variableListArranger = VariableListArranger.getInstance();
        this.variablesMap = new HashMap<String, String>();
        this.variables = this.toProperties(schedEntity);
        this.ignoreVariables = ALLOW_ALL;
        this.groupByIndex = groupByIndex;
    }

    public VariablesAdapter withGroupByIndex(BiFunction<VariableWrapper, Pattern, String> groupByIndex) {
        return new VariablesAdapter(this.entity, groupByIndex);
    }

    private static Comparator<Variable> putVariablesWithReferenceLast() {
        Predicate<Variable> variableValueHasReference = VariablesAdapter.variableValueHasReference();
        return (left, right) -> {
            boolean leftHasVariableReference = variableValueHasReference.test((Variable)left);
            boolean rightHasVariableReference = variableValueHasReference.test((Variable)right);
            return Boolean.compare(leftHasVariableReference, rightHasVariableReference);
        };
    }

    public static boolean isSystemVariable(String variable) {
        return CTM_SYSTEM_VARIABLES.stream().anyMatch(sysVarReg -> Pattern.matches(sysVarReg, variable));
    }

    private static Predicate<Variable> variableValueHasReference() {
        return variable -> {
            Predicate<Object> containsVariableReference = value -> value.toString().contains("%%");
            return variable.getAdditionalProperties().values().stream().anyMatch(containsVariableReference);
        };
    }

    private String getJobType(SchedEntity schedEntity) {
        return schedEntity.getAttr("APPL_TYPE");
    }

    private Map<String, String> getAutoEdits(SchedEntity schedEntity) {
        LinkedHashMap<String, String> autoEdits = schedEntity.getAutoedits();
        return Optional.ofNullable(autoEdits).orElse((LinkedHashMap<String, String>)Collections.emptyMap());
    }

    public List<Variable> getVariables() {
        List<Properties> variablesProperties = this.variableListArranger.extractVariables(this.variables, this.jobType);
        return this.createVariablesFrom(variablesProperties);
    }

    public List<Variable> getCMVariables() {
        List<Properties> variablesProperties = this.variableListArranger.extractCmVariables(this.variables, this.jobType);
        return this.createVariablesFrom(variablesProperties);
    }

    public List<Variable> getBMCOrigTypeVariables() {
        List<Properties> variablesProperties = this.variableListArranger.extractBmcOrigTypeVariable(this.variables);
        return this.createVariablesFrom(variablesProperties);
    }

    private List<Properties> toProperties(SchedEntity schedEntity) {
        return this.getAutoEdits(schedEntity).entrySet().stream().map(entry -> {
            Properties properties = new Properties();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            properties.setProperty("NAME", name);
            properties.setProperty("VALUE", value);
            this.variablesMap.put(GlobalFunctions.removeVariablePrefix(name), value);
            return properties;
        }).collect(Collectors.toList());
    }

    private List<Variable> createVariablesFrom(List<Properties> properties) {
        return properties.stream().filter(property -> {
            String variable = GlobalFunctions.removeVariablePrefix(property.getProperty("NAME"));
            return this.ignoreVariables.negate().test(variable);
        }).map(property -> {
            String name = GlobalFunctions.removeVariablePrefix(property.getProperty("NAME"));
            String value = property.getProperty("VALUE");
            return new Variable().withAdditionalProperty(name, value);
        }).sorted(VariablesAdapter.putVariablesWithReferenceLast()).collect(Collectors.toList());
    }

    public Optional<String> getVariableByName(String name) {
        return Optional.ofNullable(this.variablesMap.get(GlobalFunctions.removeVariablePrefix(name)));
    }

    public List<String> getArguments() {
        List arguments = this.variablesMap.entrySet().stream().filter(entry -> this.isArgument((String)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        return JsonUtils.getOrNull(arguments);
    }

    private boolean isArgument(String variable) {
        return CTM_PARAM_PATTERN.matcher(variable).matches();
    }

    public void setIgnoreVariables(Predicate<String> ignoreVariables) {
        this.ignoreVariables = ignoreVariables;
    }

    public static String getParameterFrom(List<VariableWrapper> variableNameAndValue, String attribute, String defaultValue) {
        return variableNameAndValue.stream().filter(p -> p.getKey().endsWith(attribute)).map(VariableWrapper::getValue).findFirst().orElse(defaultValue);
    }

    public static String getParameterFrom(List<VariableWrapper> variableNameAndValue, String attribute) {
        return VariablesAdapter.getParameterFrom(variableNameAndValue, attribute, "");
    }

    private Map<String, List<VariableWrapper>> getParametersByIndex(Pattern parameterPattern) {
        return this.getCMVariables().stream().map(VariableWrapper::new).filter(v -> v.hasKeyWith(parameterPattern)).collect(Collectors.groupingBy(x -> this.groupByIndex.apply((VariableWrapper)x, parameterPattern)));
    }

    private static BiFunction<VariableWrapper, Pattern, String> defaultGroupByIndex() {
        boolean FIRST_MATCHED_GROUP = true;
        return (variable, pattern) -> {
            String variableName = variable.getKey();
            Matcher indexMatcher = pattern.matcher(variableName);
            return indexMatcher.matches() ? indexMatcher.group(1) : "";
        };
    }

    public <R> List<R> convertAutoEditsWithPattern(Pattern parameterPattern, Function<List<VariableWrapper>, R> variableListToR) {
        return this.getParametersByIndex(parameterPattern).entrySet().stream().filter(this.keepNonEmptyIndex()).sorted(this.sortByIndex()).map(Map.Entry::getValue).map(variableListToR).collect(Collectors.toList());
    }

    private Comparator<Map.Entry<String, List<VariableWrapper>>> sortByIndex() {
        return Comparator.comparingInt(e -> {
            String stringWithNumber = (String)e.getKey();
            return Integer.parseInt(stringWithNumber);
        });
    }

    private Predicate<Map.Entry<String, List<VariableWrapper>>> keepNonEmptyIndex() {
        return entry -> !((String)entry.getKey()).isEmpty();
    }

    @NotNull
    public Set<String> getUsedVariablesFromStr(Optional<String> optionalString) {
        return optionalString.map(str -> {
            HashSet<String> variableSet = new HashSet<String>();
            Matcher variableMatcher = validVariableNamePattern.matcher((CharSequence)str);
            while (variableMatcher.find()) {
                String variableName = variableMatcher.group("variableName");
                variableSet.add(variableName);
            }
            return variableSet;
        }).orElse(new HashSet());
    }

    public Set<String> getUsedVariablesFromStr(String str) {
        return this.getUsedVariablesFromStr(Optional.ofNullable(str));
    }
}

