/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SchedEntityUtils;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.AirFlowJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.DummyJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.FileTransferAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.FileWatcherAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.HadoopJobAdapterFactory;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.IBMCognosAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.InformaticaJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.IntegrationFactoryInformaticaCSJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.IntegrationFactoryMicroFocusJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.IntegrationFactoryRestWebServicesJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.JobPropertiesAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.OS400BaseJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.OsJobAdapterFactory;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.RegularFolderAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SaasJobPropertiesAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SapJobAdapterFactory;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SchedEntityAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SimpleFolderAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SubFolderAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariablesAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.ZosJobAdapterFactory;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.database.DatabaseJobAdapterFactory;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling.RuleBasedCalendarsAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling.SaasRuleBasedCalendarsAdapter;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;

public class SchedEntityAdapterFactory {
    public static final SchedEntityAdapter<String> emptyAdapter = EmptyAdapter.createEmptyAdapter();

    public static SchedEntityAdapter<?> createSchedEntityAdapter(SchedEntity entity, SchedEntity parent) {
        if (!entity.isValid()) {
            return emptyAdapter;
        }
        return SchedEntityAdapterFactory.createAdapterFrom(entity, parent);
    }

    private static SchedEntityAdapter<?> createAdapterFrom(SchedEntity entity, SchedEntity parent) {
        return switch (entity.type()) {
            default -> throw new MatchException(null, null);
            case SchedEntity.TYPE.SMART_FOLDER, SchedEntity.TYPE.SMART_TABLE -> new RegularFolderAdapter(entity);
            case SchedEntity.TYPE.TABLE -> new SimpleFolderAdapter(entity);
            case SchedEntity.TYPE.SUB_FOLDER, SchedEntity.TYPE.SUB_TABLE -> new SubFolderAdapter(entity, parent);
            case SchedEntity.TYPE.JOB -> SchedEntityAdapterFactory.getJobAdapter(entity, parent);
        };
    }

    public static SchedEntityAdapter<?> convertUnsupportedEntityToDummy(SchedEntity entity, SchedEntity parent) {
        SchedEntityAdapterFactory.addUnsupportedMessage(entity);
        return new DummyJobAdapter(entity, parent);
    }

    private static void addUnsupportedMessage(SchedEntity entity) {
        Reporter.addMessage(entity.getMessages(), "WRN0022", "General", Params.instance().getVendorName(), entity.getJobName(), entity.getAttr("APPL_TYPE"), entity.getOriginalJobName());
    }

    private static SchedEntityAdapter<?> getJobAdapter(SchedEntity entity, SchedEntity parent) {
        if (entity.isMFJob()) {
            return new ZosJobAdapterFactory().create(entity, parent);
        }
        if (SchedEntityAdapterFactory.isDummyJob(entity)) {
            return new DummyJobAdapter(entity, parent);
        }
        if (DatabaseJobAdapterFactory.isDatabaseJob(entity)) {
            return DatabaseJobAdapterFactory.createDatabaseJobAdapter(entity, parent);
        }
        if (SchedEntityUtils.isOsJob(entity)) {
            return OsJobAdapterFactory.createOsJobAdapter(entity, parent);
        }
        if (SchedEntityAdapterFactory.isFileWatcher(entity)) {
            return new FileWatcherAdapter(entity, parent);
        }
        if (SchedEntityAdapterFactory.isFileTransfer(entity)) {
            return new FileTransferAdapter(entity, parent);
        }
        if (SapJobAdapterFactory.isSapJob(entity)) {
            return SapJobAdapterFactory.createSapJobAdapter(entity, parent);
        }
        if (HadoopJobAdapterFactory.isHadoopJob(entity)) {
            return HadoopJobAdapterFactory.createHadoopJob(entity, parent);
        }
        if (SchedEntityAdapterFactory.isInformaticaJob(entity)) {
            return new InformaticaJobAdapter(entity, parent);
        }
        if (AirFlowJobAdapter.isAirFlowJob(entity)) {
            return new AirFlowJobAdapter(entity, parent);
        }
        if (SchedEntityAdapterFactory.isIntegrationFactoryRestWebServicesJob(entity)) {
            return new IntegrationFactoryRestWebServicesJobAdapter(entity, parent);
        }
        if (IntegrationFactoryMicroFocusJobAdapter.isIntegrationFactoryMicroFocusJob(entity)) {
            return new IntegrationFactoryMicroFocusJobAdapter(entity, parent);
        }
        if (OS400BaseJobAdapter.isOs400Job(entity)) {
            return OS400BaseJobAdapter.createJobAdapter(entity, parent);
        }
        if (IntegrationFactoryInformaticaCSJobAdapter.isInformaticaCSJob(entity)) {
            return new IntegrationFactoryInformaticaCSJobAdapter(entity, parent);
        }
        if (IBMCognosAdapter.isCognosJob(entity)) {
            return new IBMCognosAdapter(entity, parent);
        }
        return SchedEntityAdapterFactory.convertUnsupportedEntityToDummy(entity, parent);
    }

    private static boolean isIntegrationFactoryRestWebServicesJob(SchedEntity entity) {
        boolean isWebServicesApplication = "RST062023".equals(entity.getAttr("APPL_TYPE"));
        boolean isWebServiceApplicationForm = "RST062023".equals(entity.getAttr("APPL_FORM"));
        return isWebServicesApplication && isWebServiceApplicationForm;
    }

    private static boolean isInformaticaJob(SchedEntity entity) {
        return "ETL_INFA".equals(entity.getAttr("APPL_TYPE")) && "Informatica".equals(entity.getAttr("APPL_FORM"));
    }

    private static boolean isFileWatcher(SchedEntity entity) {
        return "FileWatch".equals(entity.getAttr("APPL_TYPE"));
    }

    private static boolean isFileTransfer(SchedEntity entity) {
        return "FILE_TRANS".equals(entity.getAttr("APPL_TYPE"));
    }

    private static boolean isDummyJob(SchedEntity entity) {
        boolean isCmJob = SchedEntityAdapterFactory.isCMJob(entity);
        boolean isOsJob = SchedEntityAdapterFactory.hasDummyAutoEdit(entity);
        boolean isDummy = !isCmJob && !isOsJob;
        return isDummy && Optional.ofNullable(entity.getAttr("TASKTYPE")).map("Dummy"::equals).orElse(true) != false;
    }

    private static boolean hasDummyAutoEdit(SchedEntity entity) {
        return SchedEntityAdapterFactory.getDummyAutoEdit(entity).isPresent();
    }

    public static Optional<String> getDummyAutoEdit(SchedEntity entity) {
        return Optional.ofNullable(entity.getVariable("%%$BMCWAIORIGTYPE"));
    }

    private static boolean isCMJob(SchedEntity entity) {
        return Optional.ofNullable(entity.getAttr("APPL_TYPE")).map(value -> !value.isEmpty()).orElse(false);
    }

    public JobPropertiesAdapter createJobPropertiesAdapter(VariablesAdapter variablesAdapter, SchedEntity schedEntity, SchedEntity parent, Supplier<Set<String>> getUsedVariablesFunc) {
        if (SettingsBooleanKeys.isSaas()) {
            return new SaasJobPropertiesAdapter(schedEntity, parent, variablesAdapter, getUsedVariablesFunc);
        }
        return new JobPropertiesAdapter(schedEntity, parent, variablesAdapter);
    }

    public RuleBasedCalendarsAdapter createRuleBasedCalendarsAdapter(List<Properties> calendars, SchedEntity.TYPE type, String rbcRelationship) {
        if (SettingsBooleanKeys.isSaas()) {
            return new SaasRuleBasedCalendarsAdapter(calendars, type, rbcRelationship);
        }
        return new RuleBasedCalendarsAdapter(calendars, type, rbcRelationship);
    }

    static class EmptyAdapter
    implements SchedEntityAdapter<String> {
        private EmptyAdapter() {
        }

        public static EmptyAdapter createEmptyAdapter() {
            return new EmptyAdapter();
        }

        @Override
        public String getType() {
            return "empty";
        }

        @Override
        public Optional<Object> toJson() {
            return Optional.empty();
        }

        @Override
        public String getName() {
            return "";
        }
    }
}

