/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.OS400BaseJobAdapter;
import com.bmc.ctmconvert.generated.json.models.base.OS400BaseJob;
import com.bmc.ctmconvert.generated.json.models.job_types.NativeScriptFileLocation;
import com.bmc.ctmconvert.generated.json.models.job_types.OS400ScriptJob;
import java.util.Optional;
import java.util.Set;

public class OS400ScriptJobAdapter
extends OS400BaseJobAdapter<OS400ScriptJob.Type> {
    @Override
    protected OS400BaseJob buildBaseOs400Job() {
        return new OS400ScriptJob().withFileName(this.getFileName()).withFilePath(this.getFilePath()).withNativeScriptFileLocation(this.getNativeScriptFileLocation());
    }

    private NativeScriptFileLocation getNativeScriptFileLocation() {
        Optional<String> filePath = Optional.ofNullable(this.getFilePath());
        return filePath.map(fp -> new NativeScriptFileLocation().withLibrary((String)fp)).orElse(null);
    }

    protected OS400ScriptJobAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    private String getFilePath() {
        return this.schedEntity.getVariable("%%OS400-MEM_LIB");
    }

    private String getFileName() {
        return Optional.ofNullable(this.schedEntity.getVariable("%%OS400-MEM_NAME")).orElseGet(() -> this.schedEntity.getAttr("MEMNAME"));
    }

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        return Set.of();
    }

    @Override
    public OS400ScriptJob.Type getType() {
        return OS400ScriptJob.Type.JOB_OS_400_FULL_SCRIPT_FILE;
    }
}

