/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.DocumentationFileAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.EventDefinitionAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.JsonUtils;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.ResourcesAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariableWrapper;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariablesAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.actions.AlertsAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.actions.OnStatementsAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.rerun.RerunAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.rerun.RerunIntervalsAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.rerun.RerunSpecificTimesAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling.WhenSchedulingAdapter;
import com.bmc.ctmconvert.generated.json.models.base.EventDefinition;
import com.bmc.ctmconvert.generated.json.models.base.JobProperties;
import com.bmc.ctmconvert.generated.json.models.base.Variable;
import com.bmc.ctmconvert.generated.json.models.base.WhenScheduling;
import com.bmc.ctmconvert.generated.json.models.base.rerun.RerunIntervals;
import com.bmc.ctmconvert.generated.json.models.base.rerun.RerunSpecificTimes;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.Capture;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.ForwardBy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class JobPropertiesAdapter {
    private static final String DUMMY_AUTOEDIT = GlobalFunctions.removeVariablePrefix("%%$BMCWAIORIGTYPE");
    public static final String IS_CRITICAL = "1";
    public static final String FOREVER = "Forever";
    public static final String FOREVER_NUMBER_VALUE = "99";
    protected SchedEntity schedEntity;
    private final OnStatementsAdapter onStatementsAdapter;
    private final ResourcesAdapter resourcesAdapter;
    VariablesAdapter variablesAdapter;
    private final RerunAdapter rerunAdapter;
    private final DocumentationFileAdapter documentationFileAdapter;

    public JobPropertiesAdapter(SchedEntity schedEntity, SchedEntity parent) {
        this(schedEntity, parent, new VariablesAdapter(schedEntity));
    }

    public JobPropertiesAdapter(SchedEntity schedEntity, SchedEntity parent, VariablesAdapter variablesAdapter) {
        this.schedEntity = schedEntity;
        this.onStatementsAdapter = this.createOnStatementsAdapter(schedEntity);
        this.resourcesAdapter = new ResourcesAdapter(schedEntity);
        this.variablesAdapter = variablesAdapter;
        this.rerunAdapter = new RerunAdapter(schedEntity, parent);
        this.documentationFileAdapter = new DocumentationFileAdapter(schedEntity);
    }

    public OnStatementsAdapter createOnStatementsAdapter(SchedEntity schedEntity) {
        return new OnStatementsAdapter(schedEntity);
    }

    public String getApplication() {
        return this.schedEntity.getApplication();
    }

    public String getSubApplication() {
        return this.schedEntity.getGroup();
    }

    public String getCTMServer() {
        return this.schedEntity.getAttr("DATACENTER");
    }

    public String getRunAs() {
        return Optional.ofNullable(this.schedEntity.getAttr("OWNER")).orElse("DEFAULT_RUN_AS");
    }

    public String getCreationUser() {
        return this.schedEntity.getAttr("CREATION_USER");
    }

    public String getDescription() {
        String description = this.schedEntity.getAttr("DESCRIPTION");
        return GlobalFunctions.replaceControlCharacters(GlobalFunctions.escapeControlCharacters(description));
    }

    public Optional<Boolean> getConfirm() {
        return Optional.ofNullable(this.schedEntity.getAttr("CONFIRM")).map(confirm -> confirm.equals(IS_CRITICAL));
    }

    public Optional<String> getMaxWait() {
        return Optional.ofNullable(this.schedEntity.getAttr("MAXWAIT")).map(maxWait -> {
            if (maxWait.equals(FOREVER_NUMBER_VALUE)) {
                return FOREVER;
            }
            return maxWait;
        });
    }

    public String getPriority() {
        return this.schedEntity.getAttr("PRIORITY");
    }

    public Optional<Boolean> getCritical() {
        return Optional.ofNullable(this.schedEntity.getAttr("CRITICAL")).map(critical -> critical.equals(IS_CRITICAL));
    }

    public EventDefinition getWaitForEvents() {
        List<Properties> inConditions = Optional.ofNullable(this.schedEntity.getInConds()).orElse(Collections.emptyList());
        EventDefinitionAdapter inConditionsAdapter = new EventDefinitionAdapter(inConditions, EventDefinition.Type.WAIT_FOR_EVENTS);
        EventDefinition events = inConditionsAdapter.getEventDefinition();
        return events.getEvents().isEmpty() ? null : events;
    }

    public EventDefinition getAddEvents() {
        List<Properties> addConditions = this.getOutConditionsFor(SIGN.ADD);
        EventDefinitionAdapter outConditionsAdapter = new EventDefinitionAdapter(addConditions, EventDefinition.Type.ADD_EVENTS);
        EventDefinition events = outConditionsAdapter.getEventDefinition();
        return events.getEvents().isEmpty() ? null : events;
    }

    public EventDefinition getDeleteEvents() {
        List<Properties> delConditions = this.getOutConditionsFor(SIGN.DEL);
        EventDefinitionAdapter delConditionsAdapter = new EventDefinitionAdapter(delConditions, EventDefinition.Type.DELETE_EVENTS);
        EventDefinition events = delConditionsAdapter.getEventDefinition();
        return events.getEvents().isEmpty() ? null : events;
    }

    private List<Properties> getOutConditionsFor(SIGN sign) {
        return Optional.ofNullable(this.schedEntity.getOutConds()).map(x -> x.stream().filter(properties -> sign.compareSign(properties.getProperty("SIGN"))).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private List<Variable> getVariables() {
        return this.variablesAdapter.getVariables();
    }

    public JobProperties addJobPropertiesFields(JobProperties jobProperties) {
        jobProperties.withApplication(this.getApplication()).withSubApplication(this.getSubApplication()).withControlmServer(this.getCTMServer()).withRunAs(this.getRunAs()).withCreatedBy(this.getCreationUser()).withDescription(this.getDescription()).withPriority(this.getPriority()).withEventsToWaitFor(this.getWaitForEvents()).withEventsToDelete(this.getDeleteEvents()).withEventsToAdd(this.getAddEvents()).withWhen(this.getWhenScheduling()).withTimeZone(this.getTimeZone());
        this.setRunAsDummy(jobProperties);
        this.addVariablesIfNotEmpty(jobProperties);
        this.getMaxWait().ifPresent(jobProperties::setDaysKeepActive);
        this.getCritical().ifPresent(jobProperties::setCritical);
        this.getConfirm().ifPresent(jobProperties::setConfirm);
        this.addNotifications(jobProperties);
        this.setRerunOrReRunLimit(jobProperties);
        this.getRerunIntervals().ifPresent(jobProperties::setRerunIntervals);
        this.getRerunSpecificTimes().ifPresent(jobProperties::setRerunSpecificTimes);
        this.addCapture(jobProperties);
        this.onStatementsAdapter.addEntityOnStatements(jobProperties);
        this.resourcesAdapter.addControlResources(jobProperties);
        this.documentationFileAdapter.convert(jobProperties);
        return jobProperties;
    }

    private void setRerunOrReRunLimit(JobProperties jobProperties) {
        if (!JsonUtils.isSubFolder(this.schedEntity)) {
            if (this.schedEntity.isCyclic()) {
                this.rerunAdapter.getRerun().ifPresent(jobProperties::setRerun);
            } else {
                this.rerunAdapter.getRerunLimit().ifPresent(jobProperties::setRerunLimit);
            }
        }
    }

    private Optional<RerunIntervals> getRerunIntervals() {
        if (JsonUtils.isSubFolder(this.schedEntity)) {
            return Optional.empty();
        }
        return new RerunIntervalsAdapter(this.schedEntity).getRerun();
    }

    private Optional<RerunSpecificTimes> getRerunSpecificTimes() {
        if (JsonUtils.isSubFolder(this.schedEntity)) {
            return Optional.empty();
        }
        return new RerunSpecificTimesAdapter(this.schedEntity).getRerun();
    }

    private void setRunAsDummy(JobProperties jobProperties) {
        boolean isOSDummyJob = this.isOSDummyJob();
        boolean isCMDummyJob = this.isCMDummyJob();
        if (isOSDummyJob || isCMDummyJob) {
            jobProperties.setRunAsDummy(true);
        }
    }

    private boolean isOSDummyJob() {
        List<Variable> bmcOrigTypeVariables = this.variablesAdapter.getBMCOrigTypeVariables();
        return bmcOrigTypeVariables.stream().anyMatch(v -> new VariableWrapper((Variable)v).getKey().equals(DUMMY_AUTOEDIT));
    }

    private boolean isCMDummyJob() {
        Boolean isDummy = Optional.ofNullable(this.schedEntity.getAttr("TASKTYPE")).map("Dummy"::equals).orElse(false);
        Boolean isCm = Optional.ofNullable(this.schedEntity.getAttr("APPL_TYPE")).map(applicationType -> !applicationType.isEmpty()).orElse(false);
        return isDummy != false && isCm != false;
    }

    protected void addNotifications(JobProperties jobProperties) {
        new AlertsAdapter(this.schedEntity).setNotification(jobProperties);
    }

    private void addCapture(JobProperties jobProperties) {
        AtomicInteger counter = new AtomicInteger(1);
        HashMap<String, Capture> captures = new HashMap<String, Capture>();
        if (this.schedEntity.getCaptures() != null) {
            this.schedEntity.getCaptures().forEach(capture -> captures.put("CaptureOutput_" + counter.getAndIncrement(), new Capture().withSearch(capture.searchString()).withCapture(capture.countToTake()).withVariableName(capture.variable()).withForwardBy(new ForwardBy().withColumns(capture.skipColumns()).withLines(capture.skipLines()))));
        }
        captures.forEach(jobProperties::withAdditionalProperty);
    }

    private String getTimeZone() {
        return this.schedEntity.getAttr("TIMEZONE");
    }

    public WhenScheduling getWhenScheduling() {
        return new WhenSchedulingAdapter(this.schedEntity).getWhenScheduling();
    }

    private void addVariablesIfNotEmpty(JobProperties jobProperties) {
        List<Variable> variables = this.getVariables();
        if (!variables.isEmpty()) {
            this.addVariables(jobProperties, variables);
        }
    }

    protected void addVariables(JobProperties jobProperties, List<Variable> variables) {
        List originalVariables = Optional.ofNullable(jobProperties.getVariables()).orElse(Collections.emptyList());
        jobProperties.setVariables(GlobalFunctions.concatLists(variables, originalVariables));
    }

    public ResourcesAdapter getResourcesAdapter() {
        return this.resourcesAdapter;
    }

    private static enum SIGN {
        ADD,
        DEL;


        public boolean compareSign(String sign) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if ("ADD".equals(sign) || "+".equals(sign)) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> "DEL".equals(sign) || "-".equals(sign);
            };
        }
    }
}

