/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.JsonUtils;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariableWrapper;
import com.bmc.ctmconvert.generated.json.models.base.BaseJob;
import com.bmc.ctmconvert.generated.json.models.base.Variable;
import com.bmc.ctmconvert.generated.json.models.job_types.InformaticaJob;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InformaticaJobAdapter
extends BaseJobAdapter<InformaticaJob.Type> {
    private static final Pattern INFORMATICA_VARIABLE_PATTERN = Pattern.compile("INF-PARAMETER-N(?<paramIndex>[0-9]{3})-(SCOPE|NAME|VALUE)");

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.variablesAdapter.getUsedVariablesFromStr(this.getWorkFlow());
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getInstanceName()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getRepositoryFolder()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getOsProfile()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getWorkflowParametersFile()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getInformaticaConnectionProfile()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getStartFromTask()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getReStartFromTask()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getRunSingleTask()));
        Stream.ofNullable(this.getInformaticaVariables()).forEach(param -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(param.toString())));
        return usedVariablesFromStr;
    }

    public InformaticaJobAdapter(SchedEntity entity, SchedEntity parent) {
        super(entity, parent);
    }

    @Override
    protected BaseJob buildBaseJob() {
        return ((InformaticaJob)new InformaticaJob().withWorkflow(this.getWorkFlow()).withInstanceName(this.getInstanceName()).withRepositoryFolder(this.getRepositoryFolder()).withOsProfile(this.getOsProfile()).withDepth(this.getDepth()).withWorkflowExecutionMode(this.getWorkFlowExecutionMode()).withWorkflowRestartMode(this.getWorkFlowRestartMode()).withWorkflowParametersFile(this.getWorkflowParametersFile()).withEnableOutput(this.getEnableOutput()).withEnableErrorDetails(this.getEnableErrorDetails()).withConnectionProfile(this.getInformaticaConnectionProfile()).withVariables((List)this.getInformaticaVariables())).withStartFromTask(this.getStartFromTask()).withRestartFromTask(this.getReStartFromTask()).withRunSingleTask(this.getRunSingleTask());
    }

    private String getRunSingleTask() {
        return this.schedEntity.getVariable("%%INF-RUN_SINGLE_TASK");
    }

    private String getReStartFromTask() {
        return this.schedEntity.getVariable("%%INF-RESTART_FROM_TASK");
    }

    private String getStartFromTask() {
        return this.schedEntity.getVariable("%%INF-START_FROM_TASK");
    }

    private List<Variable> getInformaticaVariables() {
        List variables = this.getVariablesAdapter().getCMVariables().stream().map(VariableWrapper::new).filter(variable -> variable.hasKeyWith(INFORMATICA_VARIABLE_PATTERN)).map(variable -> {
            String keyWithoutPrefix = GlobalFunctions.removeVariablePrefix(variable.getKey());
            return new Variable().withAdditionalProperty(keyWithoutPrefix, variable.getValue());
        }).sorted(this.sortByIndex()).collect(Collectors.toList());
        return JsonUtils.getOrNull(variables);
    }

    private Comparator<Variable> sortByIndex() {
        return Comparator.comparingInt(e -> {
            Matcher matcher = INFORMATICA_VARIABLE_PATTERN.matcher(new VariableWrapper((Variable)e).getKey());
            if (matcher.matches()) {
                String parameterIndex = matcher.group("paramIndex");
                return Integer.parseInt(parameterIndex);
            }
            return 0;
        });
    }

    private String getInformaticaConnectionProfile() {
        return this.schedEntity.getVariable("%%INF-ACCOUNT");
    }

    private Boolean getEnableErrorDetails() {
        return Optional.ofNullable(this.schedEntity.getVariable("%%INF-ENABLE_ERROR_DETAILS")).map("X"::equals).orElse(null);
    }

    private Boolean getEnableOutput() {
        return Optional.ofNullable(this.schedEntity.getVariable("%%INF-ENABLE_OUTPUT")).map("X"::equals).orElse(null);
    }

    private String getWorkflowParametersFile() {
        return this.schedEntity.getVariable("%%INF-WORKFLOW_PARAMETERS_FILE");
    }

    private InformaticaJob.WorkflowRestartMode getWorkFlowRestartMode() {
        String restartMode;
        switch (restartMode = Optional.ofNullable(this.schedEntity.getVariable("%%INF-WORKFLOW_RESTART_MODE")).orElse("RECOVER")) {
            case "RESTART_WHOLE": {
                return InformaticaJob.WorkflowRestartMode.FORCE_RESTART;
            }
            case "RESTART_FROM_TASK": {
                return InformaticaJob.WorkflowRestartMode.FORCE_RESTART_FROM_SPECIFIC_TASK;
            }
        }
        return InformaticaJob.WorkflowRestartMode.RECOVER;
    }

    private InformaticaJob.WorkflowExecutionMode getWorkFlowExecutionMode() {
        String WorkflowExeMode;
        switch (WorkflowExeMode = Optional.ofNullable(this.schedEntity.getVariable("%%INF-WORKFLOW_EXE_MODE")).orElse("Informatica Workflow")) {
            case "FROM_TASK": {
                return InformaticaJob.WorkflowExecutionMode.START_FROM_TASK;
            }
            case "SINGLE": {
                return InformaticaJob.WorkflowExecutionMode.RUN_SINGLE_TASK;
            }
        }
        return InformaticaJob.WorkflowExecutionMode.RUN_WHOLE_WORKFLOW;
    }

    private String getDepth() {
        return this.schedEntity.getVariable("%%INF-DEPTH");
    }

    private String getOsProfile() {
        return this.schedEntity.getVariable("%%INF-OS_PROFILE");
    }

    private String getRepositoryFolder() {
        return this.schedEntity.getVariable("%%INF-REP_FOLDER");
    }

    private String getInstanceName() {
        return this.schedEntity.getVariable("%%INF-INSTANCE_NAME");
    }

    private String getWorkFlow() {
        return Optional.ofNullable(this.schedEntity.getVariable("%%INF-WORKFLOW")).orElse("WHOLE");
    }

    @Override
    public InformaticaJob.Type getType() {
        return InformaticaJob.Type.JOB_INFORMATICA;
    }
}

