/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.AssistingJobUtils;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.JobPropertiesAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SchedEntityAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SchedEntityAdapterFactory;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariablesAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseJsonObject;
import com.bmc.ctmconvert.generated.json.models.base.JobProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BaseSchedEntityAdapter<T>
implements SchedEntityAdapter<T> {
    protected final SchedEntity schedEntity;
    protected final JobPropertiesAdapter jobPropertiesAdapter;
    protected final VariablesAdapter variablesAdapter;

    public abstract Set<String> getAllUsedVariablesInEntityProperties();

    protected BaseSchedEntityAdapter(SchedEntity schedEntity, SchedEntity parent) {
        JobPropertiesAdapter jobPropertiesAdapter = new SchedEntityAdapterFactory().createJobPropertiesAdapter(new VariablesAdapter(schedEntity), schedEntity, parent, this::getAllUsedVariablesInEntity);
        this.schedEntity = schedEntity;
        this.jobPropertiesAdapter = jobPropertiesAdapter;
        this.variablesAdapter = jobPropertiesAdapter.variablesAdapter;
    }

    public Set<String> getAllUsedVariablesInEntity() {
        return List.of(this.variablesAdapter.getUsedVariablesFromStr(this.jobPropertiesAdapter.getApplication()), this.variablesAdapter.getUsedVariablesFromStr(this.jobPropertiesAdapter.getSubApplication()), this.variablesAdapter.getUsedVariablesFromStr(this.jobPropertiesAdapter.getCreationUser()), this.variablesAdapter.getUsedVariablesFromStr(this.jobPropertiesAdapter.getDescription()), this.getAllUsedVariablesInEntityProperties(), this.variablesAdapter.getVariables().stream().flatMap(variable -> this.variablesAdapter.getUsedVariablesFromStr(variable.getAdditionalProperties().values().toString()).stream()).collect(Collectors.toSet())).stream().flatMap(Collection::stream).filter(usedVariable -> !VariablesAdapter.isSystemVariable(usedVariable)).collect(Collectors.toSet());
    }

    @Override
    public String getName() {
        return this.schedEntity.getJobName();
    }

    @Override
    public Optional<Object> toJson() {
        try {
            BaseJsonObject baseJsonObject = this.buildJobProperties();
            Optional<Object> jobPropertiesFields = baseJsonObject instanceof JobProperties ? Optional.of(this.jobPropertiesAdapter.addJobPropertiesFields((JobProperties)baseJsonObject)) : Optional.ofNullable(baseJsonObject);
            return jobPropertiesFields;
        }
        catch (Exception e) {
            throw new RuntimeException("Conversion to Json Failed for " + this.schedEntity.getJobName(), e);
        }
    }

    protected abstract BaseJsonObject buildJobProperties();

    protected VariablesAdapter getVariablesAdapter() {
        return this.variablesAdapter;
    }

    private void addChildrenToBaseFolder(BaseJsonObject baseFolder, SchedEntityAdapter<?> adapter) {
        adapter.toJson().ifPresent(entity -> baseFolder.setAdditionalProperty(adapter.getName(), entity));
    }

    protected List<SchedEntityAdapter<?>> getAdaptersForChildren() {
        Stream<SchedEntityAdapter<?>> adapters = this.createSchedEntityAdaptersForChildren();
        return adapters.collect(Collectors.toList());
    }

    private Stream<SchedEntityAdapter<?>> createSchedEntityAdaptersForChildren() {
        return this.getChildren().stream().map(child -> SchedEntityAdapterFactory.createSchedEntityAdapter(child, this.schedEntity));
    }

    public Collection<SchedEntity> getChildren() {
        List<SchedEntity> children = Optional.ofNullable(this.schedEntity.getChildren()).orElse(Collections.emptyList());
        Stream<SchedEntity> assistingJobs = this.getAssistingJobsOf(children);
        return Stream.concat(assistingJobs, children.stream()).collect(Collectors.toList());
    }

    private Stream<SchedEntity> getAssistingJobsOf(List<SchedEntity> children) {
        return Stream.concat(children.stream().flatMap(child -> AssistingJobUtils.getSiblingAssistingJobs(child).stream()), AssistingJobUtils.getChildrenAssistingJobs(this.schedEntity).stream());
    }

    protected Optional<String> getOrderMethod() {
        Optional<String> orderMethod = Optional.ofNullable(this.schedEntity.getAttr("TABLE_USERDAILY"));
        return orderMethod.map(v -> switch (v) {
            case "SYSTEM" -> "Automatic";
            case "" -> "Manual";
            default -> v;
        });
    }
}

