/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter;

import com.bmc.ctmconvert.common.Params;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class VersionControl {
    public static final String V9_20 = "9.0.20";
    public static final String V9_21 = "9.0.21";
    public static final String V9_22 = "9.0.22";
    public static final String CONTROL_M_VERSION_V20 = "20";
    public static final String CONTROL_M_VERSION_V21 = "21";
    public static final String CONTROL_M_VERSION_V22 = "22";
    public static final String DEFAULT_VERSION = "22";

    public static String getcurrentFullVersion() {
        String version = Params.instance().getGUIVersion();
        return VersionControl.getVersionGuiText(version);
    }

    public static String getVersionGuiText(String version) {
        return switch (version) {
            case CONTROL_M_VERSION_V20 -> V9_20;
            case CONTROL_M_VERSION_V21 -> V9_21;
            case "22" -> V9_22;
            default -> V9_22;
        };
    }

    public static String getVersionInWindowsRegistry() {
        return VersionFolder.V9.name;
    }

    public String getCurrentVersion() {
        String version = Params.instance().getGUIVersion();
        return VersionControl.getVersionGuiText(version);
    }

    public String[] getVersions() {
        ArrayList<String> versions = new ArrayList<String>(Arrays.asList(V9_22, V9_21, V9_20));
        return versions.toArray(new String[0]);
    }

    public String getVersionValue(String str) {
        return switch (str) {
            case V9_20 -> CONTROL_M_VERSION_V20;
            case V9_21 -> CONTROL_M_VERSION_V21;
            case V9_22 -> "22";
            default -> CONTROL_M_VERSION_V21;
        };
    }

    public List<String> createVersionList() {
        String guiVersion;
        String[] longVerList = new String[]{"700", "800", "900", "918", "919", "920", "921", "922"};
        int index = switch (guiVersion = Params.instance().getGUIVersion()) {
            case "22" -> 7;
            case CONTROL_M_VERSION_V21 -> 6;
            case CONTROL_M_VERSION_V20 -> 5;
            default -> 6;
        };
        return Arrays.stream(longVerList).limit((long)index + 1L).collect(Collectors.toList());
    }

    public String getVersionForXml() {
        List<String> versionList = this.createVersionList();
        return versionList.getLast();
    }

    private static enum VersionFolder {
        V9("9.0.X");

        private final String name;

        private VersionFolder(String name) {
            this.name = name;
        }
    }
}

