/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ValueTransformer {
    private final List<String> transformations = new ArrayList<String>();

    public ValueTransformer(String trans) {
        this.loadTransformations(trans);
    }

    private void loadTransformations(String trans) {
        Pattern p = Pattern.compile(".*?(\\S+\\s*\\(.*?(?<!\\\\)\\))(.*)");
        Matcher m = p.matcher(trans);
        while (m.matches()) {
            String transformation = m.group(1);
            String tail = m.group(2);
            this.transformations.add(transformation);
            if (tail == null) break;
            m = p.matcher(tail);
        }
    }

    public String transform(String in, String defaultValue) {
        String out = in;
        Pattern p = Pattern.compile("(.+?)\\((.*)\\)");
        for (String transFunc : this.transformations) {
            Matcher m = p.matcher(transFunc);
            if (!m.matches()) continue;
            out = this.transform(out, defaultValue, m.group(1), m.group(2).split("\\s*(?<!\\\\),\\s*"));
        }
        return out;
    }

    private String transform(String in, String defaultValue, String func, String ... args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].replaceAll("^\\s*\"", "").replaceAll("\"\\s*$", "");
        }
        String out = in;
        switch (func) {
            case "replace": {
                out = in.replace(args[0], args[1]);
                break;
            }
            case "replace_regex": {
                out = in.replaceAll(args[0], args[1]);
                break;
            }
            case "substring": {
                out = in.substring(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
                break;
            }
            case "interval_unit": {
                if (in.matches("[0-9]+")) {
                    out = String.format("%05dM", Integer.valueOf(in));
                    break;
                }
                if (in.matches("[0-9]+[HDMhdm]")) {
                    String interval = in.replaceAll("([0-9]+)([HDMhdm])", "$1");
                    String unit = in.replaceAll("([0-9]+)([HDMhdm])", "$2");
                    out = String.format("%05d%s", Integer.valueOf(interval), unit);
                    break;
                }
                out = defaultValue;
                break;
            }
            case "msg_length": {
                List<String> lines = Arrays.asList(in.split("\\r?\\n"));
                out = lines.stream().map(this::prependLengthToMessage).collect(Collectors.joining());
                break;
            }
            case "DecimalFormat": {
                try {
                    DecimalFormat fmt = new DecimalFormat(StringUtils.join((Object[])args, (String)","));
                    out = fmt.format(Integer.valueOf(in));
                }
                catch (Exception e) {
                    out = defaultValue;
                }
                break;
            }
        }
        return out;
    }

    private String prependLengthToMessage(String line) {
        String formattedLine = GlobalFunctions.replaceUnsupportedEMCharacters(line.trim());
        return String.format("%04d%s", new String(formattedLine.getBytes(this.getCharset()), this.getCharset()).length(), formattedLine);
    }

    Charset getCharset() {
        String encodingProperty = SettingsTable.instance().getProperty(SettingsStringKeys.XML_ENCODING_VALUE);
        if (encodingProperty.isBlank()) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(encodingProperty);
    }
}

