/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter;

import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;

public class MappingTable
extends CsvFile {
    public static Integer MAPPING_NUMBER_OF_FIELDS = 4;
    public static Integer MAPPING_INDEX_INDEX = 0;
    public static Integer MAPPING_INDEX_ORIG_JOBNAME = 1;
    public static Integer MAPPING_INDEX_CTM_JOBNAME = 2;
    public static Integer MAPPING_INDEX_APPLICATION = 3;
    public static String MAPPING_HEADER_INDEX = "Mapping Index";
    public static String MAPPING_HEADER_ORIGINAL_JOBNAME = "Original jobname";
    public static String MAPPING_HEADER_CTM_JOBNAME = "Control-M Jobname";
    public static String MAPPING_HEADER_APPLICATION = "Application";
    private HashMap<String, MappingEntity> m_Mapping_Orig = new HashMap();
    private HashMap<String, MappingEntity> m_Mapping_Ctm = new HashMap();
    private HashMap<Integer, MappingEntity> m_Mapping_Index = new HashMap();
    private static MappingTable m_instance = null;

    private MappingTable(String mappingFileName) {
        if (mappingFileName != null) {
            this.load(mappingFileName);
        }
    }

    public static MappingTable instance(String mappingFileName) {
        if (m_instance == null) {
            m_instance = new MappingTable(mappingFileName);
        }
        return m_instance;
    }

    public static void destroy() {
        MappingTable.m_instance.m_Mapping_Orig.clear();
        MappingTable.m_instance.m_Mapping_Orig = null;
        MappingTable.m_instance.m_Mapping_Ctm.clear();
        MappingTable.m_instance.m_Mapping_Ctm = null;
        MappingTable.m_instance.m_Mapping_Index.clear();
        MappingTable.m_instance.m_Mapping_Index = null;
        m_instance = null;
    }

    public HashMap<String, MappingEntity> getMapping() {
        return this.m_Mapping_Orig;
    }

    @Override
    protected void handleRecord(IAttrHolder mapping_entry, int record_number) {
        MappingEntity mapping = new MappingEntity(this, mapping_entry);
        this.m_Mapping_Orig.put(mapping.getOriginalJobName(), mapping);
        this.m_Mapping_Ctm.put(mapping.getCtmJobName(), mapping);
        this.m_Mapping_Index.put(mapping.getIndex(), mapping);
    }

    public Integer getCtmJobIndex(String ctmJobName) {
        MappingEntity mapping = this.m_Mapping_Ctm.get(ctmJobName);
        if (mapping != null) {
            return mapping.getIndex();
        }
        return -1;
    }

    public Integer getOrigJobIndex(String originalJobName) {
        MappingEntity mapping = this.m_Mapping_Orig.get(originalJobName);
        if (mapping != null) {
            return mapping.getIndex();
        }
        return -1;
    }

    public String getCtmJobName(Integer index) {
        MappingEntity mapping = this.m_Mapping_Index.get(index);
        if (mapping != null) {
            return mapping.getCtmJobName();
        }
        return null;
    }

    public String getOrigJobName(Integer index) {
        MappingEntity mapping = this.m_Mapping_Index.get(index);
        if (mapping != null) {
            return mapping.getOriginalJobName();
        }
        return null;
    }

    public String getCtmJobName(String origJobName) {
        Integer index = this.getOrigJobIndex(origJobName);
        if (index == -1) {
            return null;
        }
        return this.getCtmJobName(index);
    }

    public String getOrigJobName(String ctmJobName) {
        Integer index = this.getCtmJobIndex(ctmJobName);
        if (index == -1) {
            return null;
        }
        return this.getOrigJobName(index);
    }

    public String getApplication(Integer index) {
        MappingEntity mapping = this.m_Mapping_Index.get(index);
        if (mapping != null) {
            return mapping.getApplication();
        }
        return null;
    }

    public static String[] buildMappedValues(Integer index, SchedEntity job) {
        String[] mappedValues = new String[MAPPING_NUMBER_OF_FIELDS.intValue()];
        mappedValues[MappingTable.MAPPING_INDEX_INDEX.intValue()] = index.toString();
        mappedValues[MappingTable.MAPPING_INDEX_ORIG_JOBNAME.intValue()] = job.getOriginalJobName();
        mappedValues[MappingTable.MAPPING_INDEX_CTM_JOBNAME.intValue()] = job.getJobName();
        mappedValues[MappingTable.MAPPING_INDEX_APPLICATION.intValue()] = job.getApplication() == null ? "" : job.getApplication();
        return mappedValues;
    }

    public static void writeMappingFile(String mapFileName, LinkedList<String[]> mapValues) {
        File mapFile = new File(mapFileName);
        if (mapFile.exists()) {
            mapFile.delete();
        }
        try {
            BufferedWriter mappingBW = new BufferedWriter(new FileWriter(mapFile, true));
            mappingBW.write(MAPPING_HEADER_INDEX);
            mappingBW.write(",");
            mappingBW.write(MAPPING_HEADER_ORIGINAL_JOBNAME);
            mappingBW.write(",");
            mappingBW.write(MAPPING_HEADER_CTM_JOBNAME);
            mappingBW.write(",");
            mappingBW.write(MAPPING_HEADER_APPLICATION);
            mappingBW.write("\n");
            for (String[] mappedValue : mapValues) {
                mappingBW.write(mappedValue[MAPPING_INDEX_INDEX]);
                mappingBW.write(",");
                mappingBW.write("\"" + mappedValue[MAPPING_INDEX_ORIG_JOBNAME] + "\"");
                mappingBW.write(",");
                mappingBW.write("\"" + mappedValue[MAPPING_INDEX_CTM_JOBNAME] + "\"");
                mappingBW.write(",");
                mappingBW.write("\"" + mappedValue[MAPPING_INDEX_APPLICATION] + "\"");
                mappingBW.write("\n");
            }
            mappingBW.flush();
            mappingBW.close();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
            mapFile.delete();
        }
    }

    public class MappingEntity {
        private Integer m_Index = null;
        private String m_OriginalJobName = null;
        private String m_CtmJobName = null;
        private String m_Application = null;

        public MappingEntity(MappingTable this$0, IAttrHolder mappingEntry) {
            this.setIndex(mappingEntry.getAttrAsInt(MAPPING_HEADER_INDEX));
            this.setOriginalJobName(mappingEntry.getAttr(MAPPING_HEADER_ORIGINAL_JOBNAME));
            this.setCtmJobName(mappingEntry.getAttr(MAPPING_HEADER_CTM_JOBNAME));
            if (mappingEntry.isFieldExist(MAPPING_HEADER_APPLICATION)) {
                this.setApplication(mappingEntry.getAttr(MAPPING_HEADER_APPLICATION));
            } else {
                this.setApplication("");
            }
        }

        public MappingEntity(MappingTable this$0, Integer index, SchedEntity job) {
            this.setIndex(index);
            this.setOriginalJobName(job.getOriginalJobName());
            this.setCtmJobName(job.getJobName());
            this.setApplication(job.getApplication());
        }

        public void setIndex(Integer index) {
            this.m_Index = index;
        }

        public Integer getIndex() {
            return this.m_Index;
        }

        public void setOriginalJobName(String originalJobName) {
            this.m_OriginalJobName = originalJobName;
        }

        public String getOriginalJobName() {
            return this.m_OriginalJobName;
        }

        public void setCtmJobName(String ctmJobName) {
            this.m_CtmJobName = ctmJobName;
        }

        public String getCtmJobName() {
            return this.m_CtmJobName;
        }

        public void setApplication(String application) {
            this.m_Application = application;
        }

        public String getApplication() {
            return this.m_Application;
        }
    }
}

