/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.message_id.MessageId;
import java.util.ArrayList;
import java.util.HashMap;

public class JobMessage {
    private IAttrHolder message_details;
    private String[] messageVars;
    private static boolean first_time_load_msgid = true;
    public static HashMap<String, MessageId> message_ids = null;
    public static final Integer MAX_REPORT_RESNUMVAR = 20;
    public static final String MSGID_NOT_FOUND = "MESSAGE ID %s NOT FOUND IN MESSAGE TABLE";

    public JobMessage(IAttrHolder message) {
        this.init(message);
    }

    public JobMessage(String msgId) {
        this.onFirstTime();
    }

    public JobMessage(String message, String header) {
        ArrayList<String> tmpList = GlobalFunctions.stringToWords(message, ",", null, null, false);
        this.init(new AttrHolder(tmpList.toArray(new String[0]), AttrHolder.buildHeadersMap(header)));
    }

    private void init(IAttrHolder message) {
        this.message_details = message;
        Integer num_vars = Integer.parseInt(message.getAttr("RESNUMVAR"));
        this.messageVars = new String[num_vars.intValue()];
        Integer i = 1;
        while (i <= num_vars) {
            String resvar_name = "RESVAR" + i.toString();
            this.messageVars[i.intValue() - 1] = message.getAttr(resvar_name);
            Integer n = i;
            i = i + 1;
        }
    }

    public String getID() {
        return this.message_details.getAttr("RESID");
    }

    public String getMessageID() {
        return this.message_details.getAttr("MSGID");
    }

    public String getMessageType() {
        return this.message_details.getAttr("MSGTYPE");
    }

    public String getMessageTypeDesc() {
        if (this.getMessageType().equalsIgnoreCase("I")) {
            return "Information";
        }
        if (this.getMessageType().equalsIgnoreCase("W")) {
            return "Warning";
        }
        if (this.getMessageType().equalsIgnoreCase("E")) {
            return "Error";
        }
        return "Unknown";
    }

    public Integer getMessageTypeIndex() {
        if (this.getMessageType().equalsIgnoreCase("I")) {
            return 0;
        }
        if (this.getMessageType().equalsIgnoreCase("W")) {
            return 1;
        }
        if (this.getMessageType().equalsIgnoreCase("E")) {
            return 2;
        }
        return -1;
    }

    public String getMessageType(String msgId) {
        MessageId message_entry = message_ids.get(msgId);
        return message_entry.getMessageType(msgId);
    }

    public String getMessageTypeDesc(String msgId) {
        this.onFirstTime();
        MessageId message_entry = message_ids.get(msgId);
        if (message_entry.getMessageType(msgId).equalsIgnoreCase("I")) {
            return "Information";
        }
        if (message_entry.getMessageType(msgId).equalsIgnoreCase("W")) {
            return "Warning";
        }
        if (message_entry.getMessageType(msgId).equalsIgnoreCase("E")) {
            return "Error";
        }
        return "Unknown";
    }

    public Integer getMessageTypeIndex(String msgId) {
        this.onFirstTime();
        MessageId message_entry = message_ids.get(msgId);
        if (message_entry != null) {
            if (message_entry.getMessageType(msgId).equalsIgnoreCase("I")) {
                return 0;
            }
            if (message_entry.getMessageType(msgId).equalsIgnoreCase("W")) {
                return 1;
            }
            if (message_entry.getMessageType(msgId).equalsIgnoreCase("E")) {
                return 2;
            }
        } else {
            if (msgId.equalsIgnoreCase("Information")) {
                return 0;
            }
            if (msgId.equalsIgnoreCase("Warning")) {
                return 1;
            }
            if (msgId.equalsIgnoreCase("Error")) {
                return 2;
            }
        }
        return -1;
    }

    public String getMessageTypeDesc(Integer typeIndex) {
        if (typeIndex == 0) {
            return "Information";
        }
        if (typeIndex == 1) {
            return "Warning";
        }
        if (typeIndex == 2) {
            return "Error";
        }
        return "Unknown";
    }

    public String getMessageText() {
        String messageDescription = "";
        this.onFirstTime();
        MessageId message_entry = message_ids.get(this.message_details.getAttr("MSGID"));
        messageDescription = message_entry == null ? String.format(MSGID_NOT_FOUND, this.message_details.getAttr("MSGID")) : message_entry.getMessageText(this.messageVars);
        return messageDescription;
    }

    public String getMessageText(String msgId, String[] messageVars) {
        String messageDescription = "";
        this.onFirstTime();
        MessageId message_entry = message_ids.get(msgId);
        messageDescription = message_entry == null ? String.format(MSGID_NOT_FOUND, msgId) : message_entry.getMessageText(messageVars);
        return messageDescription;
    }

    public String getMessageExtendedText() {
        String messageDescription = "";
        this.onFirstTime();
        MessageId message_entry = message_ids.get(this.message_details.getAttr("MSGID"));
        messageDescription = message_entry == null ? String.format(MSGID_NOT_FOUND, this.message_details.getAttr("MSGID")) : message_entry.getMessageExtendedText(this.messageVars);
        return messageDescription;
    }

    public String getMessageVendor() {
        MessageId message_entry = message_ids.get(this.message_details.getAttr("MSGID"));
        if (message_entry == null) {
            return "";
        }
        return message_entry.getMessageVendor();
    }

    public String getMessageStatus() {
        return this.message_details.getAttr("MSGSTATUS");
    }

    public String getMessageActionable() {
        return this.message_details.getAttr("ACTIONABLE");
    }

    public String getMessageActionable(String msgId) {
        MessageId message_entry = message_ids.get(msgId);
        return message_entry.getMessageActionable();
    }

    public String getMessageJobId() {
        return this.message_details.getAttr("JOBID");
    }

    public String[] getMessageVars() {
        return this.messageVars;
    }

    public void setMessageType(String type) {
    }

    public void setMessageStatus(String status) {
    }

    private void onFirstTime() {
        if (first_time_load_msgid) {
            first_time_load_msgid = false;
            MessageIdTable msgid_table = MessageIdTable.instance();
            message_ids = new HashMap<String, MessageId>(msgid_table.getMessageIds());
        }
    }
}

