/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.draftwriter.AttributeDescriptor;
import com.bmc.ctmconvert.common.draftwriter.DraftFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.function.BiFunction;

public class ElementDescriptor {
    private String internalName = null;
    private String draftName = null;
    private ArrayList<ElementDescriptor> childElements = null;
    private ArrayList<AttributeDescriptor> attrs = null;
    private boolean isSchedEnt = false;
    private BiFunction<Integer, String, String> descriptionValueHandler;

    public ElementDescriptor(LinkedHashMap<String, ArrayList<String>> eMap, BiFunction<Integer, String, String> descriptionValueHandler) {
        this.descriptionValueHandler = descriptionValueHandler;
        for (String element : eMap.keySet()) {
            ArrayList<String> elementArr = eMap.get(element);
            if (element.equals("ENTITY")) {
                this.isSchedEnt = true;
                this.loadElement(elementArr);
                continue;
            }
            if (this.childElements == null) {
                this.childElements = new ArrayList();
            }
            this.childElements.add(new ElementDescriptor(elementArr, this.descriptionValueHandler));
        }
    }

    private ElementDescriptor(ArrayList<String> list, BiFunction<Integer, String, String> descriptionValueHandler) {
        this.descriptionValueHandler = descriptionValueHandler;
        this.loadElement(list);
    }

    private void loadElement(ArrayList<String> elementArr) {
        for (String line : elementArr) {
            String[] lineArr = line.split("\\s*:\\s*", 2);
            String lineType = lineArr[0];
            LinkedHashMap<String, String> lineVals = this.lineToKeyValue(lineArr[1]);
            if (lineType.equals("element")) {
                this.internalName = lineVals.get("internal_name");
                this.draftName = lineVals.get("draft_name");
                if (!lineVals.containsKey("subelements")) continue;
                File subElementFile = new File(String.format("%s%s.txt", DraftFormat.getFormatDir(), lineVals.get("subelements")));
                if (this.childElements == null) {
                    this.childElements = new ArrayList();
                }
                this.childElements.addAll(this.loadSubElementsFile(subElementFile));
                continue;
            }
            if (!lineType.equals("attribute")) continue;
            if (this.attrs == null) {
                this.attrs = new ArrayList();
            }
            this.attrs.add(new AttributeDescriptor(lineVals, this.descriptionValueHandler));
        }
    }

    private ArrayList<ElementDescriptor> loadSubElementsFile(File subElementFile) {
        ArrayList<ElementDescriptor> toRet = new ArrayList<ElementDescriptor>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(subElementFile));
            ArrayList<String> buffer = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                if (line.matches("^\\s*#.*") || line.trim().isEmpty()) continue;
                String[] lineArr = line.split("\\s+", 2);
                if (lineArr[1].startsWith("element:") && !buffer.isEmpty()) {
                    toRet.add(new ElementDescriptor(buffer, this.descriptionValueHandler));
                    buffer.clear();
                }
                buffer.add(lineArr[1]);
            }
            if (!buffer.isEmpty()) {
                toRet.add(new ElementDescriptor(buffer, this.descriptionValueHandler));
            }
            br.close();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
        return toRet;
    }

    public ElementDescriptor getSubElementByName(String internalName) {
        for (ElementDescriptor sub : this.childElements) {
            if (!sub.getInternalName().equals(internalName)) continue;
            return sub;
        }
        return null;
    }

    String openElementTag(Properties elementAttrs, boolean closeTag) {
        return this.openElementTag(elementAttrs, closeTag, "\n");
    }

    String openElementTag(Properties elementAttrs, boolean closeTag, String attrTerminator) {
        StringBuilder toRet = new StringBuilder();
        toRet.append(String.format("<%s", this.getDraftName())).append(attrTerminator);
        for (AttributeDescriptor attribute : this.getAttrs()) {
            toRet.append(attribute.toString(elementAttrs.getProperty(attribute.getInternalName()), attrTerminator));
        }
        if (closeTag) {
            toRet.append("/");
        }
        toRet.append('>');
        return toRet.toString();
    }

    String closeElementTag() {
        return String.format("</%s>\n", this.getDraftName());
    }

    public String getDraftName() {
        return this.draftName;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public ArrayList<AttributeDescriptor> getAttrs() {
        return this.attrs;
    }

    public ArrayList<ElementDescriptor> getChildElements() {
        return this.childElements;
    }

    public boolean hasChildElements() {
        return this.getChildElements() != null && !this.getChildElements().isEmpty();
    }

    public boolean isSchedEnt() {
        return this.isSchedEnt;
    }

    private LinkedHashMap<String, String> lineToKeyValue(String l) {
        String[] lArr = l.trim().split("\\s+");
        LinkedHashMap<String, Object> toRet = null;
        String lastkey = null;
        for (int i = 0; i < lArr.length && !lArr[i].startsWith("#"); ++i) {
            if (!lArr[i].matches(".+[^\\\\]=.+")) {
                if (lastkey == null) continue;
                toRet.put(lastkey, (String)toRet.get(lastkey) + " " + lArr[i].replace("\\=", "="));
                continue;
            }
            String[] kvArr = lArr[i].split("(?=[^\\\\])=", 2);
            String key = kvArr[0];
            String val = kvArr[1].replace("\\=", "=");
            if (toRet == null) {
                toRet = new LinkedHashMap<String, Object>();
            }
            toRet.put(key, val);
            lastkey = key;
        }
        return toRet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyOverride(String element, String attribute, LinkedHashMap<String, String> overrides) {
        if (element.contains("/")) {
            boolean exist = false;
            String newElement = element.split("/", 2)[1];
            for (int i = 0; i < this.childElements.size(); ++i) {
                String childName = this.childElements.get(i).getInternalName();
                if (!childName.equals(newElement) && !newElement.startsWith(childName + "/")) continue;
                this.childElements.get(i).applyOverride(newElement, attribute, overrides);
                return;
            }
            if (exist) return;
        }
        if (attribute == null) {
            if (!overrides.containsKey("draft_name")) return;
            if (overrides.get("draft_name") == null) return;
            this.draftName = overrides.get("draft_name");
            return;
        } else {
            boolean exist = false;
            for (int i = 0; i < this.attrs.size(); ++i) {
                if (!this.attrs.get(i).getInternalName().equals(attribute)) continue;
                this.attrs.get(i).applyOverrides(overrides);
                return;
            }
            if (exist) return;
            this.attrs.add(new AttributeDescriptor(overrides, this.descriptionValueHandler));
        }
    }
}

