/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.conditions;

import com.bmc.ctmconvert.common.conditions.Condition;
import com.bmc.ctmconvert.common.conditions.InCondition;
import com.bmc.ctmconvert.common.conditions.Op;
import java.util.ArrayList;
import java.util.List;

public class InConditionsRemover {
    private final List<InCondition> inconditions;

    public InConditionsRemover(List<InCondition> inconditions) {
        this.inconditions = inconditions;
    }

    public boolean removeByName(String conditionName) {
        boolean isAllSuccessed = true;
        List<InCondition> removalConditions = this.getConditionOccurrences(conditionName);
        for (InCondition inCondition : removalConditions) {
            boolean isRemoveSuccessed = this.removeCondition(inCondition);
            isAllSuccessed = isAllSuccessed && isRemoveSuccessed;
        }
        return isAllSuccessed;
    }

    private List<InCondition> getConditionOccurrences(String conditionName) {
        ArrayList<InCondition> inconditionList = new ArrayList<InCondition>();
        for (InCondition condition : this.inconditions) {
            if (!condition.getName().equals(conditionName)) continue;
            inconditionList.add(condition);
        }
        return inconditionList;
    }

    private boolean removeCondition(InCondition incondition) {
        if (incondition == null || !this.inconditions.contains(incondition)) {
            return false;
        }
        if (incondition.getOp().isOpen()) {
            this.addOpenOpToNextcondition(incondition);
        }
        if (incondition.getOp().isClose()) {
            this.addCloseOpToPreviousCondition(incondition);
        }
        this.inconditions.remove(incondition);
        return true;
    }

    public boolean removeAllByName(List<String> inconditionList) {
        boolean isAllSucceed = true;
        if (inconditionList == null) {
            return false;
        }
        for (String conditionName : inconditionList) {
            boolean isRemoveSucceed = this.removeByName(conditionName);
            isAllSucceed = isAllSucceed && isRemoveSucceed;
        }
        return isAllSucceed;
    }

    public List<InCondition> getConditions() {
        return this.inconditions;
    }

    private void addCloseOpToPreviousCondition(Condition removalCondition) {
        if (this.inconditions.size() == 1) {
            return;
        }
        int removalIndex = this.inconditions.indexOf(removalCondition);
        InCondition previousCondition = this.inconditions.get(removalIndex - 1);
        if (previousCondition == null) {
            return;
        }
        if (!previousCondition.hasOp()) {
            previousCondition.setOp(Op.Close);
        } else if (previousCondition.getOp().isOpen()) {
            previousCondition.setOp(Op.NoOp);
        }
    }

    private void addOpenOpToNextcondition(Condition removalCondition) {
        if (this.inconditions.size() == 1) {
            return;
        }
        int removalIndex = this.inconditions.indexOf(removalCondition);
        InCondition nextCondition = this.inconditions.get(removalIndex + 1);
        if (nextCondition == null) {
            return;
        }
        if (!nextCondition.hasOp()) {
            nextCondition.setOp(Op.Open);
        } else if (nextCondition.getOp().isClose()) {
            nextCondition.setOp(Op.NoOp);
        }
    }
}

