/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUnpacker {
    private FileSystem fileSystem;

    public ZipUnpacker() {
        this.fileSystem = FileSystems.getDefault();
    }

    public ZipUnpacker(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public FileSystem createZipFileSystem(String zipFilename, boolean create) throws IOException {
        Path path = this.fileSystem.getPath(zipFilename, new String[0]);
        URI uri = URI.create("jar:" + String.valueOf(path.toUri()));
        HashMap<String, String> env = new HashMap<String, String>();
        if (create) {
            env.put("create", "true");
        }
        return FileSystems.newFileSystem(uri, env);
    }

    public void unzip(String zipFilename, String destDirname) throws IOException {
        final Path destDir = this.fileSystem.getPath(destDirname, new String[0]);
        if (Files.notExists(destDir, new LinkOption[0])) {
            Files.createDirectories(destDir, new FileAttribute[0]);
        }
        try (FileSystem zipFileSystem = this.createZipFileSystem(zipFilename, false);){
            Path root = zipFileSystem.getPath("/", new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path destFile = ZipUnpacker.this.fileSystem.getPath(destDir.toString(), file.toString());
                    if (Files.exists(destFile, new LinkOption[0])) {
                        Files.setAttribute(destFile, "dos:readonly", false, new LinkOption[0]);
                    }
                    Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path dirToCreate = ZipUnpacker.this.fileSystem.getPath(destDir.toString(), dir.toString());
                    if (Files.notExists(dirToCreate, new LinkOption[0])) {
                        Files.createDirectory(dirToCreate, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public Set<String> getTopLevelEntries(String zipPath) throws IOException {
        HashSet<String> zipContent = new HashSet<String>();
        ZipFile zipFile = new ZipFile(zipPath);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (entryName.indexOf("/") == -1) {
                zipContent.add(entryName);
                continue;
            }
            String topLevelName = entryName.substring(0, entryName.indexOf("/"));
            zipContent.add(topLevelName);
        }
        zipFile.close();
        return zipContent;
    }
}

