/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.Globs;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public class WhichAppRunning {
    private final Path filePath;

    public WhichAppRunning() {
        this(FileSystems.getDefault());
    }

    public WhichAppRunning(FileSystem fileSystem) {
        this.filePath = fileSystem.getPath(Globs.currentAppFilePath, new String[0]);
    }

    public void setCurrentApp(String appName) throws IOException {
        String toWrite = String.format("%s=%s", "RunningApp", appName);
        Files.write(this.filePath, toWrite.getBytes(), new OpenOption[0]);
    }

    public String getCurrentApp() throws IOException {
        String appName = "";
        List<String> lines = Files.readAllLines(this.filePath);
        if (lines.isEmpty()) {
            throw new IOException("\"Current running application\" file is empty");
        }
        String[] keyAndValue = lines.get(0).split("=");
        if (keyAndValue.length == 2) {
            appName = keyAndValue[1];
        }
        return appName;
    }
}

