/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.exceptions.GUITextFileNotFoundException;
import com.bmc.ctmconvert.configuration.ThemeConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;

public class TextManager {
    private static TextManager instance;
    private final Properties stringList = new Properties();

    private TextManager() {
    }

    private void load() throws GUITextFileNotFoundException {
        this.loadTextFrom(Globs.GUI_TEXT_FILE);
        this.loadTextFrom(ThemeConfiguration.get().getGuiTextFilePath());
    }

    private void loadTextFrom(String guiTextPath) throws GUITextFileNotFoundException {
        try (InputStream is = Files.newInputStream(Paths.get(guiTextPath, new String[0]), new OpenOption[0]);){
            this.stringList.load(is);
        }
        catch (IOException e) {
            throw new GUITextFileNotFoundException();
        }
    }

    public static void initiateInstance() throws GUITextFileNotFoundException {
        instance = new TextManager();
        instance.load();
    }

    public static TextManager instance() {
        if (instance == null) {
            instance = new TextManager();
        }
        return instance;
    }

    public String get(String stringID) {
        return this.stringList.getOrDefault((Object)stringID, "").toString();
    }

    public static void setInstance(TextManager instance) {
        TextManager.instance = instance;
    }
}

