/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmVariableRecognizer {
    private static final Pattern cmVarPattern = Pattern.compile("(%%)(.+?)-(.*)");
    private final String prefix;

    public CmVariableRecognizer(Map<String, String> cmVarsPrefixes, String jobType) {
        this.prefix = cmVarsPrefixes.getOrDefault(jobType, "");
    }

    public boolean isCmVariable(Properties variable) {
        String variableName = variable.getProperty("NAME");
        Matcher matcher = cmVarPattern.matcher(variableName);
        if (matcher.find()) {
            String varPrefix = matcher.group(2);
            return varPrefix.equals(this.prefix);
        }
        return false;
    }
}

