/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.table;

import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class BaseTableHeaserGradientPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private State state = State.DEFAULT;
    private Border defaultBorder;
    private Border disabledBorder;

    public BaseTableHeaserGradientPanel() {
        this.initializeBorders();
        this.addMouseListener(this);
        this.setForeground(FlowGlobals.ConversionWhite);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int panelHeight = this.getHeight();
        int panelWidth = this.getWidth();
        GradientPaint gradientPaint = switch (this.state.ordinal()) {
            case 1 -> {
                this.setBorder(this.defaultBorder);
                yield new GradientPaint(new Point(0, 0), new Color(6078461), new Point(0, this.getHeight()), new Color(3841501));
            }
            case 2 -> {
                this.setBorder(this.defaultBorder);
                yield new GradientPaint(new Point(0, 0), new Color(3382494), new Point(0, this.getHeight()), new Color(156578));
            }
            case 3 -> {
                this.setBorder(this.disabledBorder);
                yield new GradientPaint(new Point(0, 0), new Color(0xF7F7F7), new Point(0, this.getHeight()), new Color(0xE0E0E0));
            }
            default -> {
                this.setBorder(this.defaultBorder);
                yield new GradientPaint(new Point(0, 0), new Color(3382494), new Point(0, this.getHeight()), new Color(156578));
            }
        };
        if (g instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)g;
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, panelWidth, panelHeight);
        }
    }

    private void initializeBorders() {
        CompoundBorder tableBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 1, new Color(21139)), BorderFactory.createMatteBorder(1, 1, 0, 0, new Color(8175850))), BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(80742)));
        Border buttonInnerEmptyBorder = BorderFactory.createEmptyBorder(2, 7, 2, 7);
        CompoundBorder disabledCompoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(12305609)), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.defaultBorder = BorderFactory.createCompoundBorder(tableBorder, buttonInnerEmptyBorder);
        this.disabledBorder = BorderFactory.createCompoundBorder(disabledCompoundBorder, buttonInnerEmptyBorder);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.state = b ? State.DEFAULT : State.DISABLED;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.state.equals((Object)State.DISABLED)) {
            this.state = State.CLICK;
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.state.equals((Object)State.DISABLED)) {
            this.state = State.DEFAULT;
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.state.equals((Object)State.DISABLED)) {
            this.state = State.HOVER;
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.state.equals((Object)State.DISABLED)) {
            this.state = State.DEFAULT;
            this.repaint();
        }
    }

    private static enum State {
        DEFAULT,
        HOVER,
        CLICK,
        DISABLED;

    }
}

