/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.table;

import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BasePopupWindow;
import com.bmc.ctmconvert.base.BaseSimpleWaterMarkTextField;
import com.bmc.ctmconvert.base.table.ActionCheckListModel;
import com.bmc.ctmconvert.base.table.CheckList;
import com.bmc.ctmconvert.base.table.CheckListFilterType;
import com.bmc.ctmconvert.base.table.CollectionUtils;
import com.bmc.ctmconvert.base.table.DefaultCheckListModel;
import com.bmc.ctmconvert.base.table.DistinctColumnItem;
import com.bmc.ctmconvert.base.table.ICheckListModel;
import com.bmc.ctmconvert.base.table.IObjectToStringTranslator;
import com.bmc.ctmconvert.base.table.ITableFilter;
import com.bmc.ctmconvert.base.table.TableAwareCheckListRenderer;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.TextManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class BaseFilterableTableColumnPopup
extends BasePopupWindow
implements MouseListener {
    private boolean enabled = false;
    private final CheckList<DistinctColumnItem> filterList = new CheckList.Builder().build();
    private final BaseSimpleWaterMarkTextField searchField;
    JPanel filterPanel = new JPanel();
    private int mColumnIndex = -1;
    private final ITableFilter<?> filter;
    private boolean searchable;
    private IObjectToStringTranslator translator;
    private boolean actionsVisible = true;
    private boolean useTableRenderers = false;
    private Dimension preferredSize;
    private BaseButton apply;
    private ListDataListener listDataListener;

    public BaseFilterableTableColumnPopup(ITableFilter<?> filter) {
        super(true);
        this.filter = filter;
        this.filterList.getList().setVisibleRowCount(8);
        this.setupTableHeader();
        ((Container)filter.getTable()).addPropertyChangeListener("tableHeader", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BaseFilterableTableColumnPopup.this.setupTableHeader();
            }
        });
        this.filterPanel.setLayout(new BorderLayout());
        this.filterPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, FlowGlobals.ConversionUpperOuterBorderColor), BorderFactory.createMatteBorder(0, 0, 1, 0, FlowGlobals.ConversionUpperInnerBorderColor)), BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 2, 3, 0), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, FlowGlobals.ConversionWhite), BorderFactory.createMatteBorder(0, 0, 1, 0, FlowGlobals.ConversionLowerInnerBorderColor)))));
        this.filterPanel.setBackground(FlowGlobals.wrapperBackgroundColor);
        JLabel fiterIcon = new JLabel(new ImageIcon(FlowGlobals.class.getResource("/img/search.png")));
        fiterIcon.setPreferredSize(new Dimension(24, 20));
        this.filterPanel.add((Component)fiterIcon, "East");
        this.searchField = new BaseSimpleWaterMarkTextField(TextManager.instance().get("MAIN_NAVIGATION_FIND_STR"));
        ((JTextField)this.searchField.getComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.perform(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.perform(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.perform(e);
            }

            private void perform(DocumentEvent e) {
                BaseFilterableTableColumnPopup.this.filterList.filter(BaseFilterableTableColumnPopup.this.searchField.getText(), BaseFilterableTableColumnPopup.this.translator, CheckListFilterType.CONTAINS);
            }
        });
        this.filterPanel.add(this.searchField.getComponent(), "Center");
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public void setSearchTranslator(IObjectToStringTranslator tranlsator) {
        this.translator = tranlsator;
    }

    public void setActionsVisible(boolean actionsVisible) {
        this.actionsVisible = actionsVisible;
    }

    public void setUseTableRenderers(boolean reuseRenderers) {
        this.useTableRenderers = reuseRenderers;
    }

    private void setupTableHeader() {
        JTableHeader header = ((JTable)this.filter.getTable()).getTableHeader();
        if (header != null) {
            MouseListener[] headerMouseListener;
            for (MouseListener listener : headerMouseListener = header.getMouseListeners()) {
                header.removeMouseListener(listener);
            }
            header.addMouseListener(this);
            for (MouseListener listener : headerMouseListener) {
                header.addMouseListener(listener);
            }
        }
    }

    @Override
    protected JComponent buildContent() {
        BasePanel basePanel = new BasePanel();
        BaseContentPanel baseContentPanel = new BaseContentPanel();
        JPanel owner = new JPanel(new BorderLayout());
        owner.setBackground(FlowGlobals.wrapperBackgroundColor);
        owner.setPreferredSize(new Dimension(250, 150));
        if (this.searchable) {
            owner.add((Component)this.filterPanel, "North");
        }
        owner.add((Component)new JScrollPane(this.filterList.getList()), "Center");
        baseContentPanel.setContentPanel(owner);
        basePanel.setContentPanel(baseContentPanel);
        ArrayList<Component> compArray = new ArrayList<Component>();
        BaseButton clear = new BaseButton(new BasePopupWindow.CommandAction("Clear", "Clear all column filters", (Icon)new ImageIcon(this.getClass().getResource("/img/funnel_delete.png"))){

            @Override
            protected boolean perform() {
                return BaseFilterableTableColumnPopup.this.clearAllFilters();
            }
        });
        compArray.add(clear);
        compArray.add(Box.createRigidArea(new Dimension(59, 40)));
        compArray.add(Box.createHorizontalGlue());
        this.apply = new BaseButton(new BasePopupWindow.CommandAction("Apply"){

            @Override
            protected boolean perform() {
                return BaseFilterableTableColumnPopup.this.applyColumnFilter();
            }
        });
        this.listDataListener = new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                BaseFilterableTableColumnPopup.this.apply.setEnabled(!BaseFilterableTableColumnPopup.this.filterList.getCheckedItems().isEmpty());
            }
        };
        compArray.add(this.apply);
        compArray.add(Box.createHorizontalStrut(5));
        compArray.add(new BaseButton(new BasePopupWindow.CommandAction("Cancel")));
        BaseNavigationPanel navigationPanel = new BaseNavigationPanel(compArray);
        basePanel.setNavigationPanel(navigationPanel);
        return (JComponent)basePanel.getComponent();
    }

    private boolean applyColumnFilter() {
        Collection<DistinctColumnItem> checked = this.filterList.getCheckedItems();
        ICheckListModel<DistinctColumnItem> model = this.filterList.getModel();
        model.filter("", this.translator, CheckListFilterType.CONTAINS);
        this.filter.apply(this.mColumnIndex, checked);
        return true;
    }

    private boolean clearAllFilters() {
        this.filter.clear();
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void showFilterPopup(MouseEvent e) {
        JTableHeader header = (JTableHeader)e.getSource();
        TableColumnModel colModel = ((JTable)this.filter.getTable()).getColumnModel();
        int vColumnIndex = colModel.getColumnIndexAtX(e.getX());
        if (vColumnIndex < 0) {
            return;
        }
        Rectangle headerRect = ((JTable)this.filter.getTable()).getTableHeader().getHeaderRect(vColumnIndex);
        if (vColumnIndex == 0) {
            headerRect.width -= 2;
        } else {
            headerRect.grow(-2, 0);
        }
        if (!headerRect.contains(e.getX(), e.getY())) {
            return;
        }
        this.mColumnIndex = ((JTable)this.filter.getTable()).convertColumnIndexToModel(vColumnIndex);
        this.setPreferredSize(this.preferredSize);
        Collection<DistinctColumnItem> distinctItems = this.filter.getDistinctColumnItems(this.mColumnIndex);
        DefaultCheckListModel<DistinctColumnItem> model = new DefaultCheckListModel<DistinctColumnItem>(distinctItems);
        this.filterList.setModel(this.actionsVisible ? new ActionCheckListModel<DistinctColumnItem>(model) : model);
        Collection<DistinctColumnItem> checked = this.filter.getFilterState(this.mColumnIndex);
        this.filterList.setCheckedItems(CollectionUtils.isEmpty(checked) ? distinctItems : checked);
        if (this.useTableRenderers) {
            this.filterList.getList().setCellRenderer(new TableAwareCheckListRenderer((JTable)this.filter.getTable(), vColumnIndex));
        }
        this.show(header, headerRect.x, header.getHeight());
    }

    @Override
    protected void beforeShow() {
        if (this.searchable) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseFilterableTableColumnPopup.this.searchField.setText("");
                }
            });
        }
        this.filterList.getModel().addListDataListener(this.listDataListener);
    }

    @Override
    public void beforeHide() {
        this.preferredSize = this.getPreferredSize();
        this.filterList.getModel().removeListDataListener(this.listDataListener);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.enabled) {
            JTableHeader header = (JTableHeader)e.getSource();
            int colWidth = 0;
            for (int i = 0; i <= header.columnAtPoint(e.getPoint()); ++i) {
                colWidth += header.getColumnModel().getColumn(i).getWidth();
            }
            if ((double)colWidth - e.getPoint().getX() < 26.0) {
                this.filter.filterIsApplied(true);
                this.showFilterPopup(e);
            } else {
                this.filter.filterIsApplied(false);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

