/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseSplitButton;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class BaseTitlePanel
extends BaseComponent {
    private JPanel jPanel;
    private JPanel titlePanel;
    private JLabel panelTitleLabel;
    private JLabel panelSubTitleLabel;
    private String title;
    private String subTitle;
    private boolean generateHelpButton = true;

    public BaseTitlePanel() {
        this.initialize();
    }

    public BaseTitlePanel(String title) {
        this.title = title;
        this.initialize();
    }

    public BaseTitlePanel(String title, boolean helpButton) {
        this.title = title;
        this.generateHelpButton = helpButton;
        this.initialize();
    }

    public BaseTitlePanel(String title, String subTitle) {
        this.title = title;
        this.subTitle = subTitle;
        this.initialize();
    }

    private void initialize() {
        this.jPanel = new JPanel();
        this.jPanel.setBackground(Color.WHITE);
        this.jPanel.setLayout(new BoxLayout(this.jPanel, 1));
        if (this.title != null) {
            this.setTitlePanel();
        }
        if (this.subTitle != null) {
            this.setSubTitlePanel();
        }
    }

    private void setTitlePanel() {
        if (this.titlePanel != null) {
            this.jPanel.remove(this.titlePanel);
        }
        this.titlePanel = new JPanel();
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 0));
        this.titlePanel.setBackground(FlowGlobals.ConversionTitleBackground);
        this.titlePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, new Color(0xC5C5C5)), BorderFactory.createEmptyBorder(15, 20, 15, 18)));
        this.panelTitleLabel = new JLabel(this.title);
        this.panelTitleLabel.setFont(FlowGlobals.FONT_STYLE_BOLD_TITLE);
        this.panelTitleLabel.setForeground(FlowGlobals.ConversionTitleText);
        this.titlePanel.add(this.panelTitleLabel);
        this.titlePanel.add(Box.createHorizontalGlue());
        if (this.generateHelpButton) {
            ActionListener helpMenuAction = e -> this.fireNavegationEvent(e.getActionCommand());
            BaseButton helpButton = ButtonFactory.createButton(ButtonFactory.ButtonType.HELP);
            helpButton.addActionListener(helpMenuAction);
            helpButton.setText("");
            helpButton.setMnemonic(72);
            helpButton.setIcon(new ImageIcon(ButtonFactory.class.getResource(FlowGlobals.HELP_ICON)));
            BaseSplitButton splitButton = new BaseSplitButton(helpButton);
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem welcome = new JMenuItem(TextManager.instance().get("MAIN_NAVIGATION_WELCOME"));
            welcome.setMnemonic(87);
            welcome.addActionListener(helpMenuAction);
            welcome.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_WELCOME"));
            popupMenu.add(welcome);
            JMenuItem checkForNewVersion = new JMenuItem(TextManager.instance().get("MAIN_NAVIGATION_CHECK_FOR_NEW_VERSION"));
            checkForNewVersion.setMnemonic(67);
            checkForNewVersion.addActionListener(helpMenuAction);
            checkForNewVersion.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_CHECK_FOR_NEW_VERSION"));
            popupMenu.add(checkForNewVersion);
            if (this.shouldGenerateVerificationButton()) {
                JMenuItem verificationButton = new JMenuItem(TextManager.instance().get("MAIN_NAVIGATION_VERIFICATION_STR"));
                verificationButton.setMnemonic(86);
                verificationButton.addActionListener(helpMenuAction);
                popupMenu.add(verificationButton);
            }
            JMenuItem about = new JMenuItem(TextManager.instance().get("MAIN_NAVIGATION_ABOUT"));
            about.setMnemonic(65);
            about.addActionListener(helpMenuAction);
            about.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_ABOUT"));
            popupMenu.add(about);
            JMenuItem help = new JMenuItem(TextManager.instance().get("MAIN_NAVIGATION_HELP_CONTENT"));
            help.setMnemonic(72);
            help.addActionListener(helpMenuAction);
            help.setActionCommand(helpButton.getActionCommand());
            popupMenu.add(help);
            splitButton.setMenu(popupMenu);
            if (this.shouldGenerateVerificationButton()) {
                this.titlePanel.add(Box.createRigidArea(new Dimension(10, 0)));
            }
            this.titlePanel.add(splitButton);
        }
        this.jPanel.add(this.titlePanel);
    }

    private boolean shouldGenerateVerificationButton() {
        return SettingsBooleanKeys.isOnPremise();
    }

    private void setSubTitlePanel() {
        this.jPanel.add(Box.createRigidArea(new Dimension(0, 1)));
        JPanel titleSubPanel = new JPanel();
        titleSubPanel.setLayout(new BoxLayout(titleSubPanel, 0));
        titleSubPanel.setBackground(FlowGlobals.ConversionTitleBackground);
        titleSubPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, FlowGlobals.ConversionPanelsBorder), BorderFactory.createEmptyBorder(10, 20, 10, 18)));
        this.panelSubTitleLabel = new JLabel(this.subTitle);
        this.panelSubTitleLabel.setFont(FlowGlobals.FONT_STYLE_REGULAR);
        this.panelSubTitleLabel.setForeground(new Color(0));
        titleSubPanel.add(this.panelSubTitleLabel);
        titleSubPanel.add(Box.createHorizontalGlue());
        this.jPanel.add(titleSubPanel);
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.panelTitleLabel != null) {
            this.panelTitleLabel.setText(title);
        } else {
            this.setTitlePanel();
        }
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
        if (this.panelSubTitleLabel != null) {
            this.panelSubTitleLabel.setText(this.title);
        } else {
            this.setSubTitlePanel();
        }
    }

    @Override
    public Component getComponent() {
        return this.jPanel;
    }
}

