/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseTabbedPaneUI;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BaseTabbedPane
extends BaseComponent {
    public static int TOP = 1;
    public static int BOTTOM = 3;
    public static int LEFT = 2;
    public static int RIGHT = 4;
    private JTabbedPane jTabbedPane;
    private List<String> descriptions;

    public BaseTabbedPane() {
        this.initialize(1);
    }

    public BaseTabbedPane(int tabPlacement) {
        this.initialize(tabPlacement);
    }

    private void initialize(int tabPlacement) {
        this.jTabbedPane = new JTabbedPane(tabPlacement){
            private static final long serialVersionUID = 1L;

            @Override
            public Color getForegroundAt(int index) {
                return this.getSelectedIndex() == index ? FlowGlobals.ConversionTabText : FlowGlobals.ConversionSelectedTabText;
            }
        };
        this.jTabbedPane.setUI(new BaseTabbedPaneUI());
        this.jTabbedPane.setBorder(null);
        this.jTabbedPane.setFocusable(false);
        this.jTabbedPane.setFont(FlowGlobals.FONT_STYLE_REGULAR);
        this.descriptions = new ArrayList<String>();
        this.jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    BaseTabbedPane.this.fireDescriptionEvent(BaseTabbedPane.this.descriptions.get(BaseTabbedPane.this.jTabbedPane.getSelectedIndex()), true);
                }
                catch (Exception e1) {
                    BaseTabbedPane.this.fireDescriptionEvent("", false);
                }
            }
        });
    }

    public void addTab(String title, Component component) {
        if (component != null) {
            this.jTabbedPane.addTab(title, component);
        }
    }

    public void addTab(String title, String description, Component component) {
        if (component != null) {
            this.jTabbedPane.addTab(title, component);
            this.descriptions.add(description);
            if (this.jTabbedPane.getSelectedIndex() == this.jTabbedPane.getComponentCount() - 1) {
                this.fireDescriptionEvent(this.descriptions.get(this.jTabbedPane.getSelectedIndex()), true);
            }
        }
    }

    public int getSelectedIndex() {
        return this.jTabbedPane.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.jTabbedPane.setSelectedIndex(index);
    }

    public Component getComponent(int n) {
        return this.jTabbedPane.getComponent(n);
    }

    public void setTabPlacement(int tabPlacement) {
        this.jTabbedPane.setTabPlacement(tabPlacement);
    }

    public String getTitleAt(int index) {
        return this.jTabbedPane.getTitleAt(index);
    }

    public void setTitleAt(int index, String title) {
        this.jTabbedPane.setTitleAt(index, title);
    }

    public void addChangeListener(ChangeListener l) {
        this.jTabbedPane.addChangeListener(l);
    }

    @Override
    public Component getComponent() {
        return this.jTabbedPane;
    }
}

