/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BaseCheckBox
extends BaseComponent {
    private JCheckBox jCheckBox;
    private JPanel jPanel;
    private JLabel textLabel;
    private String text;

    public BaseCheckBox(String text) {
        this.text = text;
        this.initialize();
    }

    public BaseCheckBox(String text, String checkBoxName, String groupName) {
        this.text = text;
        this.componentName = checkBoxName;
        this.componentGroup = groupName;
        this.initialize();
    }

    private void initialize() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new BoxLayout(this.jPanel, 0));
        this.jCheckBox = new JCheckBox();
        this.jCheckBox.setBackground(Color.WHITE);
        this.jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseCheckBox.this.setValid(BaseCheckBox.this.jCheckBox.isSelected());
            }
        });
        this.jCheckBox.setName(this.text);
        this.jPanel.add(this.jCheckBox);
        this.jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.textLabel = new JLabel(this.text);
        this.textLabel.setFont(FlowGlobals.FONT_STYLE_REGULAR);
        this.textLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BaseCheckBox.this.jCheckBox.doClick();
            }
        });
        this.jPanel.add(this.textLabel);
    }

    public void setSelected(boolean b) {
        this.jCheckBox.setSelected(b);
    }

    public void doClick() {
        this.jCheckBox.doClick();
    }

    public void setBackground(Color bg) {
        this.jPanel.setBackground(bg);
    }

    public void addActionListener(ActionListener l) {
        this.jCheckBox.addActionListener(l);
    }

    public boolean isSelected() {
        return this.jCheckBox.isSelected();
    }

    public void setEnabled(boolean b) {
        this.jCheckBox.setEnabled(b);
        this.textLabel.setEnabled(b);
    }

    public void setVisible(boolean b) {
        this.jPanel.setVisible(b);
    }

    @Override
    public boolean isValid() {
        return this.isSelected();
    }

    @Override
    public Component getComponent() {
        return this.jPanel;
    }

    @Override
    public Object getData() {
        return new Boolean(this.jCheckBox.isSelected());
    }

    @Override
    public void setData(Object obj) {
        if (obj instanceof Boolean) {
            this.jCheckBox.setSelected((Boolean)obj);
        }
        if (obj instanceof String) {
            if (((String)obj).equalsIgnoreCase("Y")) {
                this.jCheckBox.setSelected(true);
            }
            if (((String)obj).equalsIgnoreCase("N")) {
                this.jCheckBox.setSelected(false);
            }
        }
    }

    @Override
    public void setActive(Boolean b) {
        super.setActive(b);
        this.setEnabled(b);
    }

    @Override
    public DataRetrievable.DataType getDataType() {
        return DataRetrievable.DataType.BOOLEAN;
    }

    @Override
    public void addValueChangedAction(final Actionable action) {
        this.jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.act();
            }
        });
    }
}

