/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseFilteredTree;
import com.bmc.ctmconvert.base.BaseListCellRenderer;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseSplitPane;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.DescriptionHandler;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.NoJobsFoundException;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractAssessmentReport
extends BasePanel
implements ActionListener,
TreeSelectionListener {
    private static final int VIEW_TYPE_LIST_AND_DESCRIPTION = 1;
    protected static final int VIEW_TYPE_DESCRIPTION_ONLY = 2;
    public static final String pathDelimiter = ";";
    protected BaseSplitPane mainSplitPane;
    protected BaseSplitPane rightHandSplitPane;
    protected BaseFilteredTree mainTree;
    protected JTextArea m_descriptionAreaText = null;
    protected JList m_selectionList = null;
    protected JPanel m_rightHandPanel = null;
    protected String pathName;
    protected String m_treeNodeParentName = "";
    protected String m_newline = System.getProperty("line.separator");
    protected static final int lowMachinesThreshold = 25;
    protected int lowMachinesUseCount = 0;
    protected ArrayList<String> listNamesOflowMachinesUse = new ArrayList();
    protected boolean m_bDescriptionAreaIncreased = true;
    protected static final String m_sNA = "N\\A";
    protected DefaultMutableTreeNode m_selectedNode = null;
    protected ArrayList<String> m_expandedNodesNamesList = new ArrayList();
    private boolean m_bNeedsManualExpand = false;
    private PrintStream m_originalErrorStream;
    private PrintStream m_newErrorStream;
    private ArrayList<String> m_descriptionTypeLookNodes = null;
    private ArrayList<String> m_descriptionTypeSplitLookNodes = null;
    protected HashMap<String, String> m_NodeName_NodeDescription = null;
    private String descriptionXMLFileName;
    private String optionalFile;
    protected DescriptionHandler m_descriptionTypeLookNodesHandler = (v, n, i) -> {
        int result = v;
        if (i == 1 && null != this.m_descriptionTypeLookNodes) {
            for (String nodeInList : this.m_descriptionTypeLookNodes) {
                if (!n.toString().startsWith(nodeInList)) continue;
                result = 2;
                break;
            }
        }
        return result;
    };

    public void setVisible(boolean b) {
    }

    public AbstractAssessmentReport(String pathName, String descriptionXMLFileName, String optionalFile) {
        this.descriptionXMLFileName = descriptionXMLFileName;
        this.optionalFile = optionalFile;
        this.m_originalErrorStream = System.err;
        this.pathName = pathName;
    }

    public boolean setSystemErrorOutputStream(String fileName) {
        if (null != this.m_newErrorStream) {
            this.m_newErrorStream.close();
        }
        try {
            this.m_newErrorStream = new PrintStream(fileName);
            System.setErr(this.m_newErrorStream);
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile("AbstractAssessmentReport - setSystemErrorOutputStream - failed");
            ExceptionHandler.writeToExceptionFile("File : " + fileName);
            ExceptionHandler.writeToExceptionFile("Exception : " + String.valueOf(e));
            if (null != this.m_newErrorStream) {
                this.m_newErrorStream.close();
            }
            System.setErr(this.m_originalErrorStream);
            return false;
        }
    }

    public void resetSystemErrorOutputStream() {
        if (null != this.m_newErrorStream) {
            this.m_newErrorStream.close();
        }
        System.setErr(this.m_originalErrorStream);
    }

    protected abstract void initSourceData(String var1, String var2, String var3) throws NoJobsFoundException;

    protected abstract DefaultMutableTreeNode getDefaultTreeModel();

    protected abstract String getJobInfo(String var1);

    protected String getJobInfo(DefaultMutableTreeNode node) {
        return null;
    }

    protected abstract ArrayList<String> getDescriptionTypeLookNodes();

    protected abstract ArrayList<String> getDescriptionTypeSplitLookNodes();

    protected abstract ArrayList<String> getSelectionList(String var1);

    protected abstract HashMap<String, String> getDescriptionNodes();

    protected abstract String getJobInfoFromSelectionList(String var1);

    protected void replaceTreeNodeChildren(DefaultMutableTreeNode nodeToReplace, ArrayList<String> childrenList) {
        if (null != nodeToReplace) {
            try {
                nodeToReplace.removeAllChildren();
                if (null != childrenList && childrenList.size() > 0) {
                    for (String child : childrenList) {
                        nodeToReplace.add(new DefaultMutableTreeNode(child));
                    }
                } else {
                    nodeToReplace.add(new DefaultMutableTreeNode(m_sNA));
                }
                this.mainTree.reload(nodeToReplace);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void actOnMouseClick(MouseEvent event) {
    }

    public int getLowMachinesUseCount() {
        return this.lowMachinesUseCount;
    }

    public void progressCancelClick() {
    }

    public void actOnPropertyChange(PropertyChangeEvent evt) {
    }

    public void init() throws NoJobsFoundException {
        this.initSourceData(this.pathName, this.descriptionXMLFileName, this.optionalFile);
        this.createTreePanel();
        this.createRightHandPanel();
        this.setDescriptionTypeLookNodes();
        this.setDescriptionTypeSplitLookNodes();
        this.setDescriptionNodes();
        this.mainTree.setSelectionRow(0);
        this.updateRightHandPanel();
        this.baseContentPanel = new BaseContentPanel();
        this.setNavigationPanel(new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.CLOSE}));
        this.mainSplitPane = new BaseSplitPane(1, this.mainTree.getComponent(), this.m_rightHandPanel);
        this.baseContentPanel.setContentPanel(this.mainSplitPane);
        this.setContentPanel(this.baseContentPanel);
    }

    public void setSelectedRow() {
        int selectedRow = this.mainTree.getSelectionRow();
        this.mainTree.setSelectionRow(-1);
        this.mainTree.setSelectionRow(selectedRow);
        this.mainTree.requestFocus();
    }

    public ArrayList<String> getListNamesOflowMachinesUse() {
        return this.listNamesOflowMachinesUse;
    }

    private void createRightHandPanel() {
        this.m_rightHandPanel = new JPanel(new GridLayout(0, 1));
        this.m_rightHandPanel.setBackground(Color.WHITE);
        this.m_descriptionAreaText = new JTextArea();
        this.m_descriptionAreaText.setEditable(false);
        this.m_descriptionAreaText.setBackground(Color.WHITE);
        this.m_descriptionAreaText.setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        this.m_rightHandPanel.add((Component)new JScrollPane(this.m_descriptionAreaText), "South");
        this.m_descriptionAreaText.setSelectionStart(0);
        this.m_descriptionAreaText.setSelectionEnd(0);
    }

    private void updateRightHandPanel() {
        JScrollPane selectionListScroll = null;
        JScrollPane descriptionAreaTextScroll = null;
        if (this.m_rightHandPanel != null) {
            this.m_rightHandPanel.removeAll();
        }
        if (this.m_selectionList != null) {
            selectionListScroll = new JScrollPane(this.m_selectionList);
            selectionListScroll.setBorder(null);
        }
        if (this.m_descriptionAreaText != null) {
            descriptionAreaTextScroll = new JScrollPane(this.m_descriptionAreaText);
            descriptionAreaTextScroll.setBorder(null);
            this.m_descriptionAreaText.setSelectionStart(0);
            this.m_descriptionAreaText.setSelectionEnd(0);
        }
        if (this.m_selectionList != null && this.m_descriptionAreaText != null) {
            this.rightHandSplitPane = new BaseSplitPane(0, selectionListScroll, descriptionAreaTextScroll);
            this.m_rightHandPanel.add(this.rightHandSplitPane.getComponent(), "Center");
        } else {
            this.m_rightHandPanel.add((Component)descriptionAreaTextScroll, "South");
        }
    }

    protected void updateDescriptionArea(String messageID, boolean clearJobsInfoArea, boolean bFromSelectionList) {
        if (clearJobsInfoArea) {
            this.m_descriptionAreaText.setText("");
        } else if (bFromSelectionList) {
            this.m_descriptionAreaText.setText(this.getJobInfoFromSelectionList(messageID));
        } else {
            String text = this.getJobInfo(messageID);
            if (text == null || text.isEmpty()) {
                text = this.getJobInfo((DefaultMutableTreeNode)this.mainTree.getLastSelectedPathComponent());
            }
            this.m_descriptionAreaText.setText(text);
        }
        this.m_descriptionAreaText.setSelectionStart(0);
        this.m_descriptionAreaText.setSelectionEnd(0);
    }

    protected void updateDescriptionAreaOfParentNode(String nodeName, DefaultMutableTreeNode node) {
        String name = nodeName.split("\\(")[0];
        this.m_descriptionAreaText.setText(this.m_NodeName_NodeDescription.get(name.trim()));
    }

    private void decreaseDescriptionInfoArea() {
        if (null != this.m_descriptionAreaText) {
            this.m_descriptionAreaText.removeAll();
            this.m_rightHandPanel.remove(this.m_descriptionAreaText);
            this.m_descriptionAreaText = null;
        }
        this.m_descriptionAreaText = new JTextArea();
        this.m_descriptionAreaText.setEditable(false);
        this.m_descriptionAreaText.setBackground(Color.WHITE);
        this.m_descriptionAreaText.setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        if (null != this.m_selectionList) {
            this.m_rightHandPanel.remove(this.m_selectionList);
            this.m_selectionList.removeAll();
            this.m_selectionList = null;
        }
        this.m_selectionList = new JList();
        this.m_selectionList.setCellRenderer(new BaseListCellRenderer());
        this.m_selectionList.setFixedCellHeight(20);
        this.m_selectionList.setSelectionMode(0);
        this.m_selectionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList jListSource = (JList)e.getSource();
                Object[] selection = jListSource.getSelectedValues();
                if (!e.getValueIsAdjusting()) {
                    for (int i = 0; i < selection.length; ++i) {
                        AbstractAssessmentReport.this.updateDescriptionArea((String)selection[i], false, true);
                    }
                }
            }
        });
        this.updateRightHandPanel();
    }

    private void increaseDescriptionInfoArea() {
        if (null != this.m_rightHandPanel) {
            this.m_rightHandPanel.remove(this.m_selectionList);
        }
        this.m_selectionList = null;
        this.updateRightHandPanel();
    }

    private void updateListArea(String messageID, boolean clearList) {
        if (clearList) {
            if (null != this.m_selectionList) {
                this.m_selectionList.removeAll();
                this.m_selectionList.setModel(new DefaultListModel());
            }
        } else {
            ArrayList<String> allJobs;
            if (null != this.m_selectionList) {
                this.m_selectionList.removeAll();
            }
            if (null != (allJobs = this.getSelectionList(messageID))) {
                this.m_selectionList.setListData(allJobs.toArray());
                this.m_selectionList.setName(this.getSelectionListPath());
            }
        }
        if (null != this.m_selectionList) {
            this.m_selectionList.updateUI();
        }
    }

    protected void setSelectionListPath(String path) {
        this.m_selectionList.setName(path);
    }

    protected String getSelectionListPath() {
        return this.m_selectionList.getName();
    }

    private void createTreePanel() {
        DefaultMutableTreeNode defaultTreeModel = this.getDefaultTreeModel();
        this.mainTree = new BaseFilteredTree(defaultTreeModel);
        this.mainTree.addTreeSelectionListener(this);
        this.mainTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                TreePath tp = e.getPath();
                int numberOfElements = tp.getPathCount();
                if (numberOfElements == 4) {
                    AbstractAssessmentReport.this.m_bNeedsManualExpand = true;
                    TreeSelectionEvent e1 = new TreeSelectionEvent((Object)AbstractAssessmentReport.this.mainTree, tp, true, tp, tp);
                    AbstractAssessmentReport.this.valueChanged(e1);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.mainTree.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent event) {
            }

            @Override
            public void mouseExited(MouseEvent event) {
            }

            @Override
            public void mouseReleased(MouseEvent event) {
            }

            @Override
            public void mousePressed(MouseEvent event) {
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                AbstractAssessmentReport.this.actOnMouseClick(event);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void setDescriptionTypeLookNodes() throws NoJobsFoundException {
        this.m_descriptionTypeLookNodes = this.getDescriptionTypeLookNodes();
    }

    private void setDescriptionTypeSplitLookNodes() {
        this.m_descriptionTypeSplitLookNodes = this.getDescriptionTypeSplitLookNodes();
    }

    private void setDescriptionNodes() {
        this.m_NodeName_NodeDescription = this.getDescriptionNodes();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        this.m_selectedNode = node;
        if (this.m_bNeedsManualExpand) {
            this.m_bNeedsManualExpand = false;
            if (!this.m_expandedNodesNamesList.contains(this.m_selectedNode.toString())) {
                this.m_expandedNodesNamesList.add(this.m_selectedNode.toString());
            } else {
                return;
            }
        }
        int viewType = 1;
        StringBuilder fullNodeName = new StringBuilder();
        if (!node.isLeaf() && node.getLevel() <= 1) {
            viewType = 2;
        } else {
            TreeNode[] nodePaths = node.getPath();
            block0: for (int i = 0; i < nodePaths.length; ++i) {
                fullNodeName.append(nodePaths[i].toString());
                fullNodeName.append(pathDelimiter);
                if (nodePaths.length == 1) {
                    viewType = 2;
                    break;
                }
                viewType = this.m_descriptionTypeLookNodesHandler.handleDescription(viewType, nodePaths[i], i);
                if (i < 1 || !node.isLeaf() || this.m_descriptionTypeSplitLookNodes == null) continue;
                for (String nodeInList : this.m_descriptionTypeSplitLookNodes) {
                    if (!nodePaths[i].toString().startsWith(nodeInList)) continue;
                    viewType = 1;
                    continue block0;
                }
            }
        }
        if (viewType == 1) {
            if (this.m_bDescriptionAreaIncreased) {
                this.decreaseDescriptionInfoArea();
                this.m_bDescriptionAreaIncreased = false;
            }
            this.updateListArea(fullNodeName.toString(), false);
        } else {
            if (!this.m_bDescriptionAreaIncreased) {
                this.increaseDescriptionInfoArea();
                this.m_bDescriptionAreaIncreased = true;
            }
            this.updateListArea("", true);
        }
        this.updateDescriptionArea(fullNodeName.toString(), node.toString().equalsIgnoreCase(m_sNA), !this.m_bDescriptionAreaIncreased);
        if (!node.isLeaf() && node.getLevel() <= 1) {
            this.updateDescriptionAreaOfParentNode(node.toString(), node);
        }
        this.mainTree.nodeChanged(node);
        this.updateRightHandPanel();
        this.m_rightHandPanel.validate();
        if (this.m_selectionList != null) {
            this.m_selectionList.setSelectedIndex(0);
        }
    }

    @Override
    public void navegationActionPerformed(ConversionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"))) {
            this.fireNavegationEvent(actionCommand);
        }
    }
}

