/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.api;

import com.bmc.ctmconvert.api.SapR3StepAPI;
import com.bmc.ctmconvert.exception.InvalidParameterException;
import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;

public class SapR3AbapStepAPI
extends SapR3StepAPI {
    public SapR3AbapStepAPI(CtmBaseEntity entity, int stepCount) {
        super(entity, stepCount);
        this.setDefaultParameters();
    }

    private void setDefaultParameters() {
        this.setAbapProgramType();
        this.setPrintArchiveMode(PrintArchiveMode.Print);
        this.setNumberOfCopies("1");
        this.setTimeOfPrint(TimeOfPrint.SendToSapSpooler);
        this.setPrintExpiration("8");
        this.enableNewSpoolRequest();
        this.setSapCoverPage(SapCoverPage.DefaultSetting);
        this.setOsCoverSheet(OsCoverSheet.DefaultSetting);
        this.setOutputFormatRows("65");
        this.setOutputFormatColumns("85");
    }

    private void setAbapProgramType() {
        this.setVariable("%%%%SAPR3-STEP-S%02d-STEP_TYPE", SapR3StepAPI.ProgramType.ABAP.toString());
    }

    public void setAbapProgramName(String abapProgramName) {
        this.setProgramName(abapProgramName);
    }

    public String getAbapProgramName() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-PROGRAM");
    }

    public void setTemporaryVariant() {
        this.setVariableType(VariantType.Temporary);
    }

    public void setRegularVariant() {
        this.setVariableType(VariantType.Regular);
    }

    public void setNumberOfCopies(String numberOfCopies) {
        try {
            Integer.parseInt(numberOfCopies);
        }
        catch (NumberFormatException e) {
            throw new InvalidParameterException("setNumberOfCopies", "Strings representing a number");
        }
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_COPIES", numberOfCopies);
    }

    public String getNumberOfCopies() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-PRINT_COPIES");
    }

    public void setPrintExpiration(String printExpiration) {
        try {
            int printExpirationIntegerValue = Integer.parseInt(printExpiration);
            if (printExpirationIntegerValue < 0 || printExpirationIntegerValue > 9) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidParameterException("setPrintExpiration", "Strings representing a number between 0-9");
        }
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_EXPIRATION", printExpiration);
    }

    public String getPrintExpiration() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-PRINT_EXPIRATION");
    }

    public void setSapCoverPage(SapCoverPage sapCoverPage) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_BANNER", sapCoverPage.toString());
    }

    public String getSapCoverPage() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-PRINT_BANNER");
    }

    public void setOsCoverSheet(OsCoverSheet osCoverSheet) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_HOST_BANNER", osCoverSheet.toString());
    }

    public String getOsCoverSheet() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-PRINT_HOST_BANNER");
    }

    public void setTimeOfPrint(TimeOfPrint timeOfPrint) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_IMMED", timeOfPrint.toString());
    }

    public String getTimeOfPrint() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-PRINT_IMMED");
    }

    public void setOutputFormatRows(String outPutFormatRows) {
        try {
            Integer.parseInt(outPutFormatRows);
        }
        catch (NumberFormatException e) {
            throw new InvalidParameterException("setOutPutFormatRows", "Strings representing a number between 0-255");
        }
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_NUMLINES", outPutFormatRows);
    }

    public String getOutputFormatRows() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-PRINT_NUMLINES");
    }

    public void setOutputFormatColumns(String outPutFormatColumns) {
        try {
            Integer.parseInt(outPutFormatColumns);
        }
        catch (NumberFormatException e) {
            throw new InvalidParameterException("setOutPutFormatColumns", "Strings representing a number");
        }
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_NUMCOLUMNS", outPutFormatColumns);
    }

    public String getOutputFormatColumns() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-PRINT_NUMCOLUMNS");
    }

    public void setPrintArchiveMode(PrintArchiveMode printArchiveMode) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_ARCHMODE", printArchiveMode.toString());
    }

    public String getPrintArchiveMode() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-PRINT_ARCHMODE");
    }

    public void setOutputDevice(String outputDevice) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_DEST", outputDevice);
    }

    public String getOutputDevice() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-PRINT_DEST");
    }

    public void setRecipient(String recipient) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_RECIPIENT", recipient);
    }

    public String getRecipient() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-PRINT_RECIPIENT");
    }

    public void setDepartment(String department) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-DEPT", department);
    }

    public String getDepartment() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-DEPT");
    }

    public void setSpoolRequestName(String spoolRequestName) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-LIST_NAME", spoolRequestName);
    }

    public String getSpoolRequestName() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-LIST_NAME");
    }

    public void setSpoolRequestTitles(String spoolRequestTitles) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-LIST_TEXT", spoolRequestTitles);
    }

    public String getSpoolRequestTitles() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-LIST_TEXT");
    }

    public void setSpoolRequestAuthorization(String spoolRequestAuthorization) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_AUTH", spoolRequestAuthorization);
    }

    public String getSpoolRequestAuthorization() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-PRINT_AUTH");
    }

    public void setOutputFormatLayout(String outputFormatLayout) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_LAYOUT", outputFormatLayout);
    }

    public String getOutputFormatLayout() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-PRINT_LAYOUT");
    }

    public void setLanguage(String language) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-LANGU", language);
    }

    public String getLanguage() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-LANGU");
    }

    public void enableNewSpoolRequest() {
        this.setVariable("%%%%SAPR3-STEP-S%02d-NEW_LIST_ID", SapR3StepAPI.CheckBoxStatus.Selected.toString());
    }

    public boolean isNewSpoolRequest() {
        String value = this.getVariableValue("%%%%SAPR3-STEP-S%02d-NEW_LIST_ID");
        return "X".equals(value);
    }

    public boolean isTemporaryVariant() {
        String value = this.getVariableValue("%%%%SAPR3-STEP-S%02d-VAR_TYPE");
        return VariantType.Temporary.toString().equals(value);
    }

    public void disableNewSpoolRequest() {
        this.setVariable("%%%%SAPR3-STEP-S%02d-NEW_LIST_ID", SapR3StepAPI.CheckBoxStatus.NotSelected.toString());
    }

    public void enableDeleteAfterPrint() {
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_RELEASE", SapR3StepAPI.CheckBoxStatus.Selected.toString());
    }

    public boolean isDeleteAfterPrint() {
        String value = this.getVariableValue("%%%%SAPR3-STEP-S%02d-PRINT_RELEASE");
        return "X".equals(value);
    }

    public void disableDeleteAfterPrint() {
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_RELEASE", SapR3StepAPI.CheckBoxStatus.NotSelected.toString());
    }

    public void enableSelectionCoverPage() {
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_BANNER_PAGE", SapR3StepAPI.CheckBoxStatus.Selected.toString());
    }

    public boolean isSelectionCoverPage() {
        String value = this.getVariableValue("%%%%SAPR3-STEP-S%02d-PRINT_BANNER_PAGE");
        return "X".equals(value);
    }

    public void disableSelectionCoverPage() {
        this.setVariable("%%%%SAPR3-STEP-S%02d-PRINT_BANNER_PAGE", SapR3StepAPI.CheckBoxStatus.NotSelected.toString());
    }

    public void setArchiveId(String archiveId) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-ARCH_ID", archiveId);
    }

    public String getArchiveId() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-ARCH_ID");
    }

    public void setArchiveDocumentType(String archiveDocumentType) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-ARCHIVE_OBJECT", archiveDocumentType);
    }

    public String getArchiveDocumentType() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-ARCHIVE_OBJECT");
    }

    public void setArchiveInformationField(String archiveInformationField) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-ARCHIVE_INFO", archiveInformationField);
    }

    public String getArchiveInformationField() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-ARCHIVE_INFO");
    }

    public void setArchiveText(String archiveText) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-ARCH_TEXT", archiveText);
    }

    public String getArchiveText() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-ARCH_TEXT");
    }

    public static enum PrintArchiveMode {
        Print("Print"),
        Archive("ARCHIVE"),
        PrintAndArchive("PRINT_ARCHIVE");

        private final String value;

        private PrintArchiveMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum TimeOfPrint {
        PrintLater("A"),
        PrintOutImmediately("X"),
        SendToSapSpooler("N");

        private final String value;

        private TimeOfPrint(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum SapCoverPage {
        DefaultSetting("D"),
        Print("X"),
        DoNotPrint("N");

        private final String value;

        private SapCoverPage(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum OsCoverSheet {
        DefaultSetting("D"),
        Print("X"),
        DoNotPrint("N");

        private final String value;

        private OsCoverSheet(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum VariantType {
        Regular("REG"),
        Temporary("TMP");

        private final String value;

        private VariantType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

