/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.api;

import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;

public class FileWatcherParametersAPI {
    private CtmBaseEntity entity;

    public FileWatcherParametersAPI(CtmBaseEntity entity) {
        this.entity = entity;
    }

    public void initDefaults() {
        this.entity.addAttribute("TASKTYPE", "Job");
        this.entity.addAttribute("APPL_FORM", "File Watcher");
        this.entity.addAttribute("APPL_TYPE", "FileWatch");
        this.entity.addAttribute("APPL_VER", "W2K/XP");
        this.entity.addAttribute("CM_VER", "610");
        this.entity.setVariable("%%FileWatch-MIN_DET_SIZE", "0");
        this.entity.setVariable("%%FileWatch-INT_FILE_SEARCHES", "60");
        this.entity.setVariable("%%FileWatch-INT_FILESIZE_COMPARISON", "10");
        this.entity.setVariable("%%FileWatch-NUM_OF_ITERATIONS", "3");
        this.entity.setVariable("%%FileWatch-TIME_LIMIT", "0");
        this.entity.setVariable("%%FileWatch-MIN_AGE", "NO_MIN_AGE");
        this.entity.setVariable("%%FileWatch-MAX_AGE", "NO_MAX_AGE");
        this.entity.setVariable("%%FileWatch-PATH", "Not in use for File Watcher jobs");
        this.entity.setVariable("%%FileWatch-MODE", "CREATE");
        this.entity.setVariable("%%FileWatch-FILESIZE_WILDCARD", "N");
        this.entity.setVariable("%%FileWatch-START_TIME", "NOW");
        this.entity.setVariable("%%FileWatch-STOP_TIME", "0");
    }

    public void setPath(String path) {
        this.entity.setVariable("%%FileWatch-FILE_PATH", path);
    }

    public void setMode(FileWatcherMode mode) {
        switch (mode.ordinal()) {
            case 1: {
                this.entity.setVariable("%%FileWatch-MODE", "CREATE");
                break;
            }
            case 0: {
                this.entity.setVariable("%%FileWatch-MODE", "DELETE");
            }
        }
    }

    public void setMinimumSize(String size, FileWatcherSizeIn units) {
        String unitSuffix = switch (units.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "B";
            case 1 -> "K";
            case 2 -> "M";
            case 3 -> "G";
        };
        this.entity.setVariable("%%FileWatch-MIN_DET_SIZE", size + unitSuffix);
    }

    public void setSearchInterval(String seconds) {
        this.entity.setVariable("%%FileWatch-INT_FILE_SEARCHES", seconds);
    }

    public void setFileSizeInterval(String seconds) {
        this.entity.setVariable("%%FileWatch-INT_FILESIZE_COMPARISON", seconds);
    }

    public void setIterations(String iterations) {
        this.entity.setVariable("%%FileWatch-NUM_OF_ITERATIONS", iterations);
    }

    public void setTimeLimit(String minutes) {
        this.entity.setVariable("%%FileWatch-TIME_LIMIT", minutes);
    }

    public void setEnableWildcardSupport() {
        this.entity.setVariable("%%FileWatch-FILESIZE_WILDCARD", "Y");
    }

    public void setDisableWildcardSupport() {
        this.entity.setVariable("%%FileWatch-FILESIZE_WILDCARD", "N");
    }

    public void setTimeFrameStart(String value) {
        this.entity.setVariable("%%FileWatch-START_TIME", value);
    }

    public void setTimeFrameStop(String value) {
        this.entity.setVariable("%%FileWatch-STOP_TIME", value);
    }

    public void setMinimalAge(String value) {
        this.entity.setVariable("%%FileWatch-MIN_AGE", value);
    }

    public void setMaximalAge(String value) {
        this.entity.setVariable("%%FileWatch-MAX_AGE", value);
    }

    public static enum FileWatcherMode {
        DELETE,
        CREATE;

    }

    public static enum FileWatcherSizeIn {
        BYTES,
        KB,
        MB,
        GB;

    }
}

