/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.BeanField;
import com.opencsv.exceptions.CsvBeanIntrospectionException;
import com.opencsv.exceptions.CsvConstraintViolationException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public abstract class AbstractBeanField<T>
implements BeanField<T> {
    protected Field field;
    private PropertyUtilsBean propUtils;
    protected boolean required;
    private static final String REQUIRED_FIELD_EMPTY_MESSAGE = "Field '%s' is mandatory but no value was provided.";

    public AbstractBeanField() {
        this.required = false;
    }

    public AbstractBeanField(Field field) {
        this.field = field;
        this.required = false;
    }

    public AbstractBeanField(Field field, boolean required) {
        this.field = field;
        this.required = required;
    }

    @Override
    public void setField(Field field) {
        this.field = field;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public final <T> void setFieldValue(T bean, String value) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        if (this.required && StringUtils.isBlank((CharSequence)value)) {
            throw new CsvRequiredFieldEmptyException(bean.getClass(), this.field, String.format(REQUIRED_FIELD_EMPTY_MESSAGE, this.field.getName()));
        }
        try {
            this.assignValueToField(bean, this.convert(value));
        }
        catch (CsvRequiredFieldEmptyException e) {
            throw new CsvRequiredFieldEmptyException(bean.getClass(), this.field, e.getLocalizedMessage());
        }
    }

    private <T> void assignValueToField(T bean, Object obj) throws CsvDataTypeMismatchException {
        if (obj != null) {
            Class<?> fieldType = this.field.getType();
            String setterName = "set" + Character.toUpperCase(this.field.getName().charAt(0)) + this.field.getName().substring(1);
            try {
                Method setterMethod = bean.getClass().getMethod(setterName, fieldType);
                try {
                    setterMethod.invoke(bean, obj);
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(obj, fieldType, e.getLocalizedMessage());
                    csve.initCause(e);
                    throw csve;
                }
            }
            catch (NoSuchMethodException e1) {
                this.writeWithoutSetter(bean, obj);
            }
            catch (SecurityException e1) {
                this.writeWithoutSetter(bean, obj);
            }
        }
    }

    private <T> void writeWithoutSetter(T bean, Object obj) throws CsvDataTypeMismatchException {
        try {
            FieldUtils.writeField((Field)this.field, bean, (Object)obj, (boolean)true);
        }
        catch (IllegalAccessException e2) {
        }
        catch (IllegalArgumentException e2) {
            CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(obj, this.field.getType());
            csve.initCause(e2);
            throw csve;
        }
    }

    protected abstract Object convert(String var1) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException;

    @Override
    public final String write(T bean) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        String result = null;
        if (bean != null && this.field != null) {
            Object value;
            if (this.propUtils == null) {
                this.propUtils = new PropertyUtilsBean();
            }
            try {
                value = this.propUtils.getSimpleProperty(bean, this.field.getName());
            }
            catch (IllegalAccessException e) {
                CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(bean, this.field);
                csve.initCause(e);
                throw csve;
            }
            catch (InvocationTargetException e) {
                CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(bean, this.field);
                csve.initCause(e);
                throw csve;
            }
            catch (NoSuchMethodException e) {
                CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(bean, this.field);
                csve.initCause(e);
                throw csve;
            }
            if (value == null && this.required) {
                throw new CsvRequiredFieldEmptyException(bean.getClass(), this.field, String.format(REQUIRED_FIELD_EMPTY_MESSAGE, this.field.getName()));
            }
            try {
                result = this.convertToWrite(value);
            }
            catch (CsvDataTypeMismatchException e) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(bean, this.field.getType(), e.getMessage());
                csve.initCause(e.getCause());
                throw csve;
            }
            catch (CsvRequiredFieldEmptyException e) {
                CsvRequiredFieldEmptyException csve = new CsvRequiredFieldEmptyException(bean.getClass(), this.field, e.getMessage());
                csve.initCause(e.getCause());
                throw csve;
            }
        }
        return result;
    }

    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        return value == null ? "" : value.toString();
    }
}

