/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.jobtypes.sap;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.autosys.jobtypes.sap.SapConverterHelper;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.sap.SapR3CommonWrapper;
import com.bmc.ctmconvert.sap.SapR3CreateWrapper;
import com.bmc.ctmconvert.sap.Step;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SapR3CreateConverter {
    private final AutosysJob autosysJob;
    private final SapConverterHelper sapConverterHelper;
    private static final List<String> YES_VALUES = List.of("Y", "T", "YES", "TRUE");

    public SapR3CreateConverter(AutosysJob autosysJob) {
        this.autosysJob = autosysJob;
        this.sapConverterHelper = new SapConverterHelper(autosysJob);
    }

    public void convert() {
        new SapR3CommonWrapper((SchedEntity)this.autosysJob).setSapJobName(this.sapConverterHelper.getSapJobName());
        SapR3CreateWrapper sapR3CreateWrapper = SapR3CreateWrapper.convertToSapJob((SchedEntity)this.autosysJob).setStartCondition(this.sapConverterHelper.getSapReleaseOption());
        this.sapConverterHelper.getSapMonChild().ifPresent(v -> sapR3CreateWrapper.setJobWaitChild());
        this.getSapStep().ifPresent(arg_0 -> ((SapR3CreateWrapper)sapR3CreateWrapper).addStep(arg_0));
    }

    private Optional<Step> getSapStep() {
        Map<String, String> parameters = this.getParameters();
        return this.convertStep(parameters);
    }

    private Optional<Step> convertStep(Map<String, String> parameters) {
        if (parameters.entrySet().isEmpty()) {
            return Optional.empty();
        }
        Step step = new Step(1, parameters.get("abap_name"), Optional.ofNullable(parameters.get("variant")).orElse(""));
        this.convertBannerPage(parameters).ifPresent(arg_0 -> ((Step)step).setPrintBanner(arg_0));
        this.convertPrintImm(parameters).ifPresent(arg_0 -> ((Step)step).setPrintImmed(arg_0));
        this.convertPrintRelease(parameters).ifPresent(arg_0 -> ((Step)step).setPrintRelease(arg_0));
        this.convertNewSpool(parameters).ifPresent(arg_0 -> ((Step)step).setNewListId(arg_0));
        return Optional.of(step);
    }

    private Map<String, String> getParameters() {
        return Optional.ofNullable(this.sapConverterHelper.getJobTypeHelper().getSourceAttribute("sap_step_parms")).filter(v -> !"NULL".equals(v)).map(ps -> List.of(ps.split(","))).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(this.getStepKey(), this.getStepValue()));
    }

    private Optional<String> convertNewSpool(Map<String, String> parameters) {
        return Optional.ofNullable(parameters.get("release")).map(v -> YES_VALUES.contains(v) ? "X" : "N");
    }

    private Optional<String> convertPrintRelease(Map<String, String> parameters) {
        return Optional.ofNullable(parameters.get("release")).map(v -> YES_VALUES.contains(v) ? "X" : "N");
    }

    private Optional<String> convertPrintImm(Map<String, String> parameters) {
        return Optional.ofNullable(parameters.get("print_imm")).map(v -> YES_VALUES.contains(v) ? "X" : "N");
    }

    private Optional<String> convertBannerPage(Map<String, String> parameters) {
        return Optional.ofNullable(parameters.get("banner_page")).map(v -> YES_VALUES.contains(v) ? "X" : "N");
    }

    private Function<String, String> getStepValue() {
        return keyAndValue -> {
            String value = keyAndValue.split("=")[1];
            return GlobalFunctions.removeQuotesIfNeeded((String)value);
        };
    }

    private Function<String, String> getStepKey() {
        return keyAndValue -> {
            String key = keyAndValue.split("=")[0];
            return GlobalFunctions.removeQuotesIfNeeded((String)key);
        };
    }
}

