/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.jobtypes;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.dummy.DummyUtils;
import java.util.Optional;

public class ZosConverter {
    private final AutosysJob job;
    private String memname;
    private String memlib;

    public ZosConverter(AutosysJob autosysJob) {
        this.job = autosysJob;
    }

    public void convert() {
        this.getZosParameters();
        if (this.job.isInSubFolder()) {
            this.job.addAutoEdits("%%ZOS_MEMBER", this.memname);
            this.job.addAutoEdits("%%ZOS_LIBRARY", this.memlib);
            this.getAffinity().ifPresent(affinity -> this.job.addAutoEdits("%%ZOS_MACHINE", (String)affinity));
            DummyUtils.convertToDummyJob((SchedEntity)this.job);
        } else {
            this.job.setZOSJob();
            this.job.addAttribute("MEMNAME", this.memname);
            this.job.addAttribute("MEMLIB", this.memlib);
            this.getAffinity().ifPresent(affinity -> this.job.addAttribute("SYSTEM_AFFINITY", (String)affinity));
        }
    }

    private void getZosParameters() {
        this.getAffinity();
        this.memname = this.job.getSourceAttr("jcl_member");
        String[] jclArray = this.job.getSourceAttr("jcl_library").split("[()]");
        if (jclArray.length == 1) {
            this.memberNotEqualToLibraryMember(this.memname, jclArray[0]);
        } else {
            this.memberInLibrary(jclArray);
        }
    }

    private Optional<String> getAffinity() {
        return Optional.ofNullable(this.job.getSourceAttr("machine")).filter(machine -> !machine.isEmpty()).map(machine -> {
            if (machine.length() > 4) {
                return machine.substring(0, 4);
            }
            return machine;
        }).map(String::toUpperCase);
    }

    private String padWithSpacesUpToLength(String jcl, int lengthOfString) {
        String padding = " ".repeat(lengthOfString);
        String jclWithPadding = jcl + padding;
        return jclWithPadding.substring(0, lengthOfString);
    }

    private void memberInLibrary(String[] jclArray) {
        String jclLibrary = jclArray[0];
        String jclMemberInLibrary = jclArray[1];
        if (this.memname.isEmpty()) {
            this.memname = jclMemberInLibrary;
            this.memlib = jclLibrary;
        } else if (this.memname.equals(jclMemberInLibrary)) {
            this.memlib = jclLibrary;
        } else {
            this.memberNotEqualToLibraryMember(this.memname, jclLibrary);
        }
    }

    private void memberNotEqualToLibraryMember(String jclMember, String jclLibrary) {
        String library = this.padWithSpacesUpToLength(jclLibrary, 44);
        String member = this.padWithSpacesUpToLength(jclMember, 8);
        this.memlib = "0072%%INCLIB " + library + " %%INCMEM " + member + " ";
        this.job.addAttribute("USE_INSTREAM_JCL", "Y");
    }
}

