/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.jobtypes;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import java.util.HashMap;
import java.util.Optional;

public class AutosysFileWatcherConverter {
    private final AutosysJob autosysJob;
    private final IAttrHolder sourceAttributes;

    public AutosysFileWatcherConverter(AutosysJob autosysJob) {
        this.autosysJob = autosysJob;
        this.sourceAttributes = autosysJob.getSourceAttr();
    }

    public void convertFileWatch() {
        String minSize = this.getMinFileSize();
        if (this.autosysJob.getRules().getTaskTypeHandler().isToDummy()) {
            this.autosysJob.addAttribute("TASKTYPE", "Dummy");
        } else {
            this.autosysJob.addAttribute("TASKTYPE", "Job");
        }
        this.autosysJob.addAttribute("MEMLIB", "Not in use for File Watcher jobs");
        this.autosysJob.addAttribute("MEMNAME", this.autosysJob.getJobName());
        if (this.autosysJob.getRules().getStringRule("Autosys rules", new String[]{"FileWatcherType"}).equalsIgnoreCase("FILE_WATCHER")) {
            this.convertToFileWatcher(minSize);
        } else {
            this.convertToAft(minSize);
        }
        this.autosysJob.getOptionalAttributes().add("APPL_FORM");
        this.autosysJob.getOptionalAttributes().add("APPL_TYPE");
        this.autosysJob.getOptionalAttributes().add("APPL_VER");
        this.autosysJob.getOptionalAttributes().add("CM_VER");
    }

    private Optional<String> getWatchInterval() {
        String watchInterval = this.sourceAttributes.getAttr("watch_interval").trim();
        if (watchInterval.isEmpty() || watchInterval.equals("NULL")) {
            watchInterval = "60";
        } else if (!watchInterval.matches("\\d+")) {
            this.autosysJob.addMessage("WRN4005", "watch_interval", watchInterval);
            return Optional.empty();
        }
        return Optional.of(watchInterval);
    }

    private Optional<String> getWatchedFile() {
        String watchedFile = GlobalFunctions.removeQuotesIfNeeded((String)this.autosysJob.getHandleBuiltinAutoEdits().handle(this.sourceAttributes.getAttr("watch_file").trim()));
        if (watchedFile.isEmpty() || watchedFile.equals("NULL")) {
            this.autosysJob.addMessage("ERR4001", "watch_file", this.sourceAttributes.getAttr("insert_job"));
            this.sourceAttributes.setAttr("JOBNAME", "Not converted");
            this.autosysJob.setIsValid(false);
            return Optional.empty();
        }
        return Optional.of(watchedFile);
    }

    private String getMinFileSize() {
        String minSize = this.sourceAttributes.getAttr("watch_file_min_size").trim();
        if (minSize.isEmpty() || minSize.equals("NULL")) {
            minSize = "0";
        } else if (!minSize.matches("\\d+")) {
            minSize = "0";
            this.autosysJob.addMessage("WRN4005", "watch_file_min_size", minSize);
        } else {
            minSize = this.convertKBToBytes(minSize);
        }
        return minSize;
    }

    private void convertToAft(String minSize) {
        this.getWatchedFile().ifPresent(watchedFile -> this.autosysJob.getAutoedits().put("%%FTP-LPATH1", (String)watchedFile));
        this.autosysJob.addAttribute("APPL_FORM", "AFT");
        this.autosysJob.addAttribute("APPL_TYPE", "FILE_TRANS");
        this.autosysJob.addAttribute("APPL_VER", "6.1.01");
        this.autosysJob.addAttribute("CM_VER", "610");
        this.autosysJob.getAutoedits().put("%%FTP-ACCOUNT", this.autosysJob.getAttr("OWNER"));
        this.autosysJob.getAutoedits().put("%%FTP-TRANSFER_NUM", "1");
        this.autosysJob.getAutoedits().put("%%FTP-UPLOAD1", "4");
        this.autosysJob.getAutoedits().put("%%FTP-MINSIZE1", minSize);
        this.autosysJob.getAutoedits().put("%%FTP-TIMELIMIT1", this.convertTtl());
        this.getWatchInterval().ifPresent(watchInterval -> {
            this.autosysJob.getAutoedits().put("%%FTP-OVERRIDE_WATCH_INTERVAL1", "1");
            this.autosysJob.getAutoedits().put("%%FTP-WATCH_INTERVAL1", (String)watchInterval);
        });
        this.addAFTAction();
    }

    private void convertToFileWatcher(String minSize) {
        this.getWatchedFile().ifPresent(watchedFile -> this.autosysJob.getAutoedits().put("%%FileWatch-FILE_PATH", (String)watchedFile));
        this.autosysJob.addAttribute("APPL_FORM", "File Watcher");
        this.autosysJob.addAttribute("APPL_TYPE", "FileWatch");
        this.autosysJob.addAttribute("APPL_VER", "W2K/XP");
        this.autosysJob.addAttribute("CM_VER", "610");
        this.autosysJob.getAutoedits().put("%%FileWatch-MIN_DET_SIZE", minSize);
        this.autosysJob.getAutoedits().put("%%FileWatch-INT_FILE_SEARCHES", this.getWatchInterval().orElse("60"));
        this.autosysJob.getAutoedits().put("%%FileWatch-INT_FILESIZE_COMPARISON", "10");
        this.autosysJob.getAutoedits().put("%%FileWatch-NUM_OF_ITERATIONS", "3");
        this.autosysJob.getAutoedits().put("%%FileWatch-TIME_LIMIT", this.convertTtl());
        this.autosysJob.getAutoedits().put("%%FileWatch-MIN_AGE", "NO_MIN_AGE");
        this.autosysJob.getAutoedits().put("%%FileWatch-MAX_AGE", "NO_MAX_AGE");
        this.autosysJob.getAutoedits().put("%%FileWatch-PATH", "Not in use for File Watcher jobs");
        this.autosysJob.getAutoedits().put("%%FileWatch-MODE", "CREATE");
        this.autosysJob.getAutoedits().put("%%FileWatch-FILESIZE_WILDCARD", "N");
        this.autosysJob.getAutoedits().put("%%FileWatch-START_TIME", "NOW");
        this.autosysJob.getAutoedits().put("%%FileWatch-STOP_TIME", "0");
        this.getProfile().ifPresent(profile -> this.autosysJob.getAutoedits().put("%%PRECMD", (String)profile));
    }

    private Optional<String> getProfile() {
        Optional<String> profile = Optional.ofNullable(this.sourceAttributes.getAttr("profile")).filter(value -> !value.equals("NULL"));
        return profile.flatMap(value -> {
            Optional<String> sourceCommand = Optional.ofNullable(this.autosysJob.getRules().getStringRule("Autosys rules", new String[]{"SourceCommand"})).filter(v -> !v.isEmpty());
            return sourceCommand.map(sourceCmd -> sourceCmd + " " + value);
        });
    }

    private String convertTtl() {
        String watcherTTL = this.sourceAttributes.getAttr("term_run_time").trim();
        if (watcherTTL.isEmpty() || watcherTTL.equals("NULL")) {
            watcherTTL = "0";
        } else if (!watcherTTL.matches("^\\d+$")) {
            watcherTTL = "0";
            this.autosysJob.addMessage("WRN4005", "term_run_time", watcherTTL);
        }
        return watcherTTL;
    }

    private String convertKBToBytes(String minSize) {
        long sizeInt = Long.parseLong(minSize);
        return Long.toString(sizeInt *= 1024L);
    }

    private void addAFTAction() {
        HashMap<String, String> aftAction = new HashMap<String, String>();
        aftAction.put("ACTENTTYPE", "AFTACC");
        aftAction.put("JOBID", this.autosysJob.getJobName());
        aftAction.put("ACTENTNAME", this.sourceAttributes.getAttr("OWNER"));
        aftAction.put("ACTSTATUS", "0");
        Reporter.addAction(aftAction);
    }
}

