/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.handlers;

import com.bmc.ctmconvert.autosys.AutosysGlobals;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class StartTimesHandler {
    private final IAttrHolder sourceAttr;
    private final Map<String, String> jobAttr;
    private final List<String> messages;
    private final String jobName;
    private static final String VALID_TIME_FORMAT = "^[0-9]{2}:[0-9]{2}$";

    public StartTimesHandler(IAttrHolder sourceAttr, Map<String, String> m_jobAttr, List<String> messages, String jobName) {
        this.sourceAttr = sourceAttr;
        this.jobAttr = m_jobAttr;
        this.messages = messages;
        this.jobName = jobName;
    }

    public void startTimesToAttribute() {
        this.jobAttr.put("CYCLIC", "1");
        String startTimes = this.sourceAttr.getAttr("start_times");
        startTimes = startTimes.replaceAll("[ \t\"]+", "");
        String[] timesArrStr = this.normalizeStartTimeFormat(startTimes);
        ArrayList<Integer> timesArrInt = new ArrayList<Integer>();
        int minutesPerDay = 1440;
        int interval = -1;
        if (timesArrStr.length > 1) {
            for (int i = 0; i < timesArrStr.length; ++i) {
                int intervalCandidate;
                String[] currTime = timesArrStr[i].split(":");
                int currMins = Integer.parseInt(currTime[0]) * 60 + Integer.parseInt(currTime[1]);
                timesArrInt.add(i, currMins);
                if (i <= 0) continue;
                if (i != timesArrStr.length - 1) {
                    intervalCandidate = (Integer)timesArrInt.get(i) - (Integer)timesArrInt.get(i - 1);
                } else {
                    intervalCandidate = 1440 - (Integer)timesArrInt.get(i) + (Integer)timesArrInt.get(0);
                    if (intervalCandidate != (Integer)timesArrInt.get(1) - (Integer)timesArrInt.get(0)) {
                        intervalCandidate = -1;
                    }
                }
                if (interval == -1) {
                    interval = intervalCandidate;
                }
                if (intervalCandidate == interval) continue;
                interval = -1;
                break;
            }
            if (interval != -1) {
                this.jobAttr.put("CYCLIC_TYPE", "Interval");
                this.jobAttr.put("INTERVAL", Integer.toString(interval));
                this.jobAttr.put("TIMEFROM", timesArrStr[0].replace(":", ""));
                return;
            }
        }
        StringBuilder specTimes = new StringBuilder();
        if (timesArrStr.length > 1) {
            for (int i = 0; i < timesArrStr.length; ++i) {
                while (timesArrStr[i].indexOf(58) != timesArrStr[i].lastIndexOf(58)) {
                    timesArrStr[i] = timesArrStr[i].substring(0, timesArrStr[i].lastIndexOf(58));
                }
                specTimes.append(specTimes.isEmpty() ? "" : ",");
                while (timesArrStr[i].length() < 5) {
                    timesArrStr[i] = "0" + timesArrStr[i];
                }
                specTimes.append(timesArrStr[i].replaceAll(":", ""));
            }
            this.jobAttr.put("CYCLIC_TYPE", "SpecificTimes");
            this.jobAttr.put("CYCLIC_TIMES_SEQUENCE", specTimes.toString());
        } else {
            this.jobAttr.put("CYCLIC", "0");
            while (timesArrStr[0].indexOf(58) != timesArrStr[0].lastIndexOf(58)) {
                timesArrStr[0] = timesArrStr[0].substring(0, timesArrStr[0].lastIndexOf(58));
            }
            while (timesArrStr[0].length() < 5) {
                timesArrStr[0] = "0" + timesArrStr[0];
            }
            String window = this.sourceAttr.getAttr("run_window");
            if (window.matches(AutosysGlobals.timeWindowpattern.toString())) {
                String currStart = this.jobAttr.get("TIMEFROM");
                String currEnd = this.jobAttr.get("TIMETO");
                int startInt = Integer.parseInt(currStart);
                int endInt = Integer.parseInt(currEnd);
                int newTime = Integer.parseInt(timesArrStr[0].replace(":", ""));
                if (newTime > endInt) {
                    Reporter.addMessage(this.messages, (String)"INF0010", (String)this.jobName, (String[])new String[]{"CA_AUTOSYS", "run_window", String.format("%02d:%02d", endInt / 100, endInt % 100), "start_times", String.format("%02d:%02d", newTime / 100, newTime % 100), "TIMETO", String.format("%02d:%02d", endInt / 100, endInt % 100)});
                } else if (newTime < startInt) {
                    Reporter.addMessage(this.messages, (String)"INF0010", (String)this.jobName, (String[])new String[]{"CA_AUTOSYS", "run_window", String.format("%02d:%02d", startInt / 100, startInt % 100), "start_times", String.format("%02d:%02d", newTime / 100, newTime % 100), "TIMEFROM", String.format("%02d:%02d", startInt / 100, startInt % 100)});
                } else {
                    Reporter.addMessage(this.messages, (String)"INF0010", (String)this.jobName, (String[])new String[]{"CA_AUTOSYS", "run_window", String.format("%02d:%02d", startInt / 100, startInt % 100), "start_times", String.format("%02d:%02d", newTime / 100, newTime % 100), "TIMEFROM", String.format("%02d:%02d", newTime / 100, newTime % 100)});
                    this.jobAttr.put("TIMEFROM", timesArrStr[0].replace(":", ""));
                }
            } else {
                this.jobAttr.put("TIMEFROM", timesArrStr[0].replace(":", ""));
            }
        }
    }

    @NotNull
    private String[] normalizeStartTimeFormat(String startTimes) {
        Pair<Boolean, List<String>> fixedStartTimes = this.replaceUnsupportedTimeFormat(startTimes.split(",+"));
        if (((Boolean)fixedStartTimes.getKey()).booleanValue()) {
            Reporter.addMessage(this.messages, (String)"WRN4066", (String)this.jobName, (String[])new String[]{this.jobName, startTimes, String.join((CharSequence)",", (Iterable)fixedStartTimes.getValue())});
        }
        return (String[])((List)fixedStartTimes.getValue()).toArray(String[]::new);
    }

    private String fixInvalidTimeFormat(String startTime) {
        String startTimeWithInvalidSuffix = StartTimesHandler.removeInvalidSuffix(startTime);
        String startTimeWithInvalidPrefix = this.removeInvalidPrefixFrom(startTimeWithInvalidSuffix);
        String startTimeWithoutSeconds = StartTimesHandler.removeSecondsFrom(startTimeWithInvalidPrefix);
        String startTimeWithoutInvalidCharacters = this.removeInvalidCharactersFrom(startTimeWithoutSeconds);
        String[] hhmm = startTimeWithoutInvalidCharacters.split(":");
        int hh = Integer.parseInt(hhmm[0]);
        int mm = Integer.parseInt(hhmm[1]);
        return String.format("%02d:%02d", hh, mm);
    }

    private String removeInvalidCharactersFrom(String startTime) {
        return startTime.replaceAll("[^:\\d]", "");
    }

    private String removeInvalidPrefixFrom(String startTime) {
        return startTime.chars().mapToObj(ch -> Character.toString((char)ch)).dropWhile(c -> !c.matches("\\d")).map(Object::toString).collect(Collectors.joining());
    }

    @NotNull
    private static String removeSecondsFrom(String time) {
        while (time.indexOf(58) != time.lastIndexOf(58)) {
            time = time.trim().substring(0, time.lastIndexOf(58));
        }
        return time;
    }

    private Pair<Boolean, List<String>> replaceUnsupportedTimeFormat(String[] startTimes) {
        ArrayList<String> result = new ArrayList<String>();
        boolean isChanged = false;
        for (String startTime : startTimes) {
            if (startTime.matches(VALID_TIME_FORMAT)) {
                result.add(startTime);
                continue;
            }
            result.add(this.fixInvalidTimeFormat(startTime));
            isChanged = true;
        }
        return new Pair((Object)isChanged, result);
    }

    @NotNull
    private static String removeInvalidSuffix(String originalStartTime) {
        return originalStartTime.replaceAll("(\\d+:\\d+)[^:]*", "$1");
    }
}

