/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.handlers;

import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.util.ArrayList;
import java.util.HashMap;

public class AutosysPsftConvertorHandler {
    private static AutosysPsftConvertorHandler m_instance = null;

    private AutosysPsftConvertorHandler() {
    }

    public static AutosysPsftConvertorHandler instance() {
        if (m_instance == null) {
            m_instance = new AutosysPsftConvertorHandler();
        }
        return m_instance;
    }

    public void convertPsftJob(String command, HashMap<String, String> jobAttr, ArrayList<String> optionalAttr, HashMap<String, String> autoedits, RulesDataSet m_rules, ArrayList<String> messages) {
        if (!command.matches("\\s*auto_ps7.*")) {
            return;
        }
        autoedits.putAll(this.getPsftAutoedits(command, jobAttr, messages));
        optionalAttr.addAll(AutosysPsftConvertorHandler.getOptionaPsftPAttributes());
        jobAttr.putAll(AutosysPsftConvertorHandler.getJobPsftAttributes(jobAttr, m_rules));
        Reporter.addMessage(messages, (String)"INF4012", (String)jobAttr.get("JOBNAME"), (String[])new String[]{jobAttr.get("JOBNAME")});
        HashMap<String, String> action = new HashMap<String, String>();
        action.put("ACTENTTYPE", "PSFTACC");
        action.put("JOBID", jobAttr.get("JOBNAME"));
        action.put("ACTENTNAME", autoedits.get("%%PS8-CON_PROFILE"));
        action.put("ACTSTATUS", "0");
        Reporter.addAction(action);
    }

    private HashMap<String, String> getPsftAutoedits(String command, HashMap<String, String> jobAttr, ArrayList<String> messages) {
        HashMap<String, String> psftAutoedits = new HashMap<String, String>();
        String processType = "COBOL SQL";
        String processName = "TODO ";
        String OutputType = "Web";
        String emailSubject = "";
        String emailText = "";
        String emailAttachLog = "";
        String outDestWeb = "";
        String outDest = "";
        String OutputFormat2 = "DEFAULT";
        String processScheduler = "";
        String psInstance = "";
        String runControlId = "";
        String task = "";
        String oprId = "";
        int parameterIndex = 0;
        String[] commandArr = command.split(" ");
        for (int i = 1; i < commandArr.length; ++i) {
            StringBuilder value;
            StringBuilder directory;
            if (commandArr[i].equals("-j")) {
                if (i == commandArr.length) break;
                processType = this.getPsftProcessType(commandArr[++i]);
                continue;
            }
            if (commandArr[i].startsWith("-j")) {
                processType = this.getPsftProcessType(commandArr[i].substring(2));
                continue;
            }
            if (commandArr[i].equals("-o")) {
                if (i == commandArr.length) break;
                OutputType = this.getPsftOutputType(commandArr[++i]);
                continue;
            }
            if (commandArr[i].startsWith("-o")) {
                OutputType = this.getPsftOutputType(commandArr[i].substring(2));
                continue;
            }
            if (commandArr[i].equals("-b")) {
                StringBuilder subject = new StringBuilder();
                i = this.getCommandLineTextValue(commandArr, i + 1, subject);
                emailSubject = subject.toString();
                continue;
            }
            if (commandArr[i].equals("-g")) {
                StringBuilder text = new StringBuilder();
                i = this.getCommandLineTextValue(commandArr, i + 1, text);
                emailText = text.toString();
                continue;
            }
            if (commandArr[i].equals("-e")) {
                String opt;
                if (i == commandArr.length) break;
                if (!(opt = commandArr[++i]).equals("1") && !opt.toUpperCase().startsWith("I")) continue;
                emailAttachLog = "YES";
                continue;
            }
            if (commandArr[i].equals("-c")) {
                StringBuilder dest = new StringBuilder();
                i = this.getCommandLineTextValue(commandArr, i + 1, dest);
                outDestWeb = dest.toString();
                continue;
            }
            if (commandArr[i].equals("-F")) {
                if (i == commandArr.length) break;
                OutputFormat2 = this.getPsftOutputFormat(commandArr[++i]);
                continue;
            }
            if (commandArr[i].startsWith("-F")) {
                OutputFormat2 = this.getPsftOutputFormat(commandArr[i].substring(2));
                continue;
            }
            if (commandArr[i].equals("-f")) {
                directory = new StringBuilder();
                i = this.getCommandLineTextValue(commandArr, i + 1, directory);
                outDest = directory.toString();
                continue;
            }
            if (commandArr[i].equals("-d")) {
                directory = new StringBuilder();
                i = this.getCommandLineTextValue(commandArr, i + 1, directory);
                continue;
            }
            if (commandArr[i].equals("-t")) {
                value = new StringBuilder();
                i = this.getCommandLineTextValue(commandArr, i + 1, value);
                continue;
            }
            if (commandArr[i].equals("-P")) {
                if (i != commandArr.length) continue;
                break;
            }
            if (commandArr[i].equals("-H")) {
                if (i != commandArr.length) continue;
                break;
            }
            if (commandArr[i].equals("-L") || commandArr[i].equals("-D")) continue;
            if (commandArr[i].equals("-p")) {
                value = new StringBuilder();
                i = this.getCommandLineTextValue(commandArr, i + 1, value);
                continue;
            }
            if (commandArr[i].equals("-Z")) {
                if (i == commandArr.length) break;
                processScheduler = commandArr[++i];
                continue;
            }
            if (commandArr[i].startsWith("-")) continue;
            if (parameterIndex == 0) {
                psInstance = commandArr[i];
            } else if (parameterIndex == 1) {
                runControlId = commandArr[i];
            } else if (parameterIndex == 2) {
                task = commandArr[i];
            } else if (parameterIndex == 3) {
                oprId = commandArr[i];
            }
            ++parameterIndex;
        }
        psftAutoedits.put("%%PS8-PRCSTYPE", processType);
        psftAutoedits.put("%%PS8-PROCESSES-J1-P1-PROCESSTYPE", processType);
        processName = task;
        if (processType.equalsIgnoreCase("PSJob")) {
            psftAutoedits.put("%%PS8-JOBNAME", processName);
        } else {
            psftAutoedits.put("%%PS8-PRCSNAME", processName);
        }
        psftAutoedits.put("%%PS8-PROCESSES-J1-P1-PROCESSNAME", processName);
        if (processScheduler.isEmpty()) {
            psftAutoedits.put("%%PS8-CON_PROFILE", psInstance);
        } else {
            psftAutoedits.put("%%PS8-CON_PROFILE", psInstance + "." + processScheduler);
        }
        psftAutoedits.put("%%PS8-USERID", oprId);
        if (!OutputType.isEmpty()) {
            psftAutoedits.put("%%PS8-OUTDESTTYPE", OutputType);
        }
        if (!OutputFormat2.isEmpty()) {
            psftAutoedits.put("%%PS8-OUTDESTFORMAT", OutputFormat2);
        }
        if (!emailSubject.isEmpty()) {
            psftAutoedits.put("%%PS8-EMAIL_SUBJECT", emailSubject);
        }
        if (!emailText.isEmpty()) {
            psftAutoedits.put("%%PS8-EMAIL_TEXT", emailText);
        }
        if (!emailAttachLog.isEmpty()) {
            psftAutoedits.put("%%PS8-EMAIL_ATTACH_LOG", emailAttachLog);
        }
        if (!outDestWeb.isEmpty()) {
            psftAutoedits.put("%%PS8-OUTDEST", outDestWeb);
        }
        if (!outDest.isEmpty()) {
            psftAutoedits.put("%%PS8-OUTDEST", outDest);
        }
        if (!runControlId.isEmpty()) {
            psftAutoedits.put("%%PS8-RUNCONTROLID", runControlId);
        }
        return psftAutoedits;
    }

    private String getPsftProcessType(String taskType) {
        if (taskType.equalsIgnoreCase("sr")) {
            return "SQR Report";
        }
        if (taskType.equalsIgnoreCase("su")) {
            return "SQR Report for Upgrade Compare";
        }
        if (taskType.equalsIgnoreCase("sp")) {
            return "SQR Process";
        }
        if (taskType.equalsIgnoreCase("ae")) {
            return "Application Engine";
        }
        if (taskType.equalsIgnoreCase("cr")) {
            return "Crystal";
        }
        if (taskType.equalsIgnoreCase("rb")) {
            return "nVision-ReportBook";
        }
        if (taskType.equalsIgnoreCase("da")) {
            return "Database Agent";
        }
        if (taskType.equalsIgnoreCase("jb")) {
            return "PSJob";
        }
        if (taskType.equalsIgnoreCase("pr")) {
            return "Clean up agent. (N/A)";
        }
        return "Unknown Task type " + taskType;
    }

    private String getPsftOutputType(String type) {
        if (type.equalsIgnoreCase("F") || type.equalsIgnoreCase("2")) {
            return "File";
        }
        if (type.equalsIgnoreCase("P") || type.equalsIgnoreCase("3")) {
            return "Printer";
        }
        if (type.equalsIgnoreCase("E") || type.equalsIgnoreCase("5")) {
            return "Email";
        }
        if (type.equalsIgnoreCase("W") || type.equalsIgnoreCase("6")) {
            return "Web";
        }
        return "Unknown Output type " + type;
    }

    private String getPsftOutputFormat(String format) {
        if (format.equalsIgnoreCase("Any") || format.equals("0")) {
            return "Any";
        }
        if (format.equalsIgnoreCase("None") || format.equals("1")) {
            return "";
        }
        if (format.equals("2")) {
            return "PDF";
        }
        if (format.equals("3")) {
            return "CSV";
        }
        if (format.equals("4")) {
            return "HP";
        }
        if (format.equals("5")) {
            return "HTM";
        }
        if (format.equals("6")) {
            return "LP";
        }
        if (format.equals("7")) {
            return "WKS";
        }
        if (format.equals("8")) {
            return "XLS";
        }
        if (format.equals("9")) {
            return "DOC";
        }
        if (format.equals("10")) {
            return "PS";
        }
        if (format.equals("11")) {
            return "RPT";
        }
        if (format.equals("12")) {
            return "RTF";
        }
        if (format.equals("13")) {
            return "SPF";
        }
        if (format.equals("14")) {
            return "TXT";
        }
        if (format.equals("15")) {
            return "OTHER";
        }
        if (format.equals("16")) {
            return "DEFAULT";
        }
        return format.toUpperCase();
    }

    private int getCommandLineTextValue(String[] commandArray, int fromIndex, StringBuilder text) {
        int retIndex = fromIndex;
        for (retIndex = fromIndex; retIndex < commandArray.length; ++retIndex) {
            if (retIndex == fromIndex) {
                if (!commandArray[retIndex].startsWith("\"")) {
                    text.append(commandArray[retIndex]);
                    break;
                }
                text.append(commandArray[retIndex].substring(1));
            } else {
                text.append(" ");
                text.append(commandArray[retIndex]);
            }
            if (commandArray[retIndex].endsWith("\"")) break;
        }
        if (text.toString().endsWith("\"")) {
            text.deleteCharAt(text.length() - 1);
        }
        return retIndex;
    }

    private static HashMap<String, String> getJobPsftAttributes(HashMap<String, String> jobAttr, RulesDataSet m_rules) {
        String memlib = "Not in use for PeopleSoft jobs";
        String memname = jobAttr.get("JOBNAME");
        HashMap<String, String> sapAttr = new HashMap<String, String>();
        sapAttr.put("MEMLIB", memlib);
        sapAttr.put("MEMNAME", memname);
        sapAttr.put("APPL_FORM", "PEOPLESOFT");
        sapAttr.put("APPL_TYPE", "PS8");
        sapAttr.put("APPL_VER", "9.0.0.000");
        sapAttr.put("CM_VER", "6.1.01");
        String TaskTypeValue = m_rules.getTaskTypeHandler().getTaskType();
        sapAttr.put("TASKTYPE", TaskTypeValue);
        return sapAttr;
    }

    private static ArrayList<String> getOptionaPsftPAttributes() {
        ArrayList<String> optionalAttr = new ArrayList<String>();
        optionalAttr.add("APPL_FORM");
        optionalAttr.add("APPL_TYPE");
        optionalAttr.add("APPL_VER");
        optionalAttr.add("CM_VER");
        return optionalAttr;
    }

    public boolean isPsftJob(String command) {
        return command.matches("\\s*auto_ps7.*");
    }
}

