/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.common.Reporter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HandleBuiltinAutoEdits {
    private Map<String, String> replacedAutoEdits = null;
    private final AutosysJob autosysJob;

    public HandleBuiltinAutoEdits(AutosysJob autosysJob) {
        this.autosysJob = autosysJob;
    }

    private Map<String, String> getReplacedAutoEdits() {
        if (this.replacedAutoEdits != null) {
            return this.replacedAutoEdits;
        }
        this.replacedAutoEdits = new LinkedHashMap<String, String>();
        this.addPairAutosysCtmVar("AUTORUN", "%%CNV_RUN_ID");
        this.addPairAutosysCtmVar("AUTO_JOB_NAME", "%%AUTO_JOB_NAME");
        this.addPairAutosysCtmVar("AUTOPID", null);
        this.addPairAutosysCtmVar("JOBID", null);
        return this.replacedAutoEdits;
    }

    private void addPairAutosysCtmVar(String autosysVar, String ctmVar) {
        this.replacedAutoEdits.put("$" + autosysVar, ctmVar);
        this.replacedAutoEdits.put("$${" + autosysVar + "}", ctmVar);
        this.replacedAutoEdits.put("${" + autosysVar + "}", ctmVar);
        this.replacedAutoEdits.put("$$(" + autosysVar + ")", ctmVar);
        this.replacedAutoEdits.put("$(" + autosysVar + ")", ctmVar);
        this.replacedAutoEdits.put("%" + autosysVar + "%", ctmVar);
    }

    public String handle(String origStr) {
        String str = origStr;
        for (Map.Entry<String, String> curAutoEdit : this.getReplacedAutoEdits().entrySet()) {
            String origValue = curAutoEdit.getKey();
            String newValue = curAutoEdit.getValue();
            if (!str.contains(origValue)) continue;
            if (newValue == null) {
                this.autosysJob.addMessage("WRN4010", this.autosysJob.getJobName(), origValue);
                continue;
            }
            boolean concat = origStr.lastIndexOf(origValue) + origValue.length() < origStr.length();
            str = str.replace(origValue, newValue + (concat ? "." : ""));
        }
        return HandleBuiltinAutoEdits.replaceGlobalVars(this.autosysJob, str);
    }

    public static String replaceGlobalVars(AutosysJob autosysJob, String str) {
        List<Pattern> globalVarPatterns = Arrays.asList(Pattern.compile("(.*)(\\$\\$\\{(.+?)\\})(.*)"), Pattern.compile("(.*)(\\$\\$\\((.+?)\\))(.*)"), Pattern.compile("(.*)(\\$\\$([^ \\t./]+))(.*)"));
        HashSet<String> newAutoEdits = new HashSet<String>();
        for (Pattern pattern : globalVarPatterns) {
            str = HandleBuiltinAutoEdits.varReplaceByPattern(autosysJob, str, newAutoEdits, pattern);
        }
        return str;
    }

    private static String varReplaceByPattern(AutosysJob autosysJob, String str, HashSet<String> newAutoEdits, Pattern globalVarPattern) {
        Matcher globalVarMatcher = globalVarPattern.matcher(str);
        while (globalVarMatcher.matches()) {
            String varName = globalVarMatcher.group(3);
            String suffix = globalVarMatcher.group(4);
            if (newAutoEdits.add(varName)) {
                Reporter.addGlobalAutoEditAction(autosysJob.getMessages(), (String)varName, (String)"", (String)autosysJob.getJobName());
            }
            boolean concat = suffix != null && !suffix.isEmpty() && !suffix.startsWith(" ");
            String replacement = "%%" + varName + (concat ? "." : "");
            str = str.replace(globalVarMatcher.group(2), replacement);
            globalVarMatcher = globalVarPattern.matcher(str);
        }
        return str;
    }
}

