/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.conditions.InConditionBuilder;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.DoCondition;
import com.bmc.ctmconvert.ondo.OnStatement;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class EndFolderAssistingJobCreator {
    private EndFolderAssistingJobCreator() {
    }

    public static AssistingJob createFolderEndedOkJob(SchedEntity job) {
        return EndFolderAssistingJobCreator.createFolderEndedJob(job, "folder_ended_ok");
    }

    public static AssistingJob createFolderEndedNotOkJob(SchedEntity job, List<Properties> jobOnStmts, String conditionName) {
        AssistingJob assistingJob = EndFolderAssistingJobCreator.createFolderEndedJob(job, "folder_ended_notok").addInCondition(((InConditionBuilder)new InConditionBuilder().setConditionName(conditionName)).build().getProperties()).setAttribute("TASKTYPE", "Command").setAttribute("APPL_TYPE", "OS").setAttribute("CMDLINE", "echo \"Folder ended with errors\"");
        OnStatement.OnJobEndedStatement onJobEndedStatement = new OnStatement.OnJobEndedStatement();
        onJobEndedStatement.addDo(Do.createDoNotOk());
        onJobEndedStatement.accept((on, doStatements) -> {
            Properties onDoStatement = new Properties();
            onDoStatement.putAll((Map<?, ?>)on);
            onDoStatement.putAll((Map<?, ?>)((Map)doStatements.getFirst()));
            assistingJob.addOnStmt(onDoStatement);
        });
        EndFolderAssistingJobCreator.linkAssistingJobWithSourceJob(jobOnStmts, conditionName);
        return assistingJob;
    }

    private static AssistingJob createFolderEndedJob(SchedEntity job, String jobName) {
        String parentFolder = job.type() == SchedEntity.TYPE.SUB_TABLE ? job.getTablePathForSons() : job.getTableName();
        return new AssistingJob(job).setAttribute("JOBNAME", jobName).setAttribute("PARENT_TABLE", parentFolder).setAttribute("END_FOLDER", "Y");
    }

    public static void linkAssistingJobWithSourceJob(List<Properties> jobOnStmts, String conditionName) {
        OnStatement.OnNotOkStatement onNotOK = OnStatement.createOnNotOkStatement();
        DoCondition doCondition = new DoCondition(conditionName, DoCondition.AddRemoveSign.ADD);
        onNotOK.addDo((Do)doCondition);
        onNotOK.accept((on, doStatements) -> {
            Properties onDoStatement = new Properties();
            onDoStatement.putAll((Map<?, ?>)on);
            onDoStatement.putAll((Map<?, ?>)((Map)doStatements.getFirst()));
            jobOnStmts.add(onDoStatement);
        });
    }
}

