/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysSchedulingSettingsConvertor;
import com.bmc.ctmconvert.autosys.ExtendedCalendarConvertor;
import com.bmc.ctmconvert.autosys.calendar.WorkdaysCalendarCreator;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CalendarsFile {
    private final DefCalFile defcal;
    private final BiConsumer<String, List<String>> addGeneralMessage;
    int lineNumber = 0;
    private String ctmName;
    private InputStream autoSysCalendarsInputStream;
    private UniqueValueGenerator uniqueValue;
    private Map<String, String> orig2UniqueMap;
    private ExtendedCalendarConvertor extendedCalendarConvertor;

    CalendarsFile(String ctmName, InputStream calendarsInputStream, DefCalFile defCalFile, ExtendedCalendarConvertor extendedCalendarConvertor, BiConsumer<String, List<String>> addGeneralMessage) {
        this.ctmName = ctmName;
        this.autoSysCalendarsInputStream = calendarsInputStream;
        this.defcal = defCalFile;
        this.uniqueValue = new UniqueValueGenerator();
        this.orig2UniqueMap = new LinkedHashMap<String, String>();
        this.extendedCalendarConvertor = extendedCalendarConvertor;
        this.addGeneralMessage = addGeneralMessage;
    }

    public CalendarsFile(String ctmName, InputStream calendarsInputStream, ExtendedCalendarConvertor extendedCalendarConvertor, BiConsumer<String, List<String>> addGeneralMessage) throws IOException {
        this(ctmName, calendarsInputStream, DefCalFile.createDefCalFile(), extendedCalendarConvertor, addGeneralMessage);
    }

    private void writeCal(CtmCalendar curCal) {
        if (curCal == null) {
            return;
        }
        this.defcal.write(curCal, false);
        this.defcal.write(curCal, true);
        this.createRBCFromRegularCalendar(curCal).ifPresent(arg_0 -> ((DefCalFile)this.defcal).writeRBC(arg_0));
    }

    private Optional<Properties> createRBCFromRegularCalendar(CtmCalendar curCal) {
        String nameOfRegular = this.getCalendarFinalName(curCal.getName());
        String uniqeName = this.getRBCCalName(this.getCalendarOriginalName(nameOfRegular));
        if (uniqeName.isBlank()) {
            return Optional.empty();
        }
        Properties rbc = new Properties();
        rbc.put("DATACENTER", curCal.getDcName());
        rbc.put("DAYSCAL", nameOfRegular);
        rbc.put("DAYS", "ALL");
        rbc.put("DAYS_AND_OR", "OR");
        rbc.put("MAXWAIT", "00");
        rbc.put("SHIFTNUM", "+00");
        rbc.put("NAME", uniqeName);
        rbc.setProperty("JAN", "1");
        rbc.setProperty("FEB", "1");
        rbc.setProperty("MAR", "1");
        rbc.setProperty("APR", "1");
        rbc.setProperty("MAY", "1");
        rbc.setProperty("JUN", "1");
        rbc.setProperty("JUL", "1");
        rbc.setProperty("AUG", "1");
        rbc.setProperty("SEP", "1");
        rbc.setProperty("OCT", "1");
        rbc.setProperty("NOV", "1");
        rbc.setProperty("DEC", "1");
        return Optional.ofNullable(rbc);
    }

    private String getCalendarOriginalName(String name) {
        Optional<Map.Entry> nameEntry = this.orig2UniqueMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(name)).findFirst();
        return nameEntry.map(Map.Entry::getKey).orElse("");
    }

    public List<String> convert() {
        ArrayList<String> retList = new ArrayList<String>();
        try {
            CtmCalendar curCal = null;
            this.lineNumber = 0;
            Iterator<String> sc = new Scanner(this.autoSysCalendarsInputStream);
            while (((Scanner)sc).hasNext()) {
                String line = ((Scanner)sc).nextLine().trim();
                ++this.lineNumber;
                if (this.skipThisLine(line)) continue;
                if (line.startsWith("calendar:") || line.startsWith("Calendar:")) {
                    this.writeCal(curCal);
                    String calName = this.getCalName(line);
                    curCal = new CtmCalendar(calName, this.ctmName);
                    retList.add(calName);
                    continue;
                }
                this.addDate(curCal, line);
            }
            ((Scanner)sc).close();
            retList.add(curCal.getName());
            this.writeCal(curCal);
        }
        catch (Exception e) {
            ConversionLogger.getLogger().info("Caught Exception for regular calendars. Falling through to extended");
        }
        String[] ctmCalendars = new String[]{"CONFCAL", "DAYSCAL", "WEEKSCAL"};
        for (String extName : this.extendedCalendarConvertor.getAllConvertedCalendars()) {
            this.extendedCalendarConvertor.getRbcs(extName, this.orig2UniqueMap.values()).forEach(reulBasedCalendar -> {
                String nameWithoutExcludePrefix = StringUtils.removeStart((String)reulBasedCalendar.getProperty("NAME"), (String)"!");
                String uniqueName = this.uniqueValue.getUniqueValue("RULE_BASED_CALENDAR", nameWithoutExcludePrefix, 19);
                reulBasedCalendar.setProperty("NAME", uniqueName);
                for (String ctmCal : ctmCalendars) {
                    if (!reulBasedCalendar.containsKey(ctmCal)) continue;
                    String oldName = reulBasedCalendar.getProperty(ctmCal);
                    String newName = this.getCalendarFinalName(oldName);
                    reulBasedCalendar.setProperty(ctmCal, newName);
                    retList.remove(oldName);
                    retList.add(newName);
                }
                this.defcal.writeRBC(reulBasedCalendar);
            });
        }
        CtmCalendar workdaysCalendar = new WorkdaysCalendarCreator().createWorkdaysCalendar(LocalDate.now(), this.ctmName);
        this.writeCal(workdaysCalendar);
        this.defcal.writeRBC(this.addDataCenterToRbc(AutosysSchedulingSettingsConvertor.getAllDaysRBC()));
        this.defcal.writeRBC(this.addDataCenterToRbc(AutosysSchedulingSettingsConvertor.getNoneRBC()));
        this.defcal.close();
        return retList;
    }

    @NotNull
    private Properties addDataCenterToRbc(Properties rbc) {
        rbc.setProperty("DATACENTER", this.ctmName);
        return rbc;
    }

    private boolean skipThisLine(String line) {
        if (line.isEmpty()) {
            return true;
        }
        return line.startsWith("---");
    }

    private void addDate(CtmCalendar cal, String line) {
        String[] vec = line.split(" ");
        String date = vec[0];
        if ((vec = date.split("/")).length != 3) {
            ConversionLogger.getLogger().severe(() -> String.format("Failed to parse date in line %d of file %s: [%s]", this.lineNumber, "AutosysCalendars.CAL", line));
            return;
        }
        int month = Integer.parseInt(vec[0]);
        int day = Integer.parseInt(vec[1]);
        int year = Integer.parseInt(vec[2]);
        cal.addDay(year, month, day);
    }

    private String getCalName(String line) {
        String[] vec = line.split(" ", 2);
        String name = vec[1].trim();
        String uniqueName = this.uniqueValue.getUniqueValue("CALENDAR_NAME", name, 30);
        uniqueName = FieldValidation.instance().validateAndReturnFixedValue("DAYSCAL", uniqueName);
        if (!uniqueName.equals(name)) {
            this.addGeneralMessage.accept("INF4015", List.of(name, uniqueName));
        }
        this.orig2UniqueMap.put(name, uniqueName);
        return uniqueName;
    }

    private String getRBCCalName(String oldName) {
        String RBCWithOriginalName = oldName;
        String RBCWithFinalName = this.getCalendarFinalName(oldName);
        String newCalendarName = this.uniqueValue.getUniqueValue("RULE_BASED_CALENDAR", RBCWithFinalName, 19);
        newCalendarName = FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", newCalendarName);
        if (!newCalendarName.equals(RBCWithFinalName)) {
            this.addGeneralMessage.accept("INF4015", List.of(RBCWithOriginalName, newCalendarName));
        }
        this.orig2UniqueMap.put(RBCWithOriginalName, newCalendarName);
        return newCalendarName;
    }

    public String getCalendarFinalName(String name) {
        if (this.orig2UniqueMap.containsKey(name)) {
            name = this.orig2UniqueMap.get(name);
        }
        return name;
    }
}

