/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.migration.steps;

import arrow.core.Either;
import com.bmc.ctmconvert.Action;
import com.bmc.ctmconvert.CtmQualificationMode;
import com.bmc.ctmconvert.ExtractMode;
import com.bmc.ctmconvert.MigrateMode;
import com.bmc.ctmconvert.QualificationMode;
import com.bmc.ctmconvert.configuration.HelixTimeZones;
import com.bmc.ctmconvert.configuration.OnPremTimeZones;
import com.bmc.ctmconvert.configuration.TimeZoneItem;
import com.bmc.ctmconvert.configuration.TimeZonesMigrator;
import com.bmc.ctmconvert.databaseCommon.DataBaseFailure;
import com.bmc.ctmconvert.json.Folders;
import com.bmc.ctmconvert.migration.MigrationAction;
import com.bmc.ctmconvert.migration.steps.MigrationData;
import com.bmc.ctmconvert.migration.steps.MigrationStep;
import com.bmc.ctmconvert.migration.steps.StepResult;
import com.bmc.ctmconvert.migration.steps.TimeZoneStepKt;
import com.bmc.ctmconvert.qualifyUtils.QualificationSummary;
import com.bmc.ctmconvert.qualifyUtils.SheetData;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\b\u0018\u0000 \u001f2\u00020\u0001:\u0007\u001f !\"#$%B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J0\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a0\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep;", "Lcom/bmc/ctmconvert/migration/steps/MigrationStep;", "timeZonesMigrator", "Lcom/bmc/ctmconvert/configuration/TimeZonesMigrator;", "<init>", "(Lcom/bmc/ctmconvert/configuration/TimeZonesMigrator;)V", "jobsWithTimeZone", "", "Lcom/bmc/ctmconvert/json/Folders$JobWithTimeZone;", "migrate", "", "Lcom/bmc/ctmconvert/migration/MigrationAction;", "migrationData", "Lcom/bmc/ctmconvert/migration/steps/MigrationData;", "getSheets", "Lcom/bmc/ctmconvert/qualifyUtils/SheetData;", "stepResults", "Lcom/bmc/ctmconvert/migration/steps/StepResult;", "allTimeZoneValuesWereSuccessfullyMapped", "", "getSheetHeaders", "", "action", "Lcom/bmc/ctmconvert/Action;", "statusOf", "timeZoneType", "Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$TimeZoneItemWrapper;", "timeZoneGetter", "Lkotlin/Function1;", "timeZoneMapping", "", "Companion", "TimeZoneItemWrapper", "TimeZoneItemWrapperImpl", "MissingInOnPremise", "MissingInHelix", "MissingTimeZoneMapping", "InvalidMapping", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nTimeZoneStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeZoneStep.kt\ncom/bmc/ctmconvert/migration/steps/TimeZoneStep\n+ 2 Either.kt\narrow/core/Either\n+ 3 Either.kt\narrow/core/EitherKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n858#2:198\n1223#3,4:199\n1557#4:203\n1628#4,3:204\n1734#4,3:207\n*S KotlinDebug\n*F\n+ 1 TimeZoneStep.kt\ncom/bmc/ctmconvert/migration/steps/TimeZoneStep\n*L\n54#1:198\n54#1:199,4\n70#1:203\n70#1:204,3\n96#1:207,3\n*E\n"})
public final class TimeZoneStep
implements MigrationStep {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TimeZonesMigrator timeZonesMigrator;
    @NotNull
    private final List<Folders.JobWithTimeZone> jobsWithTimeZone;
    @NotNull
    public static final String timezoneStepName = "Control-M on premise timezones were replaced with Control-M SaaS Time Zones";

    public TimeZoneStep(@NotNull TimeZonesMigrator timeZonesMigrator) {
        Intrinsics.checkNotNullParameter((Object)timeZonesMigrator, (String)"timeZonesMigrator");
        this.timeZonesMigrator = timeZonesMigrator;
        this.jobsWithTimeZone = new ArrayList();
    }

    public /* synthetic */ TimeZoneStep(TimeZonesMigrator timeZonesMigrator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            timeZonesMigrator = new TimeZonesMigrator(new HelixTimeZones(null, 1, null), new OnPremTimeZones(null, 1, null));
        }
        this(timeZonesMigrator);
    }

    @Override
    @NotNull
    public List<MigrationAction> migrate(@NotNull MigrationData migrationData) {
        Either<DataBaseFailure, List<Folders.JobWithTimeZone>> jobsWithTimeZoneFromDatabase;
        Map<String, String> map;
        Intrinsics.checkNotNullParameter((Object)migrationData, (String)"migrationData");
        if (((CharSequence)migrationData.getArguments().getTimeZoneMappingPath()).length() > 0) {
            Path path = migrationData.getFileSystem().getPath(migrationData.getArguments().getTimeZoneMappingPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
            map = this.timeZonesMigrator.readTimeZoneMappingFile(path);
        } else {
            map = MapsKt.emptyMap();
        }
        Map<String, String> timeZoneMapping = map;
        Either<DataBaseFailure, List<Folders.JobWithTimeZone>> this_$iv = jobsWithTimeZoneFromDatabase = migrationData.getData().getFolders().getFolder().migrateJobsWithTimeZone(migrationData.getEmDatabase(), migrationData.getCtmName(), this.timeZoneGetter(this.timeZonesMigrator, timeZoneMapping));
        boolean $i$f$map = false;
        Either<DataBaseFailure, List<Folders.JobWithTimeZone>> $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Either<DataBaseFailure, List<Folders.JobWithTimeZone>> either = $this$flatMap$iv$iv;
        if (either instanceof Either.Right) {
            Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            List it = (List)it$iv;
            boolean bl2 = false;
            Boolean bl3 = this.jobsWithTimeZone.addAll(it);
            Either cfr_ignored_0 = (Either)new Either.Right((Object)bl3);
        } else if (!(either instanceof Either.Left)) {
            throw new NoWhenBranchMatchedException();
        }
        Path path = migrationData.getFileSystem().getPath(migrationData.getArguments().getOutput-folder-path(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
        Path path4 = path3.resolve("TimeZoneMapping.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        PathsKt.writeText$default((Path)path4, (CharSequence)this.timeZonesMigrator.createTimeZoneMapping(this.jobsWithTimeZone), null, (OpenOption[])new OpenOption[0], (int)2, null);
        return CollectionsKt.listOf((Object)new MigrationAction(timezoneStepName, this.jobsWithTimeZone.size()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SheetData> getSheets(@NotNull MigrationData migrationData) {
        List list;
        Intrinsics.checkNotNullParameter((Object)migrationData, (String)"migrationData");
        boolean bl = this.jobsWithTimeZone.isEmpty();
        if (!bl) {
            Collection<List> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object[] objectArray = new SheetData[2];
            List list2 = this.getSheetHeaders(migrationData.getArguments().getAction());
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Object[] objectArray2 = (Object[])this.jobsWithTimeZone;
            List list3 = list2;
            String string = "Folders and jobs with Time Zone";
            int n = 0;
            Object[] objectArray3 = objectArray;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Folders.JobWithTimeZone jobWithTimeZone = (Folders.JobWithTimeZone)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                Object[] objectArray4 = new String[]{it.getParentFolder(), it.getJobName(), it.getOriginalTimeZone() + it.getTimeZoneType().getOnPremTimeZoneWithOffset(), it.getNewTimeZone(), this.statusOf(it.getTimeZoneType())};
                collection.add(CollectionsKt.listOf((Object[])objectArray4));
            }
            Collection<List> collection2 = collection = (List)destination$iv$iv;
            List list4 = list3;
            String string2 = string;
            objectArray3[n] = new SheetData(string2, list4, (List)collection2);
            objectArray2 = new String[]{"Control-M SaaS Time Zone ID", "Name", "Offset", "DST Rule"};
            objectArray[1] = new SheetData("Control-M SaaS Time Zones", CollectionsKt.listOf((Object[])objectArray2), new HelixTimeZones(null, 1, null).getAllTimeZonesDetails());
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (bl) {
            list = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @Override
    @Nullable
    public StepResult stepResults() {
        return this.allTimeZoneValuesWereSuccessfullyMapped() ? null : new StepResult(false, "Deploy to Control-M SaaS is aborted.\nFolders or Jobs with time zone definitions were found but mapping to Control-M SaaS Time Zones was not provided.\nSee instructions in the Time Zone qualification in the Qualification Summary sheet of the report.");
    }

    private final boolean allTimeZoneValuesWereSuccessfullyMapped() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.jobsWithTimeZone;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Folders.JobWithTimeZone it = (Folders.JobWithTimeZone)element$iv;
                    boolean bl2 = false;
                    if (it.getTimeZoneType() instanceof TimeZoneItemWrapperImpl) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final List<String> getSheetHeaders(Action action) {
        return (List)action.builder().whenMode(QualificationMode.INSTANCE.or(ExtractMode.INSTANCE).or(CtmQualificationMode.INSTANCE), TimeZoneStep::getSheetHeaders$lambda$3).whenMode(MigrateMode.INSTANCE, TimeZoneStep::getSheetHeaders$lambda$4).buildResultOrNull();
    }

    private final String statusOf(TimeZoneItemWrapper timeZoneType) {
        Object object;
        TimeZoneItemWrapper timeZoneItemWrapper = timeZoneType;
        if (timeZoneItemWrapper instanceof MissingInHelix) {
            object = ((MissingInHelix)timeZoneType).getTimeZoneValue() + " is not a valid Control-M SaaS Time Zone";
        } else if (timeZoneItemWrapper instanceof MissingInOnPremise) {
            object = ((MissingInOnPremise)timeZoneType).getTimeZoneJsonValue() + " is an unknown Control-M On Premise time zone (see --onPremiseTimeZoneFilePath parameter in inputParameters/parameters.txt)";
        } else if (timeZoneItemWrapper instanceof MissingTimeZoneMapping) {
            object = "Missing mapping for On Premise time zone " + ((MissingTimeZoneMapping)timeZoneType).getOriginalTimeZone();
        } else if (timeZoneItemWrapper instanceof InvalidMapping) {
            object = "Invalid mapping from On Premise time zone " + ((InvalidMapping)timeZoneType).getOriginalTimeZone() + " to Control-M SaaS Time Zone '" + ((InvalidMapping)timeZoneType).getHelixTimeZoneValue() + "'";
        } else if (timeZoneItemWrapper instanceof TimeZoneItemWrapperImpl) {
            object = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final Function1<String, TimeZoneItemWrapper> timeZoneGetter(TimeZonesMigrator timeZonesMigrator, Map<String, String> timeZoneMapping) {
        return arg_0 -> TimeZoneStep.timeZoneGetter$lambda$5(timeZonesMigrator, timeZoneMapping, arg_0);
    }

    @Override
    @NotNull
    public List<QualificationSummary> getSummary() {
        return MigrationStep.DefaultImpls.getSummary(this);
    }

    private static final List getSheetHeaders$lambda$3() {
        return TimeZoneStepKt.access$getQualificationTimeZonesSheetHeaders$p();
    }

    private static final List getSheetHeaders$lambda$4() {
        return TimeZoneStepKt.access$getMigrationTimeZonesSheetHeaders$p();
    }

    private static final TimeZoneItemWrapper timeZoneGetter$lambda$5(TimeZonesMigrator $timeZonesMigrator, Map $timeZoneMapping, String originalTimeZone) {
        TimeZoneItemWrapper timeZoneItemWrapper;
        Intrinsics.checkNotNullParameter((Object)originalTimeZone, (String)"originalTimeZone");
        TimeZoneItem onPremTzItem = $timeZonesMigrator.getOnPremTimeZones().getBy(originalTimeZone);
        TimeZoneItem helixTz = (TimeZoneItem)CollectionsKt.firstOrNull($timeZonesMigrator.getHelixTimeZones().getByCtmCode(originalTimeZone));
        String helixTimeZoneValue = (String)$timeZoneMapping.get(originalTimeZone);
        if (helixTimeZoneValue == null) {
            timeZoneItemWrapper = onPremTzItem == null ? (TimeZoneItemWrapper)new MissingInOnPremise(originalTimeZone) : (helixTz == null ? (TimeZoneItemWrapper)new MissingInHelix(originalTimeZone, onPremTzItem) : (TimeZoneItemWrapper)new MissingTimeZoneMapping(originalTimeZone, helixTz, onPremTzItem));
        } else {
            boolean bl = $timeZonesMigrator.getHelixTimeZones().isSupportedHelixTimeZoneValue(helixTimeZoneValue);
            if (bl) {
                timeZoneItemWrapper = new TimeZoneItemWrapperImpl(helixTimeZoneValue, onPremTzItem);
            } else if (!bl) {
                timeZoneItemWrapper = helixTz == null ? (TimeZoneItemWrapper)new MissingInHelix(originalTimeZone, onPremTzItem) : (TimeZoneItemWrapper)new InvalidMapping(originalTimeZone, helixTz, helixTimeZoneValue, onPremTzItem);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return timeZoneItemWrapper;
    }

    public TimeZoneStep() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$Companion;", "", "<init>", "()V", "timezoneStepName", "", "migrateToSaaS"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J3\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0016\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$InvalidMapping;", "Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$TimeZoneItemWrapper;", "originalTimeZone", "", "helixTimeZoneItem", "Lcom/bmc/ctmconvert/configuration/TimeZoneItem;", "helixTimeZoneValue", "onPremTzItem", "<init>", "(Ljava/lang/String;Lcom/bmc/ctmconvert/configuration/TimeZoneItem;Ljava/lang/String;Lcom/bmc/ctmconvert/configuration/TimeZoneItem;)V", "getOriginalTimeZone", "()Ljava/lang/String;", "getHelixTimeZoneItem", "()Lcom/bmc/ctmconvert/configuration/TimeZoneItem;", "getHelixTimeZoneValue", "getOnPremTzItem", "timeZoneValue", "getTimeZoneValue", "timeZoneJsonValue", "getTimeZoneJsonValue", "timeZoneMappingValue", "getTimeZoneMappingValue", "onPremTimeZoneWithOffset", "getOnPremTimeZoneWithOffset", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "migrateToSaaS"})
    public static final class InvalidMapping
    implements TimeZoneItemWrapper {
        @NotNull
        private final String originalTimeZone;
        @NotNull
        private final TimeZoneItem helixTimeZoneItem;
        @NotNull
        private final String helixTimeZoneValue;
        @Nullable
        private final TimeZoneItem onPremTzItem;
        @NotNull
        private final String timeZoneValue;
        @NotNull
        private final String timeZoneJsonValue;
        @NotNull
        private final String timeZoneMappingValue;
        @NotNull
        private final String onPremTimeZoneWithOffset;

        public InvalidMapping(@NotNull String originalTimeZone, @NotNull TimeZoneItem helixTimeZoneItem, @NotNull String helixTimeZoneValue, @Nullable TimeZoneItem onPremTzItem) {
            Intrinsics.checkNotNullParameter((Object)originalTimeZone, (String)"originalTimeZone");
            Intrinsics.checkNotNullParameter((Object)helixTimeZoneItem, (String)"helixTimeZoneItem");
            Intrinsics.checkNotNullParameter((Object)helixTimeZoneValue, (String)"helixTimeZoneValue");
            this.originalTimeZone = originalTimeZone;
            this.helixTimeZoneItem = helixTimeZoneItem;
            this.helixTimeZoneValue = helixTimeZoneValue;
            this.onPremTzItem = onPremTzItem;
            this.timeZoneValue = "N/A";
            this.timeZoneJsonValue = this.originalTimeZone;
            this.timeZoneMappingValue = this.helixTimeZoneItem.getId();
            this.onPremTimeZoneWithOffset = this.formatOnPremTimeZone(this.onPremTzItem);
        }

        @NotNull
        public final String getOriginalTimeZone() {
            return this.originalTimeZone;
        }

        @NotNull
        public final TimeZoneItem getHelixTimeZoneItem() {
            return this.helixTimeZoneItem;
        }

        @NotNull
        public final String getHelixTimeZoneValue() {
            return this.helixTimeZoneValue;
        }

        @Nullable
        public final TimeZoneItem getOnPremTzItem() {
            return this.onPremTzItem;
        }

        @Override
        @NotNull
        public String getTimeZoneValue() {
            return this.timeZoneValue;
        }

        @Override
        @NotNull
        public String getTimeZoneJsonValue() {
            return this.timeZoneJsonValue;
        }

        @Override
        @NotNull
        public String getTimeZoneMappingValue() {
            return this.timeZoneMappingValue;
        }

        @Override
        @NotNull
        public String getOnPremTimeZoneWithOffset() {
            return this.onPremTimeZoneWithOffset;
        }

        @NotNull
        public final String component1() {
            return this.originalTimeZone;
        }

        @NotNull
        public final TimeZoneItem component2() {
            return this.helixTimeZoneItem;
        }

        @NotNull
        public final String component3() {
            return this.helixTimeZoneValue;
        }

        @Nullable
        public final TimeZoneItem component4() {
            return this.onPremTzItem;
        }

        @NotNull
        public final InvalidMapping copy(@NotNull String originalTimeZone, @NotNull TimeZoneItem helixTimeZoneItem, @NotNull String helixTimeZoneValue, @Nullable TimeZoneItem onPremTzItem) {
            Intrinsics.checkNotNullParameter((Object)originalTimeZone, (String)"originalTimeZone");
            Intrinsics.checkNotNullParameter((Object)helixTimeZoneItem, (String)"helixTimeZoneItem");
            Intrinsics.checkNotNullParameter((Object)helixTimeZoneValue, (String)"helixTimeZoneValue");
            return new InvalidMapping(originalTimeZone, helixTimeZoneItem, helixTimeZoneValue, onPremTzItem);
        }

        public static /* synthetic */ InvalidMapping copy$default(InvalidMapping invalidMapping, String string, TimeZoneItem timeZoneItem, String string2, TimeZoneItem timeZoneItem2, int n, Object object) {
            if ((n & 1) != 0) {
                string = invalidMapping.originalTimeZone;
            }
            if ((n & 2) != 0) {
                timeZoneItem = invalidMapping.helixTimeZoneItem;
            }
            if ((n & 4) != 0) {
                string2 = invalidMapping.helixTimeZoneValue;
            }
            if ((n & 8) != 0) {
                timeZoneItem2 = invalidMapping.onPremTzItem;
            }
            return invalidMapping.copy(string, timeZoneItem, string2, timeZoneItem2);
        }

        @NotNull
        public String toString() {
            return "InvalidMapping(originalTimeZone=" + this.originalTimeZone + ", helixTimeZoneItem=" + this.helixTimeZoneItem + ", helixTimeZoneValue=" + this.helixTimeZoneValue + ", onPremTzItem=" + this.onPremTzItem + ")";
        }

        public int hashCode() {
            int result = this.originalTimeZone.hashCode();
            result = result * 31 + this.helixTimeZoneItem.hashCode();
            result = result * 31 + this.helixTimeZoneValue.hashCode();
            result = result * 31 + (this.onPremTzItem == null ? 0 : this.onPremTzItem.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InvalidMapping)) {
                return false;
            }
            InvalidMapping invalidMapping = (InvalidMapping)other;
            if (!Intrinsics.areEqual((Object)this.originalTimeZone, (Object)invalidMapping.originalTimeZone)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.helixTimeZoneItem, (Object)invalidMapping.helixTimeZoneItem)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.helixTimeZoneValue, (Object)invalidMapping.helixTimeZoneValue)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.onPremTzItem, (Object)invalidMapping.onPremTzItem);
        }

        @Override
        @NotNull
        public String formatOnPremTimeZone(@Nullable TimeZoneItem onPremTzItem) {
            return TimeZoneItemWrapper.DefaultImpls.formatOnPremTimeZone(this, onPremTzItem);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0010\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0014\u0010\u0012\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$MissingInHelix;", "Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$TimeZoneItemWrapper;", "originalTimeZone", "", "onPremTzItem", "Lcom/bmc/ctmconvert/configuration/TimeZoneItem;", "<init>", "(Ljava/lang/String;Lcom/bmc/ctmconvert/configuration/TimeZoneItem;)V", "getOriginalTimeZone", "()Ljava/lang/String;", "getOnPremTzItem", "()Lcom/bmc/ctmconvert/configuration/TimeZoneItem;", "timeZoneValue", "getTimeZoneValue", "timeZoneJsonValue", "getTimeZoneJsonValue", "timeZoneMappingValue", "getTimeZoneMappingValue", "onPremTimeZoneWithOffset", "getOnPremTimeZoneWithOffset", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "migrateToSaaS"})
    public static final class MissingInHelix
    implements TimeZoneItemWrapper {
        @NotNull
        private final String originalTimeZone;
        @Nullable
        private final TimeZoneItem onPremTzItem;
        @NotNull
        private final String timeZoneValue;
        @NotNull
        private final String timeZoneJsonValue;
        @NotNull
        private final String timeZoneMappingValue;
        @NotNull
        private final String onPremTimeZoneWithOffset;

        public MissingInHelix(@NotNull String originalTimeZone, @Nullable TimeZoneItem onPremTzItem) {
            Intrinsics.checkNotNullParameter((Object)originalTimeZone, (String)"originalTimeZone");
            this.originalTimeZone = originalTimeZone;
            this.onPremTzItem = onPremTzItem;
            this.timeZoneValue = this.originalTimeZone;
            this.timeZoneJsonValue = this.getTimeZoneValue();
            this.timeZoneMappingValue = "Unknown-Timezone";
            this.onPremTimeZoneWithOffset = this.formatOnPremTimeZone(this.onPremTzItem);
        }

        @NotNull
        public final String getOriginalTimeZone() {
            return this.originalTimeZone;
        }

        @Nullable
        public final TimeZoneItem getOnPremTzItem() {
            return this.onPremTzItem;
        }

        @Override
        @NotNull
        public String getTimeZoneValue() {
            return this.timeZoneValue;
        }

        @Override
        @NotNull
        public String getTimeZoneJsonValue() {
            return this.timeZoneJsonValue;
        }

        @Override
        @NotNull
        public String getTimeZoneMappingValue() {
            return this.timeZoneMappingValue;
        }

        @Override
        @NotNull
        public String getOnPremTimeZoneWithOffset() {
            return this.onPremTimeZoneWithOffset;
        }

        @NotNull
        public final String component1() {
            return this.originalTimeZone;
        }

        @Nullable
        public final TimeZoneItem component2() {
            return this.onPremTzItem;
        }

        @NotNull
        public final MissingInHelix copy(@NotNull String originalTimeZone, @Nullable TimeZoneItem onPremTzItem) {
            Intrinsics.checkNotNullParameter((Object)originalTimeZone, (String)"originalTimeZone");
            return new MissingInHelix(originalTimeZone, onPremTzItem);
        }

        public static /* synthetic */ MissingInHelix copy$default(MissingInHelix missingInHelix, String string, TimeZoneItem timeZoneItem, int n, Object object) {
            if ((n & 1) != 0) {
                string = missingInHelix.originalTimeZone;
            }
            if ((n & 2) != 0) {
                timeZoneItem = missingInHelix.onPremTzItem;
            }
            return missingInHelix.copy(string, timeZoneItem);
        }

        @NotNull
        public String toString() {
            return "MissingInHelix(originalTimeZone=" + this.originalTimeZone + ", onPremTzItem=" + this.onPremTzItem + ")";
        }

        public int hashCode() {
            int result = this.originalTimeZone.hashCode();
            result = result * 31 + (this.onPremTzItem == null ? 0 : this.onPremTzItem.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MissingInHelix)) {
                return false;
            }
            MissingInHelix missingInHelix = (MissingInHelix)other;
            if (!Intrinsics.areEqual((Object)this.originalTimeZone, (Object)missingInHelix.originalTimeZone)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.onPremTzItem, (Object)missingInHelix.onPremTzItem);
        }

        @Override
        @NotNull
        public String formatOnPremTimeZone(@Nullable TimeZoneItem onPremTzItem) {
            return TimeZoneItemWrapper.DefaultImpls.formatOnPremTimeZone(this, onPremTzItem);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u000f\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$MissingInOnPremise;", "Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$TimeZoneItemWrapper;", "originalTimeZone", "", "<init>", "(Ljava/lang/String;)V", "timeZoneValue", "getTimeZoneValue", "()Ljava/lang/String;", "timeZoneJsonValue", "getTimeZoneJsonValue", "timeZoneMappingValue", "getTimeZoneMappingValue", "onPremTimeZoneWithOffset", "getOnPremTimeZoneWithOffset", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "migrateToSaaS"})
    public static final class MissingInOnPremise
    implements TimeZoneItemWrapper {
        @NotNull
        private final String originalTimeZone;
        @NotNull
        private final String timeZoneValue;
        @NotNull
        private final String timeZoneJsonValue;
        @NotNull
        private final String timeZoneMappingValue;
        @NotNull
        private final String onPremTimeZoneWithOffset;

        public MissingInOnPremise(@NotNull String originalTimeZone) {
            Intrinsics.checkNotNullParameter((Object)originalTimeZone, (String)"originalTimeZone");
            this.originalTimeZone = originalTimeZone;
            this.timeZoneValue = "N/A";
            this.timeZoneJsonValue = this.originalTimeZone;
            this.timeZoneMappingValue = "Unknown-Timezone";
            this.onPremTimeZoneWithOffset = "";
        }

        @Override
        @NotNull
        public String getTimeZoneValue() {
            return this.timeZoneValue;
        }

        @Override
        @NotNull
        public String getTimeZoneJsonValue() {
            return this.timeZoneJsonValue;
        }

        @Override
        @NotNull
        public String getTimeZoneMappingValue() {
            return this.timeZoneMappingValue;
        }

        @Override
        @NotNull
        public String getOnPremTimeZoneWithOffset() {
            return this.onPremTimeZoneWithOffset;
        }

        private final String component1() {
            return this.originalTimeZone;
        }

        @NotNull
        public final MissingInOnPremise copy(@NotNull String originalTimeZone) {
            Intrinsics.checkNotNullParameter((Object)originalTimeZone, (String)"originalTimeZone");
            return new MissingInOnPremise(originalTimeZone);
        }

        public static /* synthetic */ MissingInOnPremise copy$default(MissingInOnPremise missingInOnPremise, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = missingInOnPremise.originalTimeZone;
            }
            return missingInOnPremise.copy(string);
        }

        @NotNull
        public String toString() {
            return "MissingInOnPremise(originalTimeZone=" + this.originalTimeZone + ")";
        }

        public int hashCode() {
            return this.originalTimeZone.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MissingInOnPremise)) {
                return false;
            }
            MissingInOnPremise missingInOnPremise = (MissingInOnPremise)other;
            return Intrinsics.areEqual((Object)this.originalTimeZone, (Object)missingInOnPremise.originalTimeZone);
        }

        @Override
        @NotNull
        public String formatOnPremTimeZone(@Nullable TimeZoneItem onPremTzItem) {
            return TimeZoneItemWrapper.DefaultImpls.formatOnPremTimeZone(this, onPremTzItem);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0014\u0010\u0010\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u0014\u0010\u0012\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0014\u0010\u0014\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\n\u00a8\u0006!"}, d2={"Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$MissingTimeZoneMapping;", "Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$TimeZoneItemWrapper;", "originalTimeZone", "", "helixTz", "Lcom/bmc/ctmconvert/configuration/TimeZoneItem;", "onPremTzItem", "<init>", "(Ljava/lang/String;Lcom/bmc/ctmconvert/configuration/TimeZoneItem;Lcom/bmc/ctmconvert/configuration/TimeZoneItem;)V", "getOriginalTimeZone", "()Ljava/lang/String;", "getHelixTz", "()Lcom/bmc/ctmconvert/configuration/TimeZoneItem;", "getOnPremTzItem", "timeZoneValue", "getTimeZoneValue", "timeZoneJsonValue", "getTimeZoneJsonValue", "timeZoneMappingValue", "getTimeZoneMappingValue", "onPremTimeZoneWithOffset", "getOnPremTimeZoneWithOffset", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "migrateToSaaS"})
    public static final class MissingTimeZoneMapping
    implements TimeZoneItemWrapper {
        @NotNull
        private final String originalTimeZone;
        @NotNull
        private final TimeZoneItem helixTz;
        @Nullable
        private final TimeZoneItem onPremTzItem;
        @NotNull
        private final String timeZoneValue;
        @NotNull
        private final String timeZoneJsonValue;
        @NotNull
        private final String timeZoneMappingValue;
        @NotNull
        private final String onPremTimeZoneWithOffset;

        public MissingTimeZoneMapping(@NotNull String originalTimeZone, @NotNull TimeZoneItem helixTz, @Nullable TimeZoneItem onPremTzItem) {
            Intrinsics.checkNotNullParameter((Object)originalTimeZone, (String)"originalTimeZone");
            Intrinsics.checkNotNullParameter((Object)helixTz, (String)"helixTz");
            this.originalTimeZone = originalTimeZone;
            this.helixTz = helixTz;
            this.onPremTzItem = onPremTzItem;
            this.timeZoneValue = this.helixTz.getId();
            this.timeZoneJsonValue = this.getTimeZoneValue();
            this.timeZoneMappingValue = this.getTimeZoneJsonValue();
            this.onPremTimeZoneWithOffset = this.formatOnPremTimeZone(this.onPremTzItem);
        }

        @NotNull
        public final String getOriginalTimeZone() {
            return this.originalTimeZone;
        }

        @NotNull
        public final TimeZoneItem getHelixTz() {
            return this.helixTz;
        }

        @Nullable
        public final TimeZoneItem getOnPremTzItem() {
            return this.onPremTzItem;
        }

        @Override
        @NotNull
        public String getTimeZoneValue() {
            return this.timeZoneValue;
        }

        @Override
        @NotNull
        public String getTimeZoneJsonValue() {
            return this.timeZoneJsonValue;
        }

        @Override
        @NotNull
        public String getTimeZoneMappingValue() {
            return this.timeZoneMappingValue;
        }

        @Override
        @NotNull
        public String getOnPremTimeZoneWithOffset() {
            return this.onPremTimeZoneWithOffset;
        }

        @NotNull
        public final String component1() {
            return this.originalTimeZone;
        }

        @NotNull
        public final TimeZoneItem component2() {
            return this.helixTz;
        }

        @Nullable
        public final TimeZoneItem component3() {
            return this.onPremTzItem;
        }

        @NotNull
        public final MissingTimeZoneMapping copy(@NotNull String originalTimeZone, @NotNull TimeZoneItem helixTz, @Nullable TimeZoneItem onPremTzItem) {
            Intrinsics.checkNotNullParameter((Object)originalTimeZone, (String)"originalTimeZone");
            Intrinsics.checkNotNullParameter((Object)helixTz, (String)"helixTz");
            return new MissingTimeZoneMapping(originalTimeZone, helixTz, onPremTzItem);
        }

        public static /* synthetic */ MissingTimeZoneMapping copy$default(MissingTimeZoneMapping missingTimeZoneMapping, String string, TimeZoneItem timeZoneItem, TimeZoneItem timeZoneItem2, int n, Object object) {
            if ((n & 1) != 0) {
                string = missingTimeZoneMapping.originalTimeZone;
            }
            if ((n & 2) != 0) {
                timeZoneItem = missingTimeZoneMapping.helixTz;
            }
            if ((n & 4) != 0) {
                timeZoneItem2 = missingTimeZoneMapping.onPremTzItem;
            }
            return missingTimeZoneMapping.copy(string, timeZoneItem, timeZoneItem2);
        }

        @NotNull
        public String toString() {
            return "MissingTimeZoneMapping(originalTimeZone=" + this.originalTimeZone + ", helixTz=" + this.helixTz + ", onPremTzItem=" + this.onPremTzItem + ")";
        }

        public int hashCode() {
            int result = this.originalTimeZone.hashCode();
            result = result * 31 + this.helixTz.hashCode();
            result = result * 31 + (this.onPremTzItem == null ? 0 : this.onPremTzItem.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MissingTimeZoneMapping)) {
                return false;
            }
            MissingTimeZoneMapping missingTimeZoneMapping = (MissingTimeZoneMapping)other;
            if (!Intrinsics.areEqual((Object)this.originalTimeZone, (Object)missingTimeZoneMapping.originalTimeZone)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.helixTz, (Object)missingTimeZoneMapping.helixTz)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.onPremTzItem, (Object)missingTimeZoneMapping.onPremTzItem);
        }

        @Override
        @NotNull
        public String formatOnPremTimeZone(@Nullable TimeZoneItem onPremTzItem) {
            return TimeZoneItemWrapper.DefaultImpls.formatOnPremTimeZone(this, onPremTzItem);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001J\u0012\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0012\u0010\n\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005\u0082\u0001\u0005\u000f\u0010\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$TimeZoneItemWrapper;", "", "timeZoneValue", "", "getTimeZoneValue", "()Ljava/lang/String;", "timeZoneJsonValue", "getTimeZoneJsonValue", "timeZoneMappingValue", "getTimeZoneMappingValue", "onPremTimeZoneWithOffset", "getOnPremTimeZoneWithOffset", "formatOnPremTimeZone", "onPremTzItem", "Lcom/bmc/ctmconvert/configuration/TimeZoneItem;", "Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$InvalidMapping;", "Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$MissingInHelix;", "Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$MissingInOnPremise;", "Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$MissingTimeZoneMapping;", "Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$TimeZoneItemWrapperImpl;", "migrateToSaaS"})
    public static sealed interface TimeZoneItemWrapper
    permits InvalidMapping, MissingInHelix, MissingInOnPremise, MissingTimeZoneMapping, TimeZoneItemWrapperImpl {
        @NotNull
        public String getTimeZoneValue();

        @NotNull
        public String getTimeZoneJsonValue();

        @NotNull
        public String getTimeZoneMappingValue();

        @NotNull
        public String getOnPremTimeZoneWithOffset();

        @NotNull
        public String formatOnPremTimeZone(@Nullable TimeZoneItem var1);

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @NotNull
            public static String formatOnPremTimeZone(@NotNull TimeZoneItemWrapper $this, @Nullable TimeZoneItem onPremTzItem) {
                return onPremTzItem != null ? "(" + onPremTzItem.getCode() + onPremTzItem.getFromOffsetSign() + onPremTzItem.getFromOffsetHours() + ":" + onPremTzItem.getFromOffsetMinutes() + ")" : "";
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0010\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$TimeZoneItemWrapperImpl;", "Lcom/bmc/ctmconvert/migration/steps/TimeZoneStep$TimeZoneItemWrapper;", "timeZoneValue", "", "onPremTzItem", "Lcom/bmc/ctmconvert/configuration/TimeZoneItem;", "<init>", "(Ljava/lang/String;Lcom/bmc/ctmconvert/configuration/TimeZoneItem;)V", "getTimeZoneValue", "()Ljava/lang/String;", "getOnPremTzItem", "()Lcom/bmc/ctmconvert/configuration/TimeZoneItem;", "timeZoneJsonValue", "getTimeZoneJsonValue", "timeZoneMappingValue", "getTimeZoneMappingValue", "onPremTimeZoneWithOffset", "getOnPremTimeZoneWithOffset", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "migrateToSaaS"})
    public static final class TimeZoneItemWrapperImpl
    implements TimeZoneItemWrapper {
        @NotNull
        private final String timeZoneValue;
        @Nullable
        private final TimeZoneItem onPremTzItem;
        @NotNull
        private final String timeZoneJsonValue;
        @NotNull
        private final String timeZoneMappingValue;
        @NotNull
        private final String onPremTimeZoneWithOffset;

        public TimeZoneItemWrapperImpl(@NotNull String timeZoneValue, @Nullable TimeZoneItem onPremTzItem) {
            Intrinsics.checkNotNullParameter((Object)timeZoneValue, (String)"timeZoneValue");
            this.timeZoneValue = timeZoneValue;
            this.onPremTzItem = onPremTzItem;
            this.timeZoneJsonValue = this.getTimeZoneValue();
            this.timeZoneMappingValue = this.getTimeZoneJsonValue();
            this.onPremTimeZoneWithOffset = this.formatOnPremTimeZone(this.onPremTzItem);
        }

        @Override
        @NotNull
        public String getTimeZoneValue() {
            return this.timeZoneValue;
        }

        @Nullable
        public final TimeZoneItem getOnPremTzItem() {
            return this.onPremTzItem;
        }

        @Override
        @NotNull
        public String getTimeZoneJsonValue() {
            return this.timeZoneJsonValue;
        }

        @Override
        @NotNull
        public String getTimeZoneMappingValue() {
            return this.timeZoneMappingValue;
        }

        @Override
        @NotNull
        public String getOnPremTimeZoneWithOffset() {
            return this.onPremTimeZoneWithOffset;
        }

        @NotNull
        public final String component1() {
            return this.timeZoneValue;
        }

        @Nullable
        public final TimeZoneItem component2() {
            return this.onPremTzItem;
        }

        @NotNull
        public final TimeZoneItemWrapperImpl copy(@NotNull String timeZoneValue, @Nullable TimeZoneItem onPremTzItem) {
            Intrinsics.checkNotNullParameter((Object)timeZoneValue, (String)"timeZoneValue");
            return new TimeZoneItemWrapperImpl(timeZoneValue, onPremTzItem);
        }

        public static /* synthetic */ TimeZoneItemWrapperImpl copy$default(TimeZoneItemWrapperImpl timeZoneItemWrapperImpl, String string, TimeZoneItem timeZoneItem, int n, Object object) {
            if ((n & 1) != 0) {
                string = timeZoneItemWrapperImpl.timeZoneValue;
            }
            if ((n & 2) != 0) {
                timeZoneItem = timeZoneItemWrapperImpl.onPremTzItem;
            }
            return timeZoneItemWrapperImpl.copy(string, timeZoneItem);
        }

        @NotNull
        public String toString() {
            return "TimeZoneItemWrapperImpl(timeZoneValue=" + this.timeZoneValue + ", onPremTzItem=" + this.onPremTzItem + ")";
        }

        public int hashCode() {
            int result = this.timeZoneValue.hashCode();
            result = result * 31 + (this.onPremTzItem == null ? 0 : this.onPremTzItem.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimeZoneItemWrapperImpl)) {
                return false;
            }
            TimeZoneItemWrapperImpl timeZoneItemWrapperImpl = (TimeZoneItemWrapperImpl)other;
            if (!Intrinsics.areEqual((Object)this.timeZoneValue, (Object)timeZoneItemWrapperImpl.timeZoneValue)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.onPremTzItem, (Object)timeZoneItemWrapperImpl.onPremTzItem);
        }

        @Override
        @NotNull
        public String formatOnPremTimeZone(@Nullable TimeZoneItem onPremTzItem) {
            return TimeZoneItemWrapper.DefaultImpls.formatOnPremTimeZone(this, onPremTzItem);
        }
    }
}

