/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.migration.steps;

import com.bmc.ctmconvert.GlobalVariableFinder;
import com.bmc.ctmconvert.GlobalVariableUpdater;
import com.bmc.ctmconvert.json.Folders;
import com.bmc.ctmconvert.migration.MigrationAction;
import com.bmc.ctmconvert.migration.steps.MigrationData;
import com.bmc.ctmconvert.migration.steps.MigrationStep;
import com.bmc.ctmconvert.migration.steps.StepResult;
import com.bmc.ctmconvert.qualifyUtils.QualificationSummary;
import com.bmc.ctmconvert.qualifyUtils.SheetData;
import com.bmc.ctmconvert.qualifyUtils.TestStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/bmc/ctmconvert/migration/steps/GlobalVariableStep;", "Lcom/bmc/ctmconvert/migration/steps/MigrationStep;", "<init>", "()V", "sheets", "", "Lcom/bmc/ctmconvert/qualifyUtils/SheetData;", "longVarCount", "", "migrate", "Lcom/bmc/ctmconvert/migration/MigrationAction;", "migrationData", "Lcom/bmc/ctmconvert/migration/steps/MigrationData;", "createVariablesSheet", "allVars", "Lcom/bmc/ctmconvert/GlobalVariableFinder$GlobalVariableJobsPath;", "getSheets", "getSummary", "Lcom/bmc/ctmconvert/qualifyUtils/QualificationSummary;", "Companion", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nGlobalVariableStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalVariableStep.kt\ncom/bmc/ctmconvert/migration/steps/GlobalVariableStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1368#2:81\n1454#2,5:82\n774#2:87\n865#2,2:88\n1368#2:90\n1454#2,5:91\n1557#2:96\n1628#2,3:97\n*S KotlinDebug\n*F\n+ 1 GlobalVariableStep.kt\ncom/bmc/ctmconvert/migration/steps/GlobalVariableStep\n*L\n57#1:81\n57#1:82,5\n57#1:87\n57#1:88,2\n63#1:90\n63#1:91,5\n63#1:96\n63#1:97,3\n*E\n"})
public final class GlobalVariableStep
implements MigrationStep {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<SheetData> sheets = CollectionsKt.emptyList();
    private int longVarCount;
    @NotNull
    public static final String globalVariableStepName = "Global variables were replaced with pool variables in the pool 'global'";
    private static final int MAX_VAR_LENGTH = 38;
    @NotNull
    public static final String VAR_NAME_LENGTH_EXCEEDS = "Global variable name exceeds 38 characters, can not be converted to pool variable";

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<MigrationAction> migrate(@NotNull MigrationData migrationData) {
        Intrinsics.checkNotNullParameter((Object)migrationData, (String)"migrationData");
        Folders folders = migrationData.getData().getFolders().getFolder();
        GlobalVariableFinder globalVariablesFinder = new GlobalVariableFinder(folders, migrationData.getConfiguration().getSystemVariableConfiguration(), migrationData.getConfiguration().getBuiltInFunctionsListConfiguration(), migrationData.getArguments().getLibmemsymControlMFilePath());
        List<GlobalVariableFinder.GlobalVariableJobsPath> globalVariablesUsagesPathsResult = globalVariablesFinder.getAllGlobalVariablesUsages();
        ArrayList<GlobalVariableFinder.GlobalVariableJobsPath> globalVariablesDefinitionsPathsResult = globalVariablesFinder.getAllGlobalVariablesDefinitions();
        new GlobalVariableUpdater().updateGlobalVariablesUsages(folders, globalVariablesUsagesPathsResult);
        new GlobalVariableUpdater().updateGlobalVariablesDefinitions(folders, (List<GlobalVariableFinder.GlobalVariableJobsPath>)globalVariablesDefinitionsPathsResult);
        List allVars = CollectionsKt.plus((Collection)globalVariablesUsagesPathsResult, (Iterable)globalVariablesDefinitionsPathsResult);
        if (!((Collection)allVars).isEmpty()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object it;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            this.sheets = this.createVariablesSheet(allVars);
            Iterable iterable = allVars;
            GlobalVariableStep globalVariableStep = this;
            boolean $i$f$flatMap = false;
            void var9_10 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (GlobalVariableFinder.GlobalVariableJobsPath)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ((GlobalVariableFinder.GlobalVariableJobsPath)it).getGlobalVariableList();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!(((String)it).length() > 38)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            globalVariableStep.longVarCount = ((List)destination$iv$iv).size();
        }
        return CollectionsKt.listOf((Object)new MigrationAction(globalVariableStepName, allVars.size()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<SheetData> createVariablesSheet(List<GlobalVariableFinder.GlobalVariableJobsPath> allVars) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        GlobalVariableFinder.GlobalVariableJobsPath it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = allVars;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (GlobalVariableFinder.GlobalVariableJobsPath)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getGlobalVariableList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{it, ((String)((Object)it)).length() > 38 ? VAR_NAME_LENGTH_EXCEEDS : ""};
            collection.add(CollectionsKt.listOf((Object[])objectArray));
        }
        List rows = (List)destination$iv$iv;
        Object[] objectArray = new String[]{"Variable Name", "Comments"};
        return CollectionsKt.listOf((Object)new SheetData("Global Variables", CollectionsKt.listOf((Object[])objectArray), rows));
    }

    @Override
    @NotNull
    public List<SheetData> getSheets(@NotNull MigrationData migrationData) {
        Intrinsics.checkNotNullParameter((Object)migrationData, (String)"migrationData");
        return this.sheets;
    }

    @Override
    @NotNull
    public List<QualificationSummary> getSummary() {
        return this.longVarCount > 0 ? CollectionsKt.listOf((Object)Companion.makeSummary(this.longVarCount)) : CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public StepResult stepResults() {
        return MigrationStep.DefaultImpls.stepResults(this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/bmc/ctmconvert/migration/steps/GlobalVariableStep$Companion;", "", "<init>", "()V", "globalVariableStepName", "", "MAX_VAR_LENGTH", "", "VAR_NAME_LENGTH_EXCEEDS", "makeSummary", "Lcom/bmc/ctmconvert/qualifyUtils/QualificationSummary;", "longVarCount", "migrateToSaaS"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QualificationSummary makeSummary(int longVarCount) {
            return new QualificationSummary("Global variable name does not exceed 38 characters", TestStatus.Incompatibility found, "Global variables with names exceeding 38 characters were found.", String.valueOf(longVarCount), "Global variables are not supported in Control-M SaaS. During the migration those variables need to be converted to pool variables.\nBecause Pool variable names has a limitation of 38 characters, variables with longer names can not be converted.\nIt is suggested to find all usages of these variables and rename them to a shorter name.\nFor a list of these variables see the Global Variables sheet.", 1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

