/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.configuration;

import com.bmc.ctmconvert.configuration.TimeZoneFile;
import com.bmc.ctmconvert.configuration.TimeZoneItem;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\tH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\r\u001a\u00020\u0003J\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000f0\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/bmc/ctmconvert/configuration/HelixTimeZones;", "", "timeZoneFileContent", "", "<init>", "(Ljava/lang/String;)V", "json", "Lkotlinx/serialization/json/Json;", "timeZones", "Lcom/bmc/ctmconvert/configuration/TimeZoneFile;", "readTimeZones", "isSupportedHelixTimeZoneValue", "", "timeZone", "getByCtmCode", "", "Lcom/bmc/ctmconvert/configuration/TimeZoneItem;", "getAllTimeZonesDetails", "Companion", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nTimeZonesMigrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeZonesMigrator.kt\ncom/bmc/ctmconvert/configuration/HelixTimeZones\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1755#2,3:183\n774#2:186\n865#2,2:187\n1557#2:189\n1628#2,3:190\n*S KotlinDebug\n*F\n+ 1 TimeZonesMigrator.kt\ncom/bmc/ctmconvert/configuration/HelixTimeZones\n*L\n58#1:183,3\n59#1:186\n59#1:187,2\n60#1:189\n60#1:190,3\n*E\n"})
public final class HelixTimeZones {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String timeZoneFileContent;
    @NotNull
    private final Json json;
    @NotNull
    private final TimeZoneFile timeZones;

    public HelixTimeZones(@NotNull String timeZoneFileContent) {
        Intrinsics.checkNotNullParameter((Object)timeZoneFileContent, (String)"timeZoneFileContent");
        this.timeZoneFileContent = timeZoneFileContent;
        this.json = JsonKt.Json$default(null, HelixTimeZones::json$lambda$0, (int)1, null);
        this.timeZones = this.readTimeZones();
    }

    public /* synthetic */ HelixTimeZones(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = Companion.getDefaultTimeZonePath();
        }
        this(string);
    }

    private final TimeZoneFile readTimeZones() {
        return (TimeZoneFile)this.json.decodeFromString((DeserializationStrategy)TimeZoneFile.Companion.serializer(), this.timeZoneFileContent);
    }

    public final boolean isSupportedHelixTimeZoneValue(@NotNull String timeZone) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
            Iterable $this$any$iv = this.timeZones.getData();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TimeZoneItem it = (TimeZoneItem)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)timeZone)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TimeZoneItem> getByCtmCode(@NotNull String timeZone) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        Iterable $this$filter$iv = this.timeZones.getData();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TimeZoneItem it = (TimeZoneItem)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getCtmCode(), (Object)timeZone)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<String>> getAllTimeZonesDetails() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.timeZones.getData();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TimeZoneItem timeZoneItem = (TimeZoneItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{it.getId(), it.getName(), it.offset(), it.dstString()};
            collection.add(CollectionsKt.listOf((Object[])objectArray));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    public HelixTimeZones() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/bmc/ctmconvert/configuration/HelixTimeZones$Companion;", "", "<init>", "()V", "getDefaultTimeZonePath", "", "migrateToSaaS"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultTimeZonePath() {
            String string = Files.readString(Paths.get("./data/SaasTimeZone.json", new String[0]));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

