/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.agentscoping;

import arrow.core.Either;
import com.bmc.ctmconvert.Arguments;
import com.bmc.ctmconvert.ArgumentsValidationResult;
import com.bmc.ctmconvert.DataExtractor;
import com.bmc.ctmconvert.ExtractedData;
import com.bmc.ctmconvert.Factory;
import com.bmc.ctmconvert.MainKt;
import com.bmc.ctmconvert.OutputManager;
import com.bmc.ctmconvert.ValidatedArguments;
import com.bmc.ctmconvert.ValidatedQualificationOrMigrationArguments;
import com.bmc.ctmconvert.agentscoping.AgentsScopingFeature;
import com.bmc.ctmconvert.agentscoping.AgentsScopingMainKt;
import com.bmc.ctmconvert.databaseCommon.DataBaseFailure;
import com.bmc.ctmconvert.databaseCommon.EmDatabase;
import com.bmc.ctmconvert.qualifiction.QualificationReportResults;
import java.time.LocalDate;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Database;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/bmc/ctmconvert/agentscoping/AgentsScopingMain;", "", "factory", "Lcom/bmc/ctmconvert/Factory;", "<init>", "(Lcom/bmc/ctmconvert/Factory;)V", "getFactory", "()Lcom/bmc/ctmconvert/Factory;", "run", "", "arguments", "Lcom/bmc/ctmconvert/Arguments;", "dbConnection", "Lorg/jetbrains/exposed/sql/Database;", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nAgentsScopingMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentsScopingMain.kt\ncom/bmc/ctmconvert/agentscoping/AgentsScopingMain\n+ 2 Either.kt\narrow/core/Either\n+ 3 Either.kt\narrow/core/EitherKt\n+ 4 predef.kt\narrow/core/PredefKt\n*L\n1#1,61:1\n804#2,4:62\n804#2,2:67\n806#2,2:70\n1248#3:66\n5#4:69\n*S KotlinDebug\n*F\n+ 1 AgentsScopingMain.kt\ncom/bmc/ctmconvert/agentscoping/AgentsScopingMain\n*L\n41#1:62,4\n47#1:67,2\n47#1:70,2\n47#1:66\n47#1:69\n*E\n"})
public final class AgentsScopingMain {
    @NotNull
    private final Factory factory;

    public AgentsScopingMain(@NotNull Factory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.factory = factory;
    }

    @NotNull
    public final Factory getFactory() {
        return this.factory;
    }

    public final int run(@NotNull Arguments arguments, @NotNull Database dbConnection) {
        int n;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)dbConnection, (String)"dbConnection");
        int it = n = MainKt.handleExceptions(this.factory.getSpinner(), this.factory.getPrinter(), this.factory.getLogger(), (Function0<Integer>)((Function0)() -> AgentsScopingMain.run$lambda$3(this, arguments, dbConnection)));
        boolean bl = false;
        this.factory.getPrinter().print("Agents Qualification Tool finished");
        AgentsScopingMainKt.getSpinner().stop();
        return n;
    }

    private static final int run$lambda$3(AgentsScopingMain this$0, Arguments $arguments, Database $dbConnection) {
        int n;
        AgentsScopingMainKt.getSpinner().start();
        this$0.factory.getPrinter().print("Agents Qualification Tool started for server " + $arguments.getControl-m-server-name());
        ArgumentsValidationResult validatedArguments = this$0.factory.getArgumentsValidation().validateArgumentsForAgentsScoping($arguments, this$0.factory.getFileSystem(), $dbConnection);
        if (validatedArguments instanceof ValidatedArguments) {
            Object object;
            String string;
            ValidatedQualificationOrMigrationArguments validArgs = ((ValidatedArguments)validatedArguments).toQualificationValidatedArguments();
            this$0.factory.getPrinter().print("Extracting data");
            EmDatabase emDatabase = this$0.factory.emDatabase($dbConnection);
            ExtractedData extractedData = new DataExtractor(this$0.factory.getLogger()).extractAgentsRelatedData($arguments, validArgs.getApiClientOnPrem(), validArgs.getAapiVersion(), emDatabase);
            this$0.factory.getPrinter().print("Running qualifications tests");
            LocalDateTime localDateTime = LocalDateTime.now();
            long l = this$0.factory.getConfiguration().getDaysOfExecutionsHistoryToFetch-UwyO8pc();
            int n2 = Duration.getNanosecondsComponent-impl((long)l);
            long l2 = Duration.getInWholeSeconds-impl((long)l);
            java.time.Duration duration = java.time.Duration.ofSeconds(l2, n2);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
            LocalDate executionsHistoryFromRange = localDateTime.minus(duration).toLocalDate();
            Factory factory = this$0.factory;
            Intrinsics.checkNotNull((Object)executionsHistoryFromRange);
            QualificationReportResults results = factory.qualificationEngine($arguments, extractedData, emDatabase, new AgentsScopingFeature(executionsHistoryFromRange)).qualify(false);
            this$0.factory.getPrinter().print("Writing " + AgentsScopingMainKt.agentScopingReportName($arguments.getControl-m-server-name()) + " report");
            Either this_$iv = emDatabase.getRunInfoHistoryRange($arguments.getControl-m-server-name(), executionsHistoryFromRange);
            boolean $i$f$fold = false;
            Either either = this_$iv;
            if (either instanceof Either.Right) {
                Pair runInfoHistoryDataRange = (Pair)((Either.Right)this_$iv).getValue();
                boolean bl = false;
                string = AgentsScopingMainKt.access$toReadableString(runInfoHistoryDataRange);
            } else if (either instanceof Either.Left) {
                DataBaseFailure it = (DataBaseFailure)((Either.Left)this_$iv).getValue();
                boolean bl = false;
                string = "";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String rangeOfRunInfoHistory = string;
            OutputManager outputManager = this$0.factory.getOutputManager();
            Arguments arguments = $arguments;
            QualificationReportResults qualificationReportResults = results;
            String string2 = this$0.factory.getConfiguration().getVersion();
            String string3 = validArgs.getAapiVersion();
            Either $this$getOrElse$iv = emDatabase.getEmVersion();
            boolean $i$f$getOrElse = false;
            Either this_$iv$iv = $this$getOrElse$iv;
            boolean $i$f$fold2 = false;
            Either either2 = this_$iv$iv;
            if (either2 instanceof Either.Right) {
                Object p0$iv = ((Either.Right)this_$iv$iv).getValue();
                boolean bl = false;
                boolean $i$f$identity = false;
                object = p0$iv;
            } else if (either2 instanceof Either.Left) {
                Object it$iv = ((Either.Left)this_$iv$iv).getValue();
                boolean bl = false;
                String string4 = string3;
                String string5 = string2;
                QualificationReportResults qualificationReportResults2 = qualificationReportResults;
                Arguments arguments2 = arguments;
                OutputManager outputManager2 = outputManager;
                boolean bl2 = false;
                String string6 = "N/A";
                outputManager = outputManager2;
                arguments = arguments2;
                qualificationReportResults = qualificationReportResults2;
                string2 = string5;
                string3 = string4;
                object = string6;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            OutputManager.writeAgentsQualificationReport$default(outputManager, arguments, qualificationReportResults, string2, string3, (String)object, null, rangeOfRunInfoHistory, 32, null);
            n = 1;
        } else {
            n = 2;
        }
        return n;
    }
}

